import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M18.6617 29.8144C26.814 24.8744 31 19.6305 31 14.0053C31 6.00484 22.2263 3.48819 18 8.80942C13.7737 3.48819 5 6.00484 5 14.0053C5 19.6305 9.1847 24.8731 17.3383 29.8144C17.5387 29.9359 17.7672 30 18 30C18.2328 30 18.4613 29.9359 18.6617 29.8144ZM19.1843 11.4109C21.4801 6.20965 28.8638 8.06295 28.8638 14.0053C28.8638 18.3415 24.9992 23.4407 18 27.8182C11.0021 23.4394 7.12782 18.3428 7.12782 14.0053C7.12782 8.06162 14.5199 6.20965 16.8157 11.4109C17.2772 12.456 18.7228 12.456 19.1843 11.4109Z"
            fill={props.fill}
        />
    </svg>
);

HeartOutlineIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default HeartOutlineIcon;
