import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#21f69bfa__clip0_20742_4793)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.4604 27.5891C7.86407 24.6361 3.78955 21.2904 3.78955 14.4C3.78955 6.444 10.1518 0 18.0001 0C25.8483 0 32.2106 6.4471 32.2106 14.4C32.2106 21.3033 28.1383 24.653 24.5418 27.6113C21.8865 29.7954 19.4905 31.7662 19.1843 34.7963L19.1711 34.9272C19.1095 35.5366 18.603 36 17.9985 36C17.392 36 16.885 35.5327 16.8276 34.9209L16.8159 34.7963C16.5313 31.7529 14.1273 29.779 11.4604 27.5891ZM21.7895 14.2105C21.7895 16.3034 20.0929 18 18 18C15.9072 18 14.2106 16.3034 14.2106 14.2105C14.2106 12.1176 15.9072 10.421 18 10.421C20.0929 10.421 21.7895 12.1176 21.7895 14.2105Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="21f69bfa__clip0_20742_4793">
                <rect width={36} height={36} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

LocationIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default LocationIcon;
