import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const QuarantineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M17.1531 6.33393C17.3468 6.14748 17.6532 6.14748 17.8468 6.33393L30.1067 18.1398C30.4309 18.4519 30.2099 19 29.7599 19H19.95C19.9828 18.8384 20 18.6712 20 18.5C20 17.1193 18.8807 16 17.5 16C16.1193 16 15 17.1193 15 18.5C15 18.6712 15.0172 18.8384 15.05 19H5.24002C4.79 19 4.56904 18.4519 4.8932 18.1398L17.1531 6.33393ZM15.05 19H8V29.5C8 29.7761 8.22386 30 8.5 30H26.5C26.7761 30 27 29.7761 27 29.5V19H19.95C19.7184 20.1411 18.7095 21 17.5 21C16.2905 21 15.2816 20.1411 15.05 19ZM13 24C13 22.8954 13.8954 22 15 22H20C21.1046 22 22 22.8954 22 24V27.5C22 27.7761 21.7761 28 21.5 28H13.5C13.2239 28 13 27.7761 13 27.5V24Z"
            fill={props.fill}
        />
    </svg>
);

QuarantineIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default QuarantineIcon;
