import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M24.8985 12.1502C26.0311 12.1502 26.9492 11.2323 26.9492 10.1001C26.9492 8.96789 26.0311 8.05005 24.8985 8.05005C23.7658 8.05005 22.8477 8.96789 22.8477 10.1001C22.8477 11.2323 23.7658 12.1502 24.8985 12.1502ZM24.8985 14.2002C27.1637 14.2002 29 12.3645 29 10.1001C29 7.83568 27.1637 6 24.8985 6C22.6332 6 20.7969 7.83568 20.7969 10.1001C20.7969 10.4039 20.83 10.6999 20.8926 10.9848L13.8733 14.9548C13.1434 14.2854 12.1702 13.8769 11.1015 13.8769C8.83632 13.8769 7 15.7126 7 17.977C7 20.2414 8.83632 22.0771 11.1015 22.0771C12.113 22.0771 13.0389 21.7111 13.7541 21.1044L20.8815 25.0677C20.826 25.3364 20.7969 25.6148 20.7969 25.8999C20.7969 28.1643 22.6332 30 24.8985 30C27.1637 30 29 28.1643 29 25.8999C29 23.6355 27.1637 21.7998 24.8985 21.7998C23.6551 21.7998 22.5409 22.3529 21.7888 23.2263L14.9422 19.4192C15.1108 18.9705 15.2031 18.4845 15.2031 17.977C15.2031 17.5226 15.1292 17.0856 14.9927 16.6771L21.8237 12.8137C22.5752 13.664 23.6742 14.2002 24.8985 14.2002ZM24.8985 27.9499C26.0311 27.9499 26.9492 27.0321 26.9492 25.8999C26.9492 24.7677 26.0311 23.8498 24.8985 23.8498C23.7658 23.8498 22.8477 24.7677 22.8477 25.8999C22.8477 27.0321 23.7658 27.9499 24.8985 27.9499ZM13.1523 17.977C13.1523 19.1092 12.2342 20.027 11.1015 20.027C9.96894 20.027 9.05077 19.1092 9.05077 17.977C9.05077 16.8448 9.96894 15.9269 11.1015 15.9269C12.2342 15.9269 13.1523 16.8448 13.1523 17.977Z"
            fill={props.fill}
        />
    </svg>
);

ShareOutlineIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default ShareOutlineIcon;
