import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M18 30C24.6276 30 30 24.6276 30 18C30 11.3724 24.6276 6 18 6C11.3724 6 6 11.3724 6 18C6 24.6276 11.3724 30 18 30ZM16.2 23.9892C16.2 22.9488 16.9908 22.2 17.9892 22.2C19.0092 22.2 19.8 22.9488 19.8 23.9892C19.8 25.0296 19.0092 25.8 17.9892 25.8C16.9908 25.8 16.2 25.0296 16.2 23.9892ZM17.0064 10.8C16.9254 10.8001 16.8453 10.8166 16.7709 10.8484C16.6965 10.8803 16.6293 10.9269 16.5733 10.9854C16.5174 11.0439 16.4738 11.1132 16.4454 11.189C16.4169 11.2647 16.404 11.3455 16.4076 11.4264L16.7748 19.8264C16.7816 19.9809 16.8478 20.1268 16.9596 20.2337C17.0714 20.3406 17.2201 20.4002 17.3748 20.4H18.6264C18.7811 20.4002 18.9298 20.3406 19.0416 20.2337C19.1534 20.1268 19.2196 19.9809 19.2264 19.8264L19.5924 11.4264C19.596 11.3454 19.5831 11.2645 19.5545 11.1887C19.526 11.1128 19.4824 11.0435 19.4263 10.985C19.3702 10.9264 19.3028 10.8799 19.2283 10.8481C19.1537 10.8163 19.0735 10.7999 18.9924 10.8H17.0064Z"
            fill={props.fill}
        />
    </svg>
);

WarningFilledIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default WarningFilledIcon;
