import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AlarmLightM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 190 128"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M161.184 107H77.9031C61.5697 107 66.067 89.2629 75.2904 86.3996C82.6939 84.0765 86.5981 86.6203 86.5981 86.6203C86.5981 86.6203 90.7079 68.5753 104.64 68.0352C108.563 67.8117 112.473 68.6555 115.945 70.4749C119.418 72.2943 122.32 75.0199 124.337 78.3557C124.337 78.3557 133.502 71.9671 145.168 77.6472C156.834 83.3272 155.466 92.4572 155.466 92.4572C155.466 92.4572 162.558 90.3025 168.506 94.6119C174.453 98.9213 173.308 107 161.184 107Z"
            fill="#EDF2F7"
        />
        <path
            d="M108.079 69.5638H24.5282C3.8996 69.5638 13.2067 47.1994 21.0048 45.5543C28.8029 43.9092 34.0814 46.9209 34.0814 46.9209C34.0814 46.9209 37.6501 28.5657 53.026 28.0217C68.4019 27.4776 73.0328 37.3612 73.0328 37.3612C73.0328 37.3612 80.6949 31.5321 92.6187 39.0063C100.902 44.1877 101.757 51.8886 101.757 51.8886C101.757 51.8886 109.53 49.6995 116.097 54.0843C122.664 58.469 121.376 69.5638 108.079 69.5638Z"
            fill="#EDF2F7"
        />
        <path
            d="M142.551 80.788C148.962 55.01 134.023 29.1022 108.245 22.6987C78.1134 15.1813 55.6226 31.8017 49.1918 57.5523C42.761 83.3029 58.2947 110.174 84.0453 116.605C109.796 123.036 136.141 106.573 142.551 80.788Z"
            fill="#E31740"
        />
        <path
            d="M136.818 79.3595C143.228 53.5816 128.289 27.6738 102.504 21.2703C72.3796 13.7528 49.882 30.3732 43.4512 56.1238C37.0204 81.8744 52.5541 108.746 78.3389 115.183C104.124 121.621 130.407 105.144 136.818 79.3595Z"
            fill="#FF3737"
        />
        <path
            d="M129.006 77.4865C134.35 56.0072 121.906 34.4322 100.426 29.088C75.3248 22.8553 56.5654 36.6669 51.228 58.1462C45.8907 79.6256 58.8138 102.007 80.2863 107.351C101.759 112.695 123.669 98.9659 129.006 77.4865Z"
            fill="#DAE7F2"
        />
        <path
            d="M131.043 78.1572C136.38 56.6778 123.942 35.1028 102.456 29.7518C80.2045 24.223 58.6022 37.3375 53.258 58.8169C47.9138 80.2962 60.8437 102.671 82.3231 108.022C103.802 113.373 125.699 99.6365 131.043 78.1572Z"
            fill="white"
        />
        <path
            d="M100.03 43.0232L90.5923 68.0084"
            stroke="#18123D"
            strokeWidth={2.89043}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M119.487 56.8015L92.0276 68.6312"
            stroke="#18123D"
            strokeWidth={1.44522}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M95.7862 69.5247C95.9401 68.9547 95.9788 68.3598 95.9 67.7747C95.8213 67.1896 95.6267 66.626 95.3276 66.117C95.0286 65.608 94.631 65.1637 94.1583 64.81C93.6855 64.4564 93.147 64.2006 92.5742 64.0575C91.9942 63.875 91.3822 63.817 90.7782 63.8874C90.1742 63.9578 89.5919 64.1549 89.0694 64.4658C88.5468 64.7768 88.0959 65.1946 87.7459 65.6918C87.396 66.1891 87.155 66.7546 87.0387 67.3515C86.8896 67.9276 86.8561 68.5275 86.9402 69.1165C87.0244 69.7056 87.2244 70.2722 87.5287 70.7835C87.8331 71.2948 88.2358 71.7407 88.7135 72.0955C89.1912 72.4503 89.7345 72.7069 90.312 72.8505C90.8895 72.994 91.4896 73.0218 92.0779 72.932C92.6661 72.8423 93.2308 72.6368 93.7391 72.3276C94.2475 72.0184 94.6896 71.6114 95.0398 71.1303C95.39 70.6492 95.6414 70.1035 95.7794 69.5247H95.7862Z"
            fill="#18123D"
        />
        <path
            d="M102.224 35.7516C102.311 35.4231 102.332 35.0806 102.285 34.7439C102.238 34.4072 102.125 34.0832 101.952 33.7906C101.779 33.4981 101.55 33.2429 101.277 33.0398C101.005 32.8368 100.695 32.69 100.365 32.608C100.033 32.5032 99.6823 32.4692 99.3363 32.508C98.9902 32.5468 98.6561 32.6577 98.3555 32.8334C98.0548 33.0091 97.7943 33.2459 97.5907 33.5284C97.3871 33.8109 97.2449 34.1329 97.1733 34.4737C97.0774 34.8096 97.0502 35.1614 97.0931 35.5081C97.1361 35.8549 97.2483 36.1894 97.4233 36.4918C97.5982 36.7942 97.8322 37.0583 98.1113 37.2684C98.3905 37.4785 98.709 37.6303 99.048 37.7147C99.387 37.7991 99.7396 37.8144 100.085 37.7597C100.43 37.705 100.76 37.5815 101.057 37.3964C101.353 37.2113 101.609 36.9685 101.809 36.6824C102.01 36.3963 102.151 36.0728 102.224 35.7311V35.7516Z"
            fill="#DAE7F2"
        />
        <path
            d="M85.5212 102.931C85.6064 102.603 85.6259 102.26 85.5785 101.924C85.5311 101.588 85.4177 101.265 85.245 100.973C85.0723 100.681 84.8436 100.426 84.572 100.222C84.3004 100.019 83.9913 99.8711 83.6624 99.7874C83.3289 99.6828 82.9771 99.6495 82.6298 99.6896C82.2826 99.7296 81.9477 99.8423 81.6468 100.02C81.3459 100.198 81.0857 100.437 80.8831 100.722C80.6805 101.007 80.5401 101.331 80.4709 101.674C80.375 102.01 80.3478 102.361 80.3907 102.708C80.4337 103.055 80.546 103.389 80.7209 103.692C80.8958 103.994 81.1298 104.258 81.4089 104.468C81.6881 104.678 82.0066 104.83 82.3456 104.915C82.6847 104.999 83.0372 105.014 83.3822 104.96C83.7273 104.905 84.0578 104.781 84.3541 104.596C84.6504 104.411 84.9065 104.168 85.107 103.882C85.3075 103.596 85.4484 103.273 85.5212 102.931Z"
            fill="#DAE7F2"
        />
        <path
            d="M94.4193 69.19C94.5741 68.62 94.6135 68.0248 94.5352 67.4394C94.4569 66.854 94.2624 66.2901 93.9633 65.7808C93.6641 65.2716 93.2662 64.8272 92.7929 64.4738C92.3197 64.1204 91.7806 63.8651 91.2073 63.7228C90.6273 63.5392 90.015 63.4804 89.4107 63.5503C88.8063 63.6201 88.2236 63.8171 87.7007 64.1282C87.1779 64.4393 86.7268 64.8575 86.3771 65.3554C86.0275 65.8532 85.7871 66.4194 85.6718 67.0168C85.5291 67.5912 85.5009 68.188 85.5889 68.7733C85.6769 69.3585 85.8792 69.9207 86.1845 70.4278C86.4897 70.9348 86.8918 71.3768 87.3679 71.7284C87.8439 72.0801 88.3846 72.3345 88.9589 72.4772C89.5333 72.6199 90.1302 72.6481 90.7154 72.5601C91.3007 72.4721 91.8629 72.2697 92.3699 71.9645C92.877 71.6593 93.3189 71.2571 93.6706 70.7811C94.0222 70.305 94.2766 69.7644 94.4193 69.19Z"
            fill="#002669"
        />
        <path
            d="M124.325 79.6195C124.653 79.7046 124.996 79.7241 125.332 79.6767C125.668 79.6293 125.991 79.516 126.283 79.3433C126.575 79.1705 126.83 78.9418 127.034 78.6702C127.237 78.3986 127.385 78.0895 127.469 77.7606C127.573 77.4266 127.606 77.0744 127.566 76.7267C127.525 76.3791 127.412 76.0439 127.234 75.7429C127.055 75.4419 126.815 75.1818 126.529 74.9796C126.244 74.7774 125.919 74.6375 125.576 74.5691C125.239 74.4704 124.885 74.4409 124.536 74.4823C124.188 74.5238 123.851 74.6353 123.546 74.8103C123.242 74.9852 122.976 75.22 122.765 75.5004C122.553 75.7808 122.401 76.1011 122.316 76.442C122.232 76.7829 122.217 77.1373 122.273 77.484C122.329 77.8307 122.455 78.1624 122.643 78.4592C122.83 78.7561 123.076 79.0119 123.365 79.2113C123.654 79.4107 123.981 79.5495 124.325 79.6195Z"
            fill="#DAE7F2"
        />
        <path
            d="M57.1465 62.91C57.4746 62.9972 57.8167 63.0183 58.153 62.9722C58.4893 62.926 58.8131 62.8136 59.1056 62.6413C59.398 62.469 59.6534 62.2403 59.8567 61.9685C60.0601 61.6967 60.2074 61.3872 60.2902 61.058C60.3947 60.7235 60.4278 60.3709 60.3874 60.0228C60.3469 59.6748 60.2338 59.3391 60.0553 59.0376C59.8769 58.736 59.637 58.4754 59.3514 58.2724C59.0657 58.0695 58.7406 57.9289 58.3971 57.8596C58.0601 57.7609 57.7066 57.7314 57.3579 57.7728C57.0092 57.8143 56.6724 57.9258 56.3679 58.1008C56.0634 58.2758 55.7975 58.5105 55.5861 58.7909C55.3747 59.0714 55.2222 59.3916 55.1377 59.7325C55.0533 60.0734 55.0387 60.4279 55.0949 60.7745C55.151 61.1212 55.2767 61.4529 55.4643 61.7498C55.652 62.0466 55.8978 62.3024 56.1868 62.5018C56.4759 62.7012 56.8024 62.84 57.1465 62.91Z"
            fill="#DAE7F2"
        />
        <path
            d="M83.3687 34.5155C83.2795 34.1896 83.1267 33.8845 82.9191 33.6179C82.7115 33.3513 82.4532 33.1284 82.1591 32.962C81.8651 32.7956 81.541 32.689 81.2055 32.6483C80.8701 32.6076 80.5299 32.6337 80.2046 32.7249C79.8627 32.8006 79.5406 32.9474 79.2592 33.1557C78.9778 33.3641 78.7434 33.6293 78.5713 33.9343C78.3992 34.2392 78.2932 34.5769 78.2602 34.9255C78.2273 35.2741 78.268 35.6257 78.3799 35.9574C78.4684 36.2929 78.623 36.6072 78.8347 36.8821C79.0464 37.1569 79.3109 37.3867 79.6126 37.5579C79.9143 37.729 80.2472 37.8382 80.5917 37.879C80.9362 37.9197 81.2854 37.8912 81.6187 37.7951C81.952 37.699 82.2628 37.5373 82.5328 37.3195C82.8027 37.1016 83.0264 36.832 83.1907 36.5265C83.355 36.2209 83.4566 35.8856 83.4895 35.5403C83.5225 35.195 83.486 34.8465 83.3824 34.5155H83.3687Z"
            fill="#DAE7F2"
        />
        <path
            d="M102.49 101.051C102.402 100.723 102.249 100.416 102.041 100.147C101.833 99.8787 101.573 99.6543 101.277 99.4871C100.982 99.3199 100.656 99.2131 100.318 99.173C99.981 99.1328 99.6391 99.1602 99.3124 99.2534C98.9711 99.3301 98.6496 99.4774 98.3688 99.686C98.088 99.8946 97.854 100.16 97.6821 100.464C97.5101 100.769 97.404 101.106 97.3705 101.455C97.337 101.803 97.3769 102.154 97.4877 102.486C97.5722 102.825 97.7242 103.144 97.9346 103.423C98.145 103.703 98.4095 103.937 98.7123 104.111C99.0151 104.286 99.35 104.398 99.6971 104.441C100.044 104.483 100.396 104.456 100.732 104.359C101.068 104.263 101.382 104.1 101.653 103.88C101.925 103.66 102.15 103.387 102.314 103.078C102.478 102.769 102.578 102.431 102.608 102.082C102.639 101.734 102.598 101.383 102.49 101.051Z"
            fill="#DAE7F2"
        />
        <path
            d="M68.9148 43.2282C68.6754 42.9871 68.3906 42.7957 68.0768 42.6651C67.7631 42.5345 67.4266 42.4673 67.0867 42.4673C66.7469 42.4673 66.4104 42.5345 66.0967 42.6651C65.7829 42.7957 65.4981 42.9871 65.2586 43.2282C65.0009 43.465 64.7958 43.7534 64.6568 44.0746C64.5178 44.3959 64.4479 44.7428 64.4518 45.0928C64.4557 45.4428 64.5332 45.7881 64.6792 46.1062C64.8253 46.4243 65.0367 46.7081 65.2996 46.9391C65.5431 47.1883 65.834 47.3861 66.1553 47.5208C66.4765 47.6555 66.8216 47.7244 67.1699 47.7233C67.5183 47.7223 67.8629 47.6514 68.1833 47.5148C68.5038 47.3781 68.7935 47.1786 69.0355 46.928C69.2774 46.6773 69.4666 46.3807 69.5918 46.0556C69.7171 45.7306 69.7758 45.3837 69.7646 45.0355C69.7533 44.6873 69.6723 44.3449 69.5264 44.0286C69.3804 43.7123 69.1725 43.4285 68.9148 43.194V43.2282Z"
            fill="#DAE7F2"
        />
        <path
            d="M118.735 91.2852C118.494 91.0465 118.208 90.8579 117.893 90.7303C117.579 90.6027 117.242 90.5387 116.903 90.5419C116.564 90.545 116.228 90.6154 115.916 90.7488C115.604 90.8823 115.322 91.0762 115.085 91.3193C114.828 91.5561 114.622 91.8445 114.483 92.1658C114.344 92.487 114.275 92.8339 114.278 93.1839C114.282 93.5339 114.36 93.8792 114.506 94.1973C114.652 94.5154 114.863 94.7992 115.126 95.0302C115.368 95.2882 115.659 95.4943 115.983 95.6361C116.306 95.7779 116.655 95.8523 117.009 95.8549C117.362 95.8575 117.712 95.7882 118.038 95.6511C118.363 95.5141 118.657 95.3122 118.903 95.0578C119.148 94.8034 119.338 94.5018 119.463 94.1713C119.588 93.8408 119.644 93.4884 119.629 93.1354C119.613 92.7825 119.526 92.4365 119.372 92.1184C119.218 91.8003 119.001 91.5168 118.735 91.2852Z"
            fill="#DAE7F2"
        />
        <path
            d="M125.692 60.5246C126.02 60.4368 126.327 60.2849 126.596 60.0776C126.865 59.8702 127.09 59.6117 127.258 59.3168C127.427 59.022 127.535 58.6966 127.577 58.3597C127.619 58.0227 127.594 57.6808 127.503 57.3537C127.428 57.0119 127.282 56.6897 127.074 56.408C126.867 56.1262 126.602 55.891 126.298 55.7178C125.994 55.5445 125.657 55.437 125.309 55.4021C124.961 55.3672 124.609 55.4058 124.277 55.5153C123.939 55.6 123.622 55.7517 123.343 55.9614C123.065 56.1711 122.832 56.4345 122.657 56.736C122.483 57.0375 122.37 57.3709 122.327 57.7166C122.284 58.0623 122.31 58.4132 122.405 58.7485C122.499 59.0838 122.66 59.3967 122.878 59.6686C123.096 59.9405 123.366 60.166 123.673 60.3316C123.979 60.4972 124.316 60.5996 124.663 60.6328C125.009 60.666 125.359 60.6292 125.692 60.5246Z"
            fill="#DAE7F2"
        />
        <path
            d="M59.0668 79.3263C59.3941 79.2384 59.7007 79.0867 59.9691 78.8798C60.2375 78.673 60.4623 78.4151 60.6307 78.121C60.799 77.8269 60.9075 77.5024 60.9499 77.1662C60.9923 76.8301 60.9678 76.4888 60.8778 76.1621C60.8045 75.8192 60.6596 75.4956 60.4527 75.2125C60.2458 74.9294 59.9816 74.693 59.6772 74.5189C59.3728 74.3448 59.0352 74.2368 58.6862 74.202C58.3373 74.1672 57.985 74.2064 57.6522 74.3169C57.3142 74.4017 56.9967 74.5534 56.7185 74.7631C56.4403 74.9727 56.2069 75.2361 56.0323 75.5376C55.8577 75.8391 55.7454 76.1726 55.702 76.5183C55.6586 76.8639 55.6851 77.2148 55.7798 77.5501C55.8744 77.8854 56.0355 78.1983 56.2533 78.4702C56.4711 78.7421 56.7412 78.9676 57.0477 79.1332C57.3542 79.2988 57.6909 79.4013 58.0377 79.4344C58.3845 79.4676 58.7345 79.4308 59.0668 79.3263Z"
            fill="#DAE7F2"
        />
        <path
            d="M116.869 44.2801C117.11 44.0412 117.301 43.757 117.432 43.4438C117.562 43.1306 117.629 42.7947 117.629 42.4554C117.629 42.1161 117.562 41.7802 117.432 41.467C117.301 41.1538 117.11 40.8696 116.869 40.6307C116.635 40.3704 116.349 40.1622 116.029 40.0196C115.71 39.8771 115.363 39.8035 115.013 39.8035C114.663 39.8035 114.317 39.8771 113.998 40.0196C113.678 40.1622 113.392 40.3704 113.158 40.6307C112.919 40.8757 112.731 41.1653 112.604 41.4831C112.478 41.8008 112.415 42.1403 112.419 42.4824C112.423 42.8244 112.495 43.1623 112.63 43.4766C112.765 43.7909 112.961 44.0755 113.206 44.3143C113.451 44.553 113.74 44.7411 114.058 44.8679C114.376 44.9947 114.715 45.0577 115.058 45.0532C115.4 45.0488 115.737 44.977 116.052 44.842C116.366 44.707 116.651 44.5114 116.889 44.2664L116.869 44.2801Z"
            fill="#DAE7F2"
        />
        <path
            d="M68.5867 93.8687C68.8276 93.6298 69.0189 93.3456 69.1494 93.0324C69.2799 92.7192 69.347 92.3833 69.347 92.044C69.347 91.7047 69.2799 91.3688 69.1494 91.0556C69.0189 90.7425 68.8276 90.4582 68.5867 90.2193C68.3528 89.959 68.0667 89.7508 67.747 89.6083C67.4273 89.4657 67.0813 89.3921 66.7313 89.3921C66.3813 89.3921 66.0352 89.4657 65.7155 89.6083C65.3958 89.7508 65.1097 89.959 64.8758 90.2193C64.6158 90.4591 64.4074 90.7493 64.2633 91.0722C64.1192 91.3952 64.0423 91.7441 64.0375 92.0977C64.0326 92.4513 64.0999 92.8022 64.2351 93.129C64.3703 93.4558 64.5707 93.7516 64.824 93.9984C65.0773 94.2452 65.3782 94.4378 65.7084 94.5644C66.0385 94.6911 66.3911 94.7492 66.7444 94.7351C67.0978 94.7211 67.4446 94.6352 67.7637 94.4827C68.0828 94.3302 68.3675 94.1143 68.6004 93.8482L68.5867 93.8687Z"
            fill="#DAE7F2"
        />
        <path
            d="M92.7449 68.7865C92.8392 68.4356 92.8625 68.0693 92.8136 67.7092C92.7646 67.3491 92.6444 67.0024 92.4598 66.6893C92.2753 66.3762 92.0302 66.1031 91.7388 65.8859C91.4475 65.6686 91.1158 65.5117 90.763 65.4242C90.4062 65.3124 90.0298 65.2768 89.6584 65.3196C89.2869 65.3624 88.9285 65.4827 88.6064 65.6727C88.2844 65.8627 88.0058 66.1182 87.7886 66.4227C87.5715 66.7272 87.4207 67.0738 87.346 67.4402C87.2563 67.7947 87.2372 68.1634 87.29 68.5253C87.3427 68.8871 87.4662 69.2351 87.6534 69.5492C87.8406 69.8633 88.0879 70.1375 88.3811 70.3561C88.6742 70.5746 89.0076 70.7333 89.3621 70.8231C89.7166 70.9128 90.0853 70.9319 90.4471 70.8791C90.809 70.8264 91.1569 70.7029 91.471 70.5157C91.7851 70.3285 92.0593 70.0812 92.2779 69.788C92.4965 69.4949 92.6552 69.1615 92.7449 68.807V68.7865Z"
            stroke="#FF4645"
            strokeWidth={1.44522}
            strokeMiterlimit={10}
        />
        <path
            d="M64.2129 61.988L87.2777 67.7218"
            stroke="#FF4645"
            strokeWidth={1.44522}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M92.7448 68.7881L97.5012 69.9704"
            stroke="#FF4645"
            strokeWidth={1.44522}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M44.696 121.465C46.7691 120.284 50.6057 116.613 49.8421 114.255C48.8638 111.225 46.2601 114.561 39.6297 106.974C38.3018 105.441 35.7349 104.38 33.4961 105.248C33.352 104.659 33.2692 102.865 32.3952 101.147C31.1071 98.5897 26.6511 100.712 28.4022 103.564C29.1094 104.716 30.0382 105.715 31.1347 106.505C29.4143 107.673 28.0005 110.01 29.2456 113.099C32.5608 121.403 28.347 123.219 30.2883 125.335C31.8217 127.016 36.8236 125.559 38.9274 124.722"
            stroke="#00E6C5"
            strokeWidth={1.75}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M33.4852 122.015C35.2572 119.386 41.592 115.724 45.1961 115.084"
            stroke="#00E6C5"
            strokeWidth={1.75}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M41.7366 126.175C43.5625 126.175 45.0426 124.695 45.0426 122.869C45.0426 121.044 43.5625 119.563 41.7366 119.563C39.9108 119.563 38.4307 121.044 38.4307 122.869C38.4307 124.695 39.9108 126.175 41.7366 126.175Z"
            stroke="#00E6C5"
            strokeWidth={1.75}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M149.852 38.2255C146.353 36.2329 139.879 30.0375 141.167 26.0574C142.818 20.9438 147.213 26.575 158.402 13.7703C160.643 11.1824 164.976 9.39162 168.754 10.8563C168.997 9.86261 169.137 6.83482 170.612 3.93642C172.786 -0.380126 180.306 3.20147 177.351 8.01488C176.157 9.95828 174.59 11.6454 172.739 12.9784C175.643 14.9503 178.029 18.8942 175.927 24.1062C170.332 38.122 177.444 41.186 174.168 44.7573C171.58 47.5936 163.138 45.1351 159.588 43.7221"
            stroke="#00E6C5"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M168.772 39.1548C165.782 34.7177 155.091 28.5378 149.008 27.4578"
            stroke="#00E6C5"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M154.846 46.1754C151.765 46.1754 149.267 43.6774 149.267 40.596C149.267 37.5146 151.765 35.0166 154.846 35.0166C157.928 35.0166 160.426 37.5146 160.426 40.596C160.426 43.6774 157.928 46.1754 154.846 46.1754Z"
            stroke="#00E6C5"
            strokeWidth={2}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
    </svg>
);

export default AlarmLightM;
