import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidProtection = (props: IIconProps): ReactElement => (
    <svg
        width="57"
        height="50"
        viewBox="0 0 57 50"
        fill="none"
        focusable={false}
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M51.85 47.0588H17.2383C10.4502 47.0588 12.3193 39.7553 16.1525 38.5763C19.2294 37.6197 20.852 38.6672 20.852 38.6672C20.852 38.6672 22.56 31.2369 28.3502 31.0145C29.9806 30.9225 31.6056 31.2699 33.0487 32.0191C34.4919 32.7682 35.6981 33.8905 36.5365 35.2641C36.5365 35.2641 40.3453 32.6335 45.1937 34.9724C50.042 37.3112 49.4735 41.0706 49.4735 41.0706C49.4735 41.0706 52.421 40.1833 54.8928 41.9578C57.3645 43.7323 56.8887 47.0588 51.85 47.0588Z"
            fill="#EDF2F7"
        />
        <path
            d="M36.6599 27.9235H4.78026C-3.0908 27.9235 0.460446 19.4391 3.43588 18.815C6.41131 18.1908 8.42541 19.3334 8.42541 19.3334C8.42541 19.3334 9.78709 12.3699 15.6539 12.1635C21.5208 11.9571 23.2877 15.7067 23.2877 15.7067C23.2877 15.7067 26.2113 13.4953 30.7609 16.3308C33.9217 18.2965 34.2479 21.218 34.2479 21.218C34.2479 21.218 37.2135 20.3875 39.7193 22.051C42.2252 23.7145 41.7334 27.9235 36.6599 27.9235Z"
            fill="#EDF2F7"
        />
        <circle
            cx="16.1071"
            cy="13.2722"
            r="5.28853"
            transform="rotate(-6.38024 16.1071 13.2722)"
            fill="#FFCC00"
        />
        <path
            d="M23.8322 12.1098C23.8041 11.8579 23.9854 11.6309 24.2373 11.6028L26.829 11.313C27.0809 11.2848 27.3079 11.4662 27.3361 11.718L27.346 11.807C27.3742 12.0589 27.1929 12.2859 26.941 12.3141L24.3493 12.6039C24.0974 12.632 23.8704 12.4507 23.8422 12.1988L23.8322 12.1098Z"
            fill="#FFCC00"
        />
        <path
            d="M4.31076 14.2928C4.2826 14.0409 4.46396 13.8138 4.71584 13.7857L7.80809 13.4399C8.05997 13.4117 8.287 13.5931 8.31517 13.845L8.32511 13.9339C8.35328 14.1858 8.17192 14.4128 7.92003 14.441L4.82779 14.7868C4.5759 14.8149 4.34887 14.6336 4.32071 14.3817L4.31076 14.2928Z"
            fill="#FFCC00"
        />
        <path
            d="M17.0469 21.276C17.2987 21.2478 17.5258 21.4292 17.5539 21.6811L17.8437 24.2728C17.8719 24.5247 17.6905 24.7517 17.4386 24.7799L17.3497 24.7898C17.0978 24.818 16.8708 24.6366 16.8426 24.3847L16.5528 21.793C16.5247 21.5411 16.706 21.3141 16.9579 21.2859L17.0469 21.276Z"
            fill="#FFCC00"
        />
        <path
            d="M14.8095 1.25413C15.0614 1.22596 15.2885 1.40732 15.3166 1.65921L15.6624 4.75145C15.6906 5.00334 15.5092 5.23037 15.2573 5.25853L15.1684 5.26848C14.9165 5.29664 14.6895 5.11528 14.6613 4.8634L14.3155 1.77115C14.2874 1.51927 14.4687 1.29224 14.7206 1.26407L14.8095 1.25413Z"
            fill="#FFCC00"
        />
        <path
            d="M22.6003 18.1741C22.7585 17.9761 23.0473 17.9438 23.2453 18.102L25.2828 19.7296C25.4808 19.8878 25.5131 20.1766 25.3549 20.3746L25.2991 20.4446C25.1409 20.6426 24.8521 20.6749 24.6541 20.5167L22.6165 18.889C22.4185 18.7308 22.3862 18.442 22.5444 18.244L22.6003 18.1741Z"
            fill="#FFCC00"
        />
        <path
            d="M6.8581 5.60023C7.01629 5.4022 7.30506 5.36991 7.50309 5.5281L9.93413 7.47015C10.1322 7.62835 10.1644 7.91712 10.0063 8.11515L9.9504 8.18507C9.7922 8.3831 9.50343 8.41539 9.3054 8.25719L6.87436 6.31514C6.67633 6.15695 6.64404 5.86818 6.80224 5.67015L6.8581 5.60023Z"
            fill="#FFCC00"
        />
        <path
            d="M10.9256 19.543C11.1236 19.7012 11.1559 19.99 10.9977 20.188L9.37006 22.2255C9.21187 22.4235 8.92309 22.4558 8.72507 22.2976L8.65514 22.2418C8.45712 22.0836 8.42483 21.7948 8.58302 21.5968L10.2107 19.5592C10.3689 19.3612 10.6577 19.3289 10.8557 19.4871L10.9256 19.543Z"
            fill="#FFCC00"
        />
        <path
            d="M23.5018 3.80221C23.6998 3.9604 23.7321 4.24918 23.5739 4.4472L21.6319 6.87825C21.4737 7.07627 21.1849 7.10856 20.9869 6.95037L20.9169 6.89451C20.7189 6.73632 20.6866 6.44754 20.8448 6.24952L22.7869 3.81847C22.9451 3.62045 23.2338 3.58816 23.4319 3.74635L23.5018 3.80221Z"
            fill="#FFCC00"
        />
        <path
            d="M53.1468 15.062C53.1468 14.828 53.0535 14.6408 52.8668 14.5004C52.7735 14.4536 52.6802 14.3601 52.5402 14.3601C52.4002 14.3133 52.2602 14.2665 52.1202 14.2665C48.3404 13.4242 44.8405 11.5057 41.9939 8.93215C41.6673 8.6046 41.294 8.32385 40.9673 7.94951C40.7807 7.76234 40.6407 7.52838 40.4073 7.43479C39.9874 7.20083 39.4741 7.52838 39.0541 7.66875C38.6341 7.80913 38.1208 7.94951 37.5608 8.13668C35.3676 8.74498 33.1276 9.02573 30.8877 9.02573C29.7678 9.02573 28.6012 8.93215 27.4812 8.74498C27.0612 8.65139 26.3146 8.37064 25.8946 8.41743C25.4746 8.51102 25.288 9.07253 25.1946 9.40007C24.2613 12.2076 23.5147 15.062 23.0014 17.9631C22.7214 19.4136 22.4881 20.8642 22.3014 22.3616C22.1614 23.7185 21.9281 25.1223 22.0214 26.4793C22.1614 27.9299 22.5814 29.2868 23.1881 30.597C24.8213 34.1532 27.3879 37.3351 30.1411 40.1427C30.4678 40.4702 30.8411 40.8446 31.1677 41.1721C31.7277 41.7336 32.3343 41.4061 32.9876 41.1721C33.7343 40.9381 34.4809 40.7042 35.2276 40.4702C36.6742 39.9555 38.1208 39.394 39.5207 38.7389C41.5273 37.8498 43.4872 36.7736 45.2138 35.3231C46.9871 33.8257 48.107 32.0476 48.947 29.8951C50.8136 25.2627 52.2135 20.4899 53.1002 15.5767C53.1468 15.3427 53.1468 15.2023 53.1468 15.062Z"
            fill="#40B342"
        />
        <path
            d="M49.8333 16.7933C49.8333 16.8869 49.7866 16.9805 49.7399 17.0741C49.7399 17.1677 49.6933 17.2613 49.6933 17.3549C49.1333 19.7881 48.4333 22.1745 47.64 24.5141C47.1734 25.9179 46.6601 27.462 46.0067 28.9126C45.5868 29.7548 45.1668 30.5971 44.6068 31.299C43.1602 33.1239 41.1069 34.3405 39.007 35.2763C36.9071 36.259 34.7139 37.1012 32.5206 37.7563C32.2406 37.8499 30.5607 35.6039 30.3274 35.3231C29.5341 34.4341 28.7874 33.4982 28.0875 32.5624C26.7342 30.7375 25.1476 28.3511 24.9609 26.0114C24.9609 25.9647 24.9609 25.9179 24.9609 25.8711C24.9609 25.8243 24.9609 25.7775 24.9609 25.7307C24.9609 25.6839 24.9609 25.6839 24.9609 25.6371C24.9609 25.5903 24.9609 25.5903 24.9609 25.5435V25.4967C24.9609 25.4499 24.9609 25.4031 24.9609 25.4031C25.2409 21.0515 26.0809 16.7466 27.1542 12.5352C27.2475 12.2077 27.3408 11.9269 27.3875 11.6462C31.3073 12.2077 35.2738 11.7866 39.0537 10.6635C39.1937 10.6168 39.287 10.57 39.427 10.57C39.567 10.5232 40.8736 11.8801 41.0136 11.9737C41.7136 12.5352 42.4136 13.05 43.1135 13.5179C45.0735 14.8749 47.4067 16.0447 49.7399 16.7466C49.7399 16.7466 49.7866 16.7933 49.8333 16.7933Z"
            fill="#70D164"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M41.7767 16.3042C41.538 16.7932 40.9143 16.9996 40.2742 16.8467L38.9413 19.1553C39.7269 19.6786 40.3458 20.4325 40.7011 21.3204L42.5464 20.8259C42.5505 20.2393 42.8405 19.7367 43.3157 19.5883C43.9447 19.3918 44.66 19.8901 44.9134 20.7013C45.1667 21.5125 44.8623 22.3293 44.2333 22.5258C43.7099 22.6893 43.1268 22.3718 42.7998 21.7933L40.9708 22.2834C41.0132 22.5368 41.0353 22.7971 41.0353 23.0625C41.0353 23.6958 40.9098 24.2997 40.6824 24.8508L42.9876 26.1818C43.4234 25.7275 44.027 25.5621 44.4861 25.8185C45.0615 26.1399 45.1919 27.0018 44.7775 27.7438C44.3631 28.4857 43.5607 28.8267 42.9854 28.5054C42.531 28.2515 42.3541 27.6603 42.5042 27.0573L40.204 25.7294C39.7298 26.4145 39.0778 26.9672 38.3148 27.321L39.1045 30.268C39.7653 30.2403 40.3405 30.5651 40.4796 31.0935C40.6474 31.7307 40.1172 32.4227 39.2953 32.6391C38.4735 32.8554 37.6713 32.5142 37.5035 31.877C37.3763 31.3938 37.6504 30.8792 38.1486 30.5642L37.3656 27.6422C37.0367 27.7152 36.6949 27.7537 36.3441 27.7537C35.595 27.7537 34.8869 27.5781 34.2587 27.2659L32.885 29.6451C33.3379 30.0816 33.5017 30.6852 33.2445 31.1435C32.9221 31.7182 32.0599 31.8469 31.3187 31.4311C30.5776 31.0152 30.2382 30.2123 30.5606 29.6376C30.8155 29.1833 31.4077 29.0077 32.0107 29.1594L33.415 26.7272C32.7584 26.2017 32.2461 25.5034 31.9471 24.7013L30.5678 25.0708C30.6145 25.7182 30.3172 26.2929 29.8032 26.4535C29.1742 26.6499 28.4589 26.1516 28.2055 25.3405C27.9522 24.5293 28.2567 23.7124 28.8856 23.5159C29.3698 23.3647 29.9051 23.6251 30.2415 24.123L31.7003 23.7321C31.6691 23.5134 31.6529 23.2899 31.6529 23.0625C31.6529 22.3433 31.8147 21.662 32.104 21.0528L29.6799 19.6533C29.2456 20.1238 28.6329 20.3004 28.1662 20.0432C27.5892 19.7251 27.4539 18.8638 27.8642 18.1196C28.2745 17.3754 29.0749 17.03 29.652 17.3481C30.1016 17.5959 30.283 18.1734 30.1472 18.7683L32.6271 20.2001C33.2074 19.4477 34.0111 18.8764 34.9389 18.5855L34.7985 18.0615C34.1614 18.069 33.6147 17.7478 33.4796 17.2345C33.3118 16.5973 33.842 15.9053 34.6639 15.6889C35.4857 15.4726 36.2879 15.8138 36.4557 16.451C36.587 16.9497 36.2908 17.482 35.7619 17.7935L35.9218 18.3901C36.0609 18.3777 36.2017 18.3714 36.3441 18.3714C36.9473 18.3714 37.524 18.4852 38.0537 18.6926L39.393 16.373C38.9617 15.9663 38.791 15.405 39.0112 14.954C39.3003 14.3618 40.1538 14.184 40.9175 14.5569C41.6811 14.9297 42.0658 15.712 41.7767 16.3042Z"
            fill="white"
        />
    </svg>
);

export default CovidProtection;
