import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DesktopIndexLogoTravelSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 29 30"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect
            width={27.58}
            height={27.58}
            rx={13.79}
            transform="matrix(1 -8.74228e-08 -8.74228e-08 -1 0.609863 28.4902)"
            fill="#FFCC00"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19.1108 7.53454H17.8848L19.6407 1.94141C20.0057 2.0915 20.3628 2.2568 20.7113 2.43651L19.1108 7.53454Z"
            fill="#292929"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M17.4294 1.2442C17.0487 1.15886 16.6621 1.08927 16.2702 1.03613L14.1821 7.53462H15.4081L17.4294 1.2442Z"
            fill="#292929"
        />
        <path
            d="M8.63589 19.0263C8.29286 18.9246 7.92442 18.9246 7.57504 19.0199C6.96518 19.1597 6.51416 19.9601 6.51416 21.1226C6.51416 22.2851 6.87625 22.9139 7.35905 23.1935C7.72749 23.3141 8.12134 23.3269 8.49614 23.2189C8.92175 23.1109 9.55699 22.2787 9.55699 21.1162C9.55699 19.9537 9.21396 19.1978 8.63589 19.0263Z"
            fill="#292929"
        />
        <path
            d="M19.9747 19.0263C19.638 18.9246 19.2759 18.9246 18.9329 19.0199C18.3358 19.1597 17.8911 19.9601 17.8911 21.1226C17.8911 22.2851 18.2468 22.9139 18.7233 23.1935C19.0854 23.3141 19.4729 23.3269 19.8413 23.2189C20.2606 23.1109 20.8831 22.2787 20.8831 21.1162C20.8831 19.9537 20.5401 19.1978 19.9747 19.0263Z"
            fill="#292929"
        />
        <path
            d="M19.9623 6.84863C19.9687 6.84863 12.0472 6.84863 12.0472 6.84863C10.1478 6.84863 9.48719 8.97667 9.48719 8.97667C9.48719 8.97667 7.22571 16.3074 6.39355 18.9818C5.56138 21.6562 8.48986 22.7107 9.23309 22.7107C10.2558 22.7107 17.4849 22.7107 17.5039 22.7107C18.2599 22.7107 18.749 22.1517 18.749 21.0209C18.749 19.6932 19.4541 19.0263 19.9496 19.0453C20.1211 19.0771 20.28 19.166 20.3879 19.2994C21.1248 16.8918 22.9734 11.0222 23.0433 10.7426C23.9135 8.25885 21.3408 6.84863 19.9623 6.84863Z"
            fill="url(#2cd73fcd__paint0_linear_16347_123)"
        />
        <path
            d="M20.7565 7.61698C20.5214 7.60427 20.3118 7.75038 20.2419 7.97907L16.9514 18.0604C16.9514 18.0667 16.945 18.0731 16.945 18.0858C16.8688 18.4415 16.7354 18.7845 16.5512 19.0958C16.3415 19.3245 16.4305 19.7247 17.4214 19.4897C18.4124 19.2546 18.5141 18.6448 18.946 17.3298C19.3208 16.1864 21.1058 10.5645 21.5696 9.10345C21.6839 8.77312 21.6522 8.41103 21.487 8.09976C21.3472 7.8139 21.0677 7.63604 20.7565 7.61698Z"
            fill="url(#2cd73fcd__paint1_linear_16347_123)"
        />
        <path
            d="M16.8304 9.03392C16.6335 9.504 14.0989 17.6097 13.9655 18.029C13.8321 18.4483 14.4038 18.5817 14.4038 18.5817L17.5419 8.58925L17.5483 8.57025H17.5292C17.2179 8.53849 16.9257 8.73536 16.8304 9.03392Z"
            fill="url(#2cd73fcd__paint2_linear_16347_123)"
        />
        <path
            d="M14.8803 8.57031C14.6643 8.61478 14.3594 8.56396 14.1625 9.03404C13.9655 9.50412 11.4309 17.6098 11.2975 18.0291C11.1641 18.4483 11.7358 18.5817 11.7358 18.5817L14.8803 8.57031Z"
            fill="url(#2cd73fcd__paint3_linear_16347_123)"
        />
        <path
            d="M12.0976 8.57034C11.78 8.53858 11.4814 8.72915 11.3797 9.03406C11.1828 9.50414 8.64821 17.6098 8.51481 18.0291C8.38141 18.4484 8.95312 18.5818 8.95312 18.5818L12.0976 8.57034Z"
            fill="url(#2cd73fcd__paint4_linear_16347_123)"
        />
        <defs>
            <linearGradient
                id="2cd73fcd__paint0_linear_16347_123"
                x1={14.7323}
                y1={22.5945}
                x2={14.7323}
                y2={6.73497}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0852} stopColor="#C70100" />
                <stop offset={0.1948} stopColor="#E11C1B" />
                <stop offset={0.979} stopColor="#E11C1B" />
            </linearGradient>
            <linearGradient
                id="2cd73fcd__paint1_linear_16347_123"
                x1={17.2559}
                y1={19.7038}
                x2={20.9568}
                y2={7.65043}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E52F2D" />
                <stop offset={0.07468} stopColor="#E63634" />
                <stop offset={1} stopColor="#EF8883" />
            </linearGradient>
            <linearGradient
                id="2cd73fcd__paint2_linear_16347_123"
                x1={14.197}
                y1={18.3492}
                x2={18.1681}
                y2={5.49397}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="2cd73fcd__paint3_linear_16347_123"
                x1={11.7587}
                y1={17.5961}
                x2={15.7298}
                y2={4.74084}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="2cd73fcd__paint4_linear_16347_123"
                x1={9.22199}
                y1={16.8126}
                x2={13.1931}
                y2={3.95737}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
        </defs>
    </svg>
);

export default DesktopIndexLogoTravelSign;
