import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightNoCityPhotoL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 1200 400"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#ae8bd6c5__clip0_25495_5756)">
            <path
                d="M1221 -3H-8V350H1221V-3Z"
                fill="url(#ae8bd6c5__paint0_linear_25495_5756)"
            />
            <path
                opacity={0.67}
                d="M561.905 213H446C446 213 464.538 202.024 472.241 202.61C479.944 203.195 478.645 208.605 478.645 208.605C478.645 208.605 494.131 195.988 507.767 196.722C521.403 197.456 519.788 204.144 519.788 204.144C519.788 204.144 534.812 189.16 558.747 191.189C577.529 192.739 561.905 213 561.905 213Z"
                fill="white"
            />
            <path
                opacity={0.5}
                d="M1265.26 99.5992H1122.45C1122.45 99.5992 1145.29 86.2892 1154.74 86.9992C1164.19 87.7092 1162.64 94.2492 1162.64 94.2492C1162.64 94.2492 1181.71 78.9492 1198.51 79.8492C1215.31 80.7492 1213.32 88.8492 1213.32 88.8492C1213.32 88.8492 1231.83 70.6792 1261.37 73.1392C1284.5 74.9992 1265.26 99.5992 1265.26 99.5992Z"
                fill="url(#ae8bd6c5__paint1_linear_25495_5756)"
            />
            <path
                opacity={0.6}
                d="M404.73 164H119C119 164 157.049 126.522 197.179 120.938C237.309 115.354 235.919 142.469 235.919 142.469C235.919 142.469 288.329 65.1547 368.581 72.4909C448.832 79.8272 416.492 134.496 416.492 134.496C416.492 134.496 460.24 106.524 488.608 118.002C516.977 129.479 494.653 164 494.653 164H404.73Z"
                fill="url(#ae8bd6c5__paint2_linear_25495_5756)"
            />
            <path
                opacity={0.4}
                d="M771.74 109.389H570.64C570.64 109.389 597.42 86.5091 625.64 83.1091C653.86 79.7091 652.91 96.2491 652.91 96.2491C652.91 96.2491 689.78 49.0591 746.26 53.5291C802.74 57.9991 779.97 91.3791 779.97 91.3791C779.97 91.3791 810.74 74.3091 830.74 81.3091C850.74 88.3091 835 109.389 835 109.389H771.74Z"
                fill="url(#ae8bd6c5__paint3_linear_25495_5756)"
            />
            <path
                opacity={0.7}
                d="M742.81 190.696H600C600 190.696 622.84 177.376 632.34 178.086C641.84 178.796 640.23 185.336 640.23 185.336C640.23 185.336 659.3 170.036 676.11 170.936C692.92 171.836 690.91 179.936 690.91 179.936C690.91 179.936 709.42 161.736 738.94 164.236C762.05 166.126 742.81 190.696 742.81 190.696Z"
                fill="url(#ae8bd6c5__paint4_linear_25495_5756)"
            />
            <path
                opacity={0.5}
                d="M72.22 28.5206C59.42 26.3806 42.38 32.9106 33.22 37.0906C33.54 25.7706 28.83 9.39062 -1.07001 9.39062C-46.78 9.39062 -67.07 39.2806 -67.07 39.2806C-67.07 39.2806 -64.13 24.7806 -86.29 24.7806C-108.45 24.7806 -134 47.6506 -134 47.6506H80.74C80.74 47.6506 90.62 31.6106 72.22 28.5206Z"
                fill="url(#ae8bd6c5__paint5_linear_25495_5756)"
            />
            <path
                d="M1130 79H1336.26C1347.31 27.0504 1356 -4 1356 -4H1150.61C1150.61 -4 1141.62 27.0504 1130 79Z"
                fill="#F2F5F8"
            />
            <path
                d="M938.85 -15.5C930.85 2.4 906.77 60.22 891.68 134.5C881.94 182.45 875.96 233.5 872.5 270.8C870.993 287.072 863.779 302.287 852.134 313.753C840.489 325.218 825.164 332.196 808.87 333.45C784.655 335.297 760.341 335.484 736.1 334.01C697.1 331.66 667.92 297.14 671.71 258.22C675.2 222.51 681.02 177.22 690.58 134.5C707.17 60.23 732.39 2.41 740.68 -15.5H579.13C571 2.83 545.79 63 530.06 140.46C519.94 190.24 513.73 243.29 510.14 282C508.561 298.886 501.064 314.67 488.974 326.564C476.884 338.458 460.98 345.696 444.07 347C418.93 348.919 393.687 349.112 368.52 347.58C328 345.14 297.72 309.29 301.66 268.89C305.28 231.8 311.33 184.82 321.25 140.43C338.55 63 364.87 2.83 373.37 -15.5H143.61C135.2 3.36 108.61 66.67 92.0601 148.19C81.4601 200.36 75.0001 256 71.1901 296.48C69.5534 314.179 61.7105 330.728 49.0485 343.202C36.3864 355.675 19.7212 363.269 2.00008 364.64C-5.99992 365.253 -13.9733 365.707 -21.9199 366V384.5H1063V-15.5H938.85Z"
                fill="#BBC5CB"
            />
            <path
                d="M960.77 0C952.82 17.9 928.7 75.72 913.6 150C903.86 197.95 897.88 249 894.42 286.3C892.915 302.573 885.701 317.789 874.056 329.255C862.411 340.721 847.084 347.698 830.79 348.95C806.578 350.797 782.268 350.984 758.03 349.51C719.03 347.16 689.84 312.64 693.64 273.72C697.12 238 703 192.74 712.5 150C729.1 75.72 754.31 17.9 762.6 0H601.05C592.9 18.33 567.71 78.54 552 156C541.88 205.78 535.68 258.83 532.09 297.52C530.51 314.408 523.012 330.193 510.92 342.087C498.828 353.981 482.921 361.219 466.01 362.52C440.869 364.439 415.627 364.632 390.46 363.1C349.94 360.66 319.67 324.81 323.61 284.41C327.22 247.32 333.27 200.34 343.19 155.95C360.47 78.54 386.8 18.33 395.3 0H165.53C157.12 18.86 130.53 82.17 113.98 163.69C103.38 215.86 96.88 271.45 93.12 312C91.4798 329.706 83.6291 346.26 70.9572 358.735C58.2854 371.209 41.6093 378.798 23.88 380.16C15.96 380.76 8 381.193 0 381.46V400H1056V0H960.77Z"
                fill="#D0DFEA"
            />
            <g opacity={0.3}>
                <path
                    opacity={0.3}
                    d="M960.77 0C952.82 17.9 928.7 75.72 913.6 150C903.86 197.95 897.88 249 894.42 286.3C892.915 302.573 885.701 317.789 874.056 329.255C862.411 340.721 847.084 347.698 830.79 348.95C806.578 350.797 782.268 350.984 758.03 349.51C719.03 347.16 689.84 312.64 693.64 273.72C697.12 238 703 192.74 712.5 150C729.1 75.72 754.31 17.9 762.6 0H601.05C592.9 18.33 567.71 78.54 552 156C541.88 205.78 535.68 258.83 532.09 297.52C530.51 314.408 523.012 330.193 510.92 342.087C498.828 353.981 482.921 361.219 466.01 362.52C440.869 364.439 415.627 364.632 390.46 363.1C349.94 360.66 319.67 324.81 323.61 284.41C327.22 247.32 333.27 200.34 343.19 155.95C360.47 78.54 386.8 18.33 395.3 0H165.53C157.12 18.86 130.53 82.17 113.98 163.69C103.38 215.86 96.88 271.45 93.12 312C91.4798 329.706 83.6291 346.26 70.9572 358.735C58.2854 371.209 41.6093 378.798 23.88 380.16C15.96 380.76 8 381.193 0 381.46V400H1045V0H960.77Z"
                    fill="url(#ae8bd6c5__paint6_linear_25495_5756)"
                />
            </g>
            <path
                d="M937.07 -5.7793C937.07 -5.7793 905.54 60.0007 887.27 150.001C877.52 197.951 871.54 249.001 868.09 286.301C866.582 302.575 859.367 317.791 847.72 329.257C836.073 340.722 820.745 347.699 804.45 348.951C795.43 349.617 786.396 350.077 777.35 350.331C795.175 350.766 813.011 350.306 830.79 348.951C847.084 347.698 862.41 340.722 874.056 329.256C885.701 317.79 892.914 302.574 894.42 286.301C897.88 249.041 903.86 197.951 913.6 150.001C931.88 60.0007 963.41 -5.7793 963.41 -5.7793H937.07Z"
                fill="#BBC5CB"
            />
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M656.13 -59.71C645.3 -36.92 604.43 41.88 582.23 138.76C567.96 201.06 560.23 259.88 554.53 308.42C552.034 329.621 542.121 349.256 526.543 363.853C510.966 378.449 490.728 387.066 469.41 388.18C437.744 389.821 406.003 389.283 374.41 386.57C323.52 382.24 286.56 336.21 292.77 285.52C298.47 238.99 307.54 180.09 321.39 124.52C345.52 27.73 380.5 -47.18 391.75 -70"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M227.89 -59.71C217.07 -36.92 176.19 41.88 154 138.76C139.73 201.06 132 259.88 126.29 308.42C123.794 329.621 113.881 349.256 98.3032 363.853C82.7258 378.449 62.4882 387.066 41.1699 388.18C9.50376 389.821 -22.2377 389.283 -53.8301 386.57C-104.72 382.24 -141.68 336.21 -135.47 285.52C-129.77 238.99 -120.7 180.09 -106.84 124.52C-82.7201 27.73 -47.7401 -47.18 -36.4801 -70"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M1005.65 -53.6009C995.31 -31.8109 963.24 39.8091 942.03 132.399C928.39 191.999 919.35 255.549 913.89 301.939C911.506 322.204 902.031 340.973 887.141 354.926C872.252 368.878 852.907 377.115 832.53 378.179C802.254 379.74 771.906 379.226 741.7 376.639C693.06 372.489 657.7 328.509 663.7 280.059C669.15 235.579 677.82 179.279 691.07 126.209C714.16 33.6591 747.59 -37.9309 758.35 -59.7109"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <path
                d="M1704 -15.5C1696 2.4 1671.92 60.22 1656.83 134.5C1647.09 182.45 1641.11 233.5 1637.65 270.8C1636.14 287.072 1628.93 302.287 1617.29 313.753C1605.64 325.218 1590.32 332.196 1574.02 333.45C1549.81 335.297 1525.49 335.484 1501.25 334.01C1462.25 331.66 1433.07 297.14 1436.86 258.22C1440.35 222.51 1446.17 177.22 1455.73 134.5C1472.32 60.23 1497.54 2.41 1505.83 -15.5H1344.28C1336.15 2.83 1310.94 63 1295.21 140.46C1285.09 190.24 1278.88 243.29 1275.29 282C1273.71 298.886 1266.22 314.67 1254.13 326.564C1242.04 338.458 1226.13 345.696 1209.22 347C1184.08 348.919 1158.84 349.112 1133.67 347.58C1093.15 345.14 1062.87 309.29 1066.81 268.89C1070.43 231.8 1076.48 184.82 1086.4 140.43C1103.7 63 1130.02 2.83 1138.52 -15.5H908.761C900.351 3.36 873.761 66.67 857.211 148.19C846.611 200.36 840.151 256 836.341 296.48C834.705 314.179 826.862 330.728 814.2 343.202C801.538 355.675 784.873 363.269 767.151 364.64C759.151 365.253 751.178 365.707 743.231 366V384.5H1943.23V-15.5H1704Z"
                fill="#BBC5CB"
            />
            <path
                d="M1725.92 0C1717.97 17.9 1693.85 75.72 1678.75 150C1669.01 197.95 1663.03 249 1659.57 286.3C1658.07 302.573 1650.85 317.789 1639.21 329.255C1627.56 340.721 1612.24 347.698 1595.94 348.95C1571.73 350.797 1547.42 350.984 1523.18 349.51C1484.18 347.16 1454.99 312.64 1458.79 273.72C1462.27 238 1468.15 192.74 1477.65 150C1494.25 75.72 1519.46 17.9 1527.75 0H1366.2C1358.05 18.33 1332.86 78.54 1317.15 156C1307.03 205.78 1300.83 258.83 1297.24 297.52C1295.66 314.408 1288.16 330.193 1276.07 342.087C1263.98 353.981 1248.07 361.219 1231.16 362.52C1206.02 364.439 1180.78 364.632 1155.61 363.1C1115.09 360.66 1084.82 324.81 1088.76 284.41C1092.37 247.32 1098.42 200.34 1108.34 155.95C1125.62 78.54 1151.95 18.33 1160.45 0H930.681C922.271 18.86 895.681 82.17 879.131 163.69C868.531 215.86 862.031 271.45 858.271 312C856.631 329.706 848.78 346.26 836.109 358.735C823.437 371.209 806.761 378.798 789.031 380.16C781.111 380.76 773.151 381.193 765.151 381.46V400H1965.15V0H1725.92Z"
                fill="#D0DFEA"
            />
            <g opacity={0.3}>
                <path
                    opacity={0.3}
                    d="M1725.92 0C1717.97 17.9 1693.85 75.72 1678.75 150C1669.01 197.95 1663.03 249 1659.57 286.3C1658.07 302.573 1650.85 317.789 1639.21 329.255C1627.56 340.721 1612.24 347.698 1595.94 348.95C1571.73 350.797 1547.42 350.984 1523.18 349.51C1484.18 347.16 1454.99 312.64 1458.79 273.72C1462.27 238 1468.15 192.74 1477.65 150C1494.25 75.72 1519.46 17.9 1527.75 0H1366.2C1358.05 18.33 1332.86 78.54 1317.15 156C1307.03 205.78 1300.83 258.83 1297.24 297.52C1295.66 314.408 1288.16 330.193 1276.07 342.087C1263.98 353.981 1248.07 361.219 1231.16 362.52C1206.02 364.439 1180.78 364.632 1155.61 363.1C1115.09 360.66 1084.82 324.81 1088.76 284.41C1092.37 247.32 1098.42 200.34 1108.34 155.95C1125.62 78.54 1151.95 18.33 1160.45 0H930.681C922.271 18.86 895.681 82.17 879.131 163.69C868.531 215.86 862.031 271.45 858.271 312C856.631 329.706 848.78 346.26 836.109 358.735C823.437 371.209 806.761 378.798 789.031 380.16C781.111 380.76 773.151 381.193 765.151 381.46V400H1965.15V0H1725.92Z"
                    fill="url(#ae8bd6c5__paint7_linear_25495_5756)"
                />
            </g>
            <g opacity={0.3}>
                <path
                    opacity={0.5}
                    d="M1421.28 -59.71C1410.45 -36.92 1369.58 41.88 1347.38 138.76C1333.11 201.06 1325.38 259.88 1319.68 308.42C1317.19 329.621 1307.27 349.256 1291.69 363.853C1276.12 378.449 1255.88 387.066 1234.56 388.18C1202.9 389.821 1171.15 389.283 1139.56 386.57C1088.67 382.24 1051.71 336.21 1057.92 285.52C1063.62 238.99 1072.69 180.09 1086.54 124.52C1110.67 27.73 1145.65 -47.18 1156.9 -70"
                    stroke="#7E9BAD"
                    strokeWidth={2}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
            </g>
            <path
                opacity={0.3}
                d="M556.59 42.8691L553.53 51.4391L583.93 42.8691H556.59Z"
                fill="#7D9CAE"
            />
            <path
                opacity={0.3}
                d="M90.5 156L89 165L115.5 157L90.5 156Z"
                fill="#7D9CAE"
            />
            <path
                d="M377.359 42.8707H583.929C594.999 12.4207 603.699 -5.7793 603.699 -5.7793H397.999C397.999 -5.7793 388.999 12.4207 377.359 42.8707Z"
                fill="#F2F5F8"
            />
            <path
                d="M445.87 27.2207H528.04"
                stroke="#BBC5CB"
                strokeWidth={6}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M-101 156.74H115.43C125.94 109.52 150.57 31.7402 168.17 -5.77979H-47.32C-47.32 -5.77979 -88.86 124.83 -101 156.74Z"
                fill="#F2F5F8"
            />
            <path
                d="M-16.54 138.91H69.57"
                stroke="#BBC5CB"
                strokeWidth={6}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M745.42 41.0702H944.42C955.06 11.7502 963.42 -5.77979 963.42 -5.77979H765.35C765.35 -5.77979 756.63 11.7502 745.42 41.0702Z"
                fill="#F2F5F8"
            />
            <path
                d="M811.41 26H890.55"
                stroke="#FFD2C6"
                strokeWidth={6}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M286.18 609C287.327 505.735 282.88 402.484 272.86 299.7C270.799 279.014 262.466 259.452 248.978 243.633C235.49 227.815 217.49 216.495 197.39 211.19C128.62 193 40.6001 179.84 -29.8799 176.55C-44.3699 175.88 -72.2199 177.55 -88.7699 182.9C-91.6499 183.84 -115.46 189.73 -116.98 190.97C-132.29 203.43 -114.34 222.41 -119.24 245.15C-135.3 319.64 -159.54 447.42 -171.17 585.75"
                fill="#5F8296"
            />
            <path
                d="M226.3 620.42C227.455 517.152 223.015 413.897 213 311.11C210.937 290.42 202.6 270.854 189.106 255.035C175.612 239.216 157.606 227.899 137.5 222.6C68.73 204.42 -19.28 191.25 -89.76 188C-110.363 187.006 -130.651 193.354 -147.013 205.914C-163.376 218.473 -174.753 236.43 -179.12 256.59C-195.18 331.05 -219.43 458.83 -231 597.16"
                fill="url(#ae8bd6c5__paint8_linear_25495_5756)"
            />
            <path
                d="M1181.5 527.771C1180.44 433.376 1174.26 339.108 1163 245.381C1160.7 226.518 1152.69 208.809 1140.04 194.627C1127.39 180.445 1110.71 170.468 1092.23 166.031C1029.01 150.811 948.31 140.571 883.83 139.031C868.27 138.661 835.97 141.551 823.38 149.031C804.45 160.331 807.98 180.541 803.56 203.511C790.41 271.901 770.85 389.171 763.05 515.831"
                fill="#5F8296"
            />
            <path
                d="M1134 534.261C1132.94 439.863 1126.77 345.592 1115.52 251.861C1113.22 232.999 1105.2 215.29 1092.56 201.109C1079.91 186.927 1063.23 176.949 1044.75 172.511C981.53 157.301 900.83 147.061 836.35 145.511C817.485 145.005 799.053 151.213 784.338 163.029C769.622 174.845 759.58 191.502 756 210.031C742.85 278.431 723.29 395.701 715.49 522.351"
                fill="#4F6C7F"
            />
            <path
                d="M905.337 -33.5373C835.357 -33.5373 798.452 24.9067 797.831 60.9951L809.561 83.0005C809.561 83.0005 810.929 108.632 778.547 125.826C746.166 143.021 730.522 164.264 741.779 187.371C741.779 187.371 712.133 213.899 723.663 243.765C735.193 273.631 774.707 278.473 774.707 278.473L1033.92 313.954C1033.92 313.954 1064.99 323.115 1095.5 296.999C1126.01 270.883 1117.15 224.933 1107.5 211.499C1095.5 194.788 1074.36 186.568 1074.36 186.568C1074.36 186.568 1083.47 163.388 1063.5 143.999C1043.53 124.61 1022.31 140.09 1016 114.499C1009.69 88.9085 1037.72 33.5454 991 -11.001C944.28 -55.5474 905.337 -33.5373 905.337 -33.5373Z"
                fill="#333333"
            />
            <path
                d="M932.75 203.999C1008.75 219.649 1069.22 261.389 1086.96 307.819C1104.7 354.249 1096.87 420.999 1096.87 420.999L857.87 463.259C857.87 463.259 657 413.699 658.61 412.649C660.22 411.599 697.37 341.169 725 287.999C752.63 234.829 811.53 216.519 844.4 207.649C877.27 198.779 932.75 203.999 932.75 203.999Z"
                fill="url(#ae8bd6c5__paint9_linear_25495_5756)"
            />
            <path
                d="M880.34 214.639L871.61 232.409C871.61 232.409 874.88 253.859 861.69 271.579C848.5 289.299 829.08 301.129 802.32 295.499C775.56 289.869 760.63 259.159 766.55 228.179C772.47 197.199 808 174.309 808 174.309L877.85 177.199L880.34 214.639Z"
                fill="url(#ae8bd6c5__paint10_linear_25495_5756)"
            />
            <path
                d="M864.64 268.929C867.11 272.829 871.05 275.929 877.22 277.259C901.09 282.349 923.96 267.869 923.96 267.869C923.96 267.869 954.27 249.479 955.26 225.609C956.25 201.739 944.91 140.849 944.91 140.849L944.13 98.4293V91.6293C944.13 91.6293 907.78 78.7393 888.21 24.7393C888.21 24.7393 852.02 59.2993 798.02 58.3293C798.02 58.3293 797.24 74.5693 798.02 87.3293C798.8 100.089 802.71 108.849 800.95 126.269C799.19 143.689 798.61 160.269 805.45 180.459C812.29 200.649 819.62 212.619 834.74 216.919C847.74 220.609 860.82 218.619 873.87 213.659L875.59 219.789C872.398 222.004 870.19 225.37 869.43 229.179C868.43 235.309 870.21 246.789 869.17 255.529C868.13 264.269 864.64 268.929 864.64 268.929Z"
                fill="#FFD4C2"
            />
            <path
                opacity={0.6}
                d="M926.54 94.169C922.54 101.169 913.78 120.749 922.8 146.039C930.8 168.549 943.8 174.149 950.64 175.509C947.88 156.769 944.91 140.849 944.91 140.849L944.13 98.429V91.629C944.13 91.629 908.31 78.929 888.64 25.999C888.64 25.999 900.63 74.629 926.54 94.169Z"
                fill="#F4C2AD"
            />
            <path
                opacity={0.6}
                d="M918.71 184.659C905.755 196.544 890.908 206.183 874.78 213.179L873.98 214.179L875.55 219.759C872.358 221.973 870.15 225.34 869.39 229.149C868.53 234.209 869.62 242.909 869.44 250.709C874.5 256.499 880 252.999 880 252.999C881.33 251.774 882.448 250.338 883.31 248.749C885.15 245.669 880.85 235.579 880.85 235.579C912.83 214.389 918.71 184.659 918.71 184.659Z"
                fill="#F8BDA4"
            />
            <path
                d="M946.15 147.529C946.15 147.529 984.9 145.939 1011.94 177.199C1038.98 208.459 1042.64 270.709 1009.94 301.979C977.24 333.249 914.46 330.419 899.25 298.309C884.04 266.199 904.48 242.829 924.11 232.409C943.74 221.989 952.25 209.339 952.93 194.409C951.14 178.879 948.84 163.249 946.15 147.529Z"
                fill="url(#ae8bd6c5__paint11_linear_25495_5756)"
            />
            <path
                d="M889.35 21.1491C889.35 21.1491 896.78 -0.170859 916.15 -11.1309"
                stroke="#333333"
                strokeMiterlimit={10}
            />
            <path
                d="M924 178.849C908.33 198.609 873.87 213.609 873.87 213.609L883 242.529C883 242.529 886 250.159 879.06 253.529"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M898.058 160.575C911.286 155.37 918.169 141.389 913.43 129.347C908.692 117.306 894.127 111.765 880.899 116.97C867.67 122.176 860.787 136.157 865.526 148.198C870.264 160.239 884.829 165.781 898.058 160.575Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M821.54 131.609C819.943 127.452 817.197 123.835 813.622 121.179C810.047 118.523 805.791 116.938 801.35 116.609C801.39 119.815 801.243 123.02 800.91 126.209C799.68 138.429 799.03 150.279 801.12 163.209C803.858 163.204 806.571 162.689 809.12 161.689C820.7 157.129 826.28 143.659 821.54 131.609Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M876.141 108.194C876.849 104.421 874.963 100.901 871.929 100.332C868.894 99.7622 865.861 102.359 865.153 106.131C864.445 109.904 866.33 113.424 869.365 113.993C872.399 114.563 875.433 111.966 876.141 108.194Z"
                fill="#333333"
            />
            <path
                d="M823.634 108.192C824.342 104.42 822.457 100.9 819.422 100.33C816.388 99.7606 813.354 102.357 812.646 106.13C811.938 109.902 813.824 113.422 816.858 113.992C819.893 114.561 822.926 111.965 823.634 108.192Z"
                fill="#333333"
            />
            <path
                d="M866.85 85.829C866.85 85.829 886.61 81.289 895.8 97.529"
                stroke="#333333"
                strokeWidth={4}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M823.33 85.829C823.33 85.829 807.18 81.289 799.66 97.529"
                stroke="#333333"
                strokeWidth={4}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M834.57 91.3892C834.57 91.3892 838.48 104.699 832.48 112.779C826.48 120.859 818.14 126.409 818.14 132.779C818.14 141.779 831.14 146.079 831.14 146.079"
                fill="#FFD4C2"
            />
            <path
                d="M834.57 91.3892C834.57 91.3892 838.48 104.699 832.48 112.779C826.48 120.859 818.14 126.409 818.14 132.779C818.14 141.779 831.14 146.079 831.14 146.079"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M828 178.844C833.603 182.206 841.253 184.196 849.548 182.206C858.769 179.995 864.126 175.001 869 166.999"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M748.87 354.219L717.57 405.869"
                stroke="#EEA70D"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M977.06 380.039L971.59 415.779"
                stroke="#EEA70D"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M982.85 125.379C979.13 141.199 983.05 153.749 971.36 157.119C967.47 158.239 949.08 157.719 945.11 156.789C929.23 153.049 920.38 132.929 925.34 111.849C929.53 93.9988 942.24 81.2388 955.66 79.9988C958.13 79.7588 976.03 79.5188 978.5 80.1088C994.38 83.7888 987.81 104.299 982.85 125.379Z"
                fill="#507CA0"
            />
            <path
                d="M991.64 125.379C987.92 141.199 977.99 153.749 966.3 157.119C962.41 158.239 957.87 157.719 953.9 156.789C938.02 153.049 929.16 132.929 934.13 111.849C938.32 93.9988 951 81.2388 964.45 79.9988C966.819 79.6204 969.235 79.6576 971.59 80.1088C987.47 83.7888 996.6 104.299 991.64 125.379Z"
                fill="#8AC9FF"
            />
            <path
                d="M950.13 110.659L966.77 93.1289L984 82.2289C982.433 81.0909 980.65 80.2845 978.76 79.8589C972.47 78.2789 958.13 79.5089 955.63 79.7489C943.41 80.9289 931.77 91.5389 926.46 106.799L950.13 110.659Z"
                fill="#75B5E6"
            />
            <path
                d="M935.89 -5.78076C973.89 16.1492 974.71 78.2192 974.71 78.2192L962.1 78.4692C958.58 78.7492 956.23 82.1792 953.4 83.6492L951.05 82.0892C951.05 82.0892 950.2 20.0092 912.24 -1.91076"
                fill="#8AC9FF"
            />
            <path
                d="M938.24 -6.49072C976.24 16.0093 976.12 79.3993 976.12 79.3993C972.18 79.0693 961.79 78.8193 953.4 83.6593C953.4 83.6593 952.54 19.9793 914.59 -2.52072"
                fill="#AEDCFF"
            />
            <path
                d="M1000.4 125.401C1005.36 104.317 996.514 84.1941 980.633 80.4548C964.753 76.7156 947.855 90.7762 942.891 111.86C937.926 132.944 946.775 153.067 962.655 156.807C978.535 160.546 995.433 146.485 1000.4 125.401Z"
                fill="#AEDCFF"
            />
            <path
                d="M989.691 122.88C992.806 109.65 987.252 97.0229 977.285 94.676C967.318 92.3292 956.713 101.152 953.598 114.382C950.482 127.611 956.037 140.239 966.003 142.586C975.97 144.933 986.575 136.11 989.691 122.88Z"
                fill="#75B5E6"
            />
        </g>
        <defs>
            <linearGradient
                id="ae8bd6c5__paint0_linear_25495_5756"
                x1={678.192}
                y1={-91.7923}
                x2={585.046}
                y2={390.108}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint1_linear_25495_5756"
                x1={182228}
                y1={1945.14}
                x2={182237}
                y2={3006.11}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint2_linear_25495_5756"
                x1={125126}
                y1={576.16}
                x2={125033}
                y2={13909.3}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint3_linear_25495_5756"
                x1={194199}
                y1={2476.48}
                x2={194159}
                y2={7296.73}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint4_linear_25495_5756"
                x1={99999.3}
                y1={4320.81}
                x2={99991.1}
                y2={5673.67}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint5_linear_25495_5756"
                x1={-4144.83}
                y1={354.878}
                x2={-4134.24}
                y2={1933.79}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint6_linear_25495_5756"
                x1={536.42}
                y1={-15.4101}
                x2={608}
                y2={400}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.6} />
                <stop offset={1} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint7_linear_25495_5756"
                x1={1301.57}
                y1={-15.41}
                x2={1373.15}
                y2={400}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.6} />
                <stop offset={1} />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint8_linear_25495_5756"
                x1={-7.90732}
                y1={443.161}
                x2={-19.4989}
                y2={208.778}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#79A1B5" />
                <stop offset={1} stopColor="#7E99AB" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint9_linear_25495_5756"
                x1={876}
                y1={323.499}
                x2={1109.5}
                y2={420.999}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint10_linear_25495_5756"
                x1={839.2}
                y1={187.739}
                x2={814.69}
                y2={249.419}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <linearGradient
                id="ae8bd6c5__paint11_linear_25495_5756"
                x1={135471}
                y1={30687.2}
                x2={137537}
                y2={49687.3}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <clipPath id="ae8bd6c5__clip0_25495_5756">
                <rect width={1200} height={400} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default FlightNoCityPhotoL;
