import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoTripsS = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 328 205"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#14366f8e__clip0_24891_5114)">
            <rect width={328} height={205} fill="#F5F4F2" />
            <g clipPath="url(#14366f8e__clip1_24891_5114)">
                <rect width={328} height={205} fill="#F5F4F2" />
                <g clipPath="url(#14366f8e__clip2_24891_5114)">
                    <path
                        d="M615 -26.4043H0V216.521H615V-26.4043Z"
                        fill="url(#14366f8e__paint0_linear_24891_5114)"
                    />
                    <path
                        d="M188.333 102.628C192.8 95.6054 198.536 89.4753 205.246 84.5518C216.009 76.8643 216.009 86.6018 216.009 86.6018C216.009 86.6018 229.846 79.4268 237.021 79.4268C248.399 79.4268 243.684 84.7875 243.684 84.7875C219.478 91.6806 200.546 98.1638 188.559 102.54"
                        fill="url(#14366f8e__paint1_linear_24891_5114)"
                    />
                    <path
                        d="M425.119 52.7869C422.556 37.4119 395.394 48.1744 395.394 48.1744C395.394 48.1744 394.881 35.8744 382.581 38.4369C370.281 40.9994 362.081 46.1244 362.081 46.1244C362.081 46.1244 368.231 28.6994 346.706 32.2869C325.181 35.8744 302.631 53.8119 294.944 64.5744C291.869 58.9369 277.006 66.6244 268.042 78.2223C310.939 67.265 365.376 56.5948 425.119 52.7869Z"
                        fill="url(#14366f8e__paint2_linear_24891_5114)"
                    />
                    <path
                        d="M191.957 70.7249C191.957 70.7249 193.981 63.0374 199.106 58.4249C204.231 53.8124 207.819 57.9124 207.819 57.9124C207.819 57.9124 212.944 26.1374 240.106 10.2499C267.269 -5.6376 263.169 25.6249 263.169 25.6249C263.169 25.6249 273.931 10.7624 289.306 9.2249C304.681 7.6874 305.706 17.9374 305.706 17.9374C305.706 17.9374 307.244 -8.2001 335.944 -14.3501C364.644 -20.5001 472.269 -17.4251 472.269 -17.4251C349.269 -5.89385 245.559 41.6149 192.019 70.6788"
                        fill="url(#14366f8e__paint3_linear_24891_5114)"
                    />
                    <path
                        d="M162.411 44.8531C168.356 17.4241 191.419 4.09909 191.931 13.3241C191.931 13.3241 196.544 -12.3009 222.681 -19.4759C248.819 -26.6509 246.256 -15.3759 246.256 -15.3759C215.699 0.851269 187.473 21.1314 162.345 44.9146"
                        fill="url(#14366f8e__paint4_linear_24891_5114)"
                    />
                    <path
                        d="M364.583 93.7406C364.552 86.4068 347.363 92.7823 347.363 92.7823C347.363 92.7823 346.297 87.7034 336.267 88.2364C330.249 88.5644 324.451 90.6057 319.554 94.1199C319.554 94.1199 318.622 83.8238 302.888 84.8283C287.154 85.8328 274.398 100.449 274.398 100.449C274.398 100.449 273.296 95.9393 265.978 97.0411C258.659 98.143 246.323 107.045 246.323 107.045C279.825 102.217 322.132 96.9028 364.583 93.7406Z"
                        fill="url(#14366f8e__paint5_linear_24891_5114)"
                    />
                    <path
                        d="M256.849 136.489C256.849 136.489 266.91 135.002 283.346 133.665L283.5 133.598C282.983 132.975 282.252 132.567 281.45 132.455C277.134 131.43 270.369 133.48 270.369 133.48C270.369 133.48 271.568 130.021 264.855 129.97C258.141 129.918 252.017 134.07 252.017 134.07"
                        fill="url(#14366f8e__paint6_linear_24891_5114)"
                    />
                    <path
                        d="M317.417 136.325C317.417 136.325 325.171 133.04 330.419 133.337C335.667 133.634 334.996 135.387 334.996 135.387C334.996 135.387 345.292 129.75 353.179 130.877C361.067 132.005 359.329 135.356 359.329 135.356C359.329 135.356 365.413 132.481 369.22 134.552C373.028 136.622 378.784 137.991 378.784 137.991C358.418 136.352 337.978 135.829 317.555 136.422"
                        fill="url(#14366f8e__paint7_linear_24891_5114)"
                    />
                    <path
                        d="M0 177.499L108.65 157.337C108.65 157.337 277.309 153.329 268.038 143.1C262.414 136.978 254.619 133.298 246.318 132.85C246.318 132.85 233.987 114.805 226.366 111.996C218.745 109.188 211.929 116.85 211.929 116.85C211.929 116.85 181.071 54.2222 158.183 58.353C141.199 61.428 133.46 77.9612 133.46 77.9612C98.9689 -7.57504 53.5101 -18.0915 53.5101 -18.0915L29.5559 -26.4043H0V177.499Z"
                        fill="url(#14366f8e__paint8_linear_24891_5114)"
                    />
                    <path
                        opacity={0.51}
                        d="M53.4997 -18.0917C53.4997 -18.0917 98.9687 -7.57515 133.45 77.9611C133.45 77.9611 140.825 61.7815 158.173 58.4861C180.789 54.1555 211.929 116.85 211.929 116.85C211.929 116.85 218.75 109.229 226.371 112.037C233.992 114.846 246.323 132.891 246.323 132.891C254.624 133.339 262.419 137.019 268.042 143.141C277.308 153.391 108.655 157.378 108.655 157.378L-8.06689 178.995L-2.64977 -37.5923L53.4997 -18.0917Z"
                        fill="url(#14366f8e__paint9_linear_24891_5114)"
                    />
                    <path
                        opacity={0.2}
                        d="M133.47 77.9765L136.878 86.1406C136.878 86.1406 144.566 103.309 146.426 108.691C146.426 108.691 137.606 65.6406 158.214 58.5015C142.803 61.2382 134.06 76.2135 133.47 77.9765Z"
                        fill="#06001A"
                    />
                    <path
                        opacity={0.07}
                        d="M221.318 111.407C215.988 112.206 211.945 116.716 211.945 116.716C211.945 116.716 216.045 125.459 218.228 133.219C218.213 133.219 216.506 116.199 221.318 111.407Z"
                        fill="#06001A"
                    />
                    <g opacity={0.5}>
                        <path
                            opacity={0.5}
                            d="M-12.0434 94.0388C-9.11188 96.996 -4.00741 95.1356 -0.824783 92.4552C2.35784 89.7748 5.41237 86.2181 9.56874 86.008C13.3869 85.8183 16.836 88.6115 20.6592 88.632C25.5229 88.6576 29.1616 84.3782 33.4307 82.0515C39.9856 78.4896 48.1907 79.6427 55.0274 82.6255C61.8641 85.6082 67.8399 90.2258 74.4204 93.757C81.0009 97.2881 88.6577 99.7481 95.8788 97.857C99.7789 96.832 103.279 94.6487 107.154 93.5212C111.188 92.4204 115.453 92.4998 119.443 93.7508C123.432 95.0018 126.98 97.3716 129.663 100.578C132.476 104.043 134.327 108.507 138.155 110.787C140.205 112.017 143.075 112.986 143.28 115.4C143.449 117.404 141.522 118.885 139.8 119.925C100.158 143.849 52.4546 151.454 6.15037 150.27C-1.02466 150.086 -8.28163 149.686 -15.1645 147.641C-17.891 146.826 -20.5919 145.73 -22.7854 143.92C-24.9807 142.007 -26.6943 139.604 -27.7874 136.904C-33.1379 124.568 -28.6279 109.86 -20.5663 99.0972C-18.5163 96.3348 -15.923 93.5725 -12.52 92.9882"
                            fill="#4F6C7F"
                        />
                    </g>
                    <path
                        d="M248.947 142.5C248.988 140.71 248.358 138.97 247.182 137.62C246.005 136.271 244.366 135.41 242.587 135.207C240.024 135.008 237.354 136.232 234.899 135.494C233.7 135.125 232.685 134.321 231.532 133.834C226.407 131.671 220.432 136.099 215.184 134.346C210.059 132.63 208.567 126.331 205.579 121.852C200.608 114.385 189.579 111.761 181.774 116.183C179.109 117.721 176.541 119.976 173.481 119.771C170.57 119.592 168.28 117.208 165.476 116.388C163.503 115.82 161.376 116.06 159.393 115.481C155.99 114.456 153.791 111.289 151.003 109.101C149.218 107.716 147.162 106.721 144.969 106.178C142.776 105.635 140.493 105.557 138.268 105.949C135.193 106.507 132.317 107.958 129.212 108.311C127.786 108.501 126.336 108.317 125.003 107.778C123.67 107.239 122.499 106.363 121.606 105.236C119.992 103.34 119.044 100.798 116.727 99.5989C113.703 98.0614 109.978 99.4195 106.672 98.6303C103.74 97.9333 101.47 95.6116 99.7686 93.126C98.0671 90.6404 96.7397 87.8831 94.7717 85.6025C91.01 81.2514 85.0701 79.0528 79.3301 79.3551C73.5901 79.6575 68.1012 82.3123 63.8833 86.2175C60.424 89.4206 57.7795 93.3925 54.5456 96.8211C51.3117 100.25 47.1503 103.227 42.4455 103.525C40.4775 103.643 38.5146 103.274 36.5415 103.238C32.8464 103.166 29.1154 104.263 25.4869 103.566C22.9244 103.053 20.5669 101.71 18.0249 101.039C15.8783 100.492 13.6355 100.441 11.4662 100.889C9.29701 101.338 7.25823 102.274 5.50451 103.627C3.45451 105.247 1.84013 107.42 -0.307245 108.932C-2.45462 110.443 -5.52961 111.161 -7.64111 109.603L-4.65837 131.579C-4.65837 131.579 124.092 139.6 126.501 140.004C128.909 140.409 242.812 149.629 242.812 149.629L248.947 142.5Z"
                        fill="#4F6C7F"
                    />
                    <path
                        d="M327.17 147.184C329.665 146.662 331.977 145.486 333.868 143.776C334.816 142.92 335.652 141.931 336.723 141.213C338.949 139.974 341.491 139.418 344.031 139.614C345.262 139.893 346.464 140.29 347.619 140.798C351.32 142.153 355.34 142.379 359.17 141.449C361.103 140.978 362.973 140.209 364.946 139.973C372.413 139.071 379.481 145.795 386.81 144.124C389.08 143.612 391.089 142.315 393.042 141.049C393.687 142.664 393.252 144.504 392.58 146.103C390.904 150.075 387.916 153.351 384.114 155.384C379.035 158.08 373.028 158.285 367.283 158.095C362.661 157.941 358.048 157.571 353.446 156.983C350.14 156.558 346.814 156.014 343.739 154.733C341.084 153.626 338.681 152.002 336.149 150.633C333.714 149.32 331.156 148.247 328.513 147.43"
                        fill="#4F6C7F"
                    />
                    <path
                        d="M-76.875 133.158C-34.3375 134.362 27.8082 106.287 91.9835 108.691C156.159 111.095 226.464 148.113 306.987 148.113C387.511 148.113 448.202 124.578 555.017 120.525C661.832 116.471 736.109 166.25 736.109 166.25L615 330.496L99.6249 369L-31.1139 304.825L-76.875 133.158Z"
                        fill="url(#14366f8e__paint10_radial_24891_5114)"
                    />
                    <path
                        opacity={0.41}
                        d="M130.846 39.355C133.668 39.355 135.956 37.0673 135.956 34.2454C135.956 31.4234 133.668 29.1357 130.846 29.1357C128.025 29.1357 125.737 31.4234 125.737 34.2454C125.737 37.0673 128.025 39.355 130.846 39.355Z"
                        fill="url(#14366f8e__paint11_linear_24891_5114)"
                    />
                    <path
                        d="M132.707 38.7976C137.881 36.3499 141.409 32.9594 140.588 31.2247C139.768 29.49 134.908 30.068 129.735 32.5156C124.562 34.9633 121.033 38.3538 121.854 40.0884C122.675 41.8232 127.534 41.2452 132.707 38.7976Z"
                        fill="url(#14366f8e__paint12_radial_24891_5114)"
                    />
                    <path
                        d="M133.032 39.4753C138.205 37.0276 141.734 33.6372 140.913 31.9025C140.092 30.1677 135.233 30.7457 130.06 33.1934C124.887 35.641 121.358 39.0315 122.179 40.7662C123 42.5009 127.859 41.923 133.032 39.4753Z"
                        fill="url(#14366f8e__paint13_radial_24891_5114)"
                    />
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M132.461 37.8686C135.024 36.6693 136.746 35.0037 136.336 34.1478C135.925 33.292 133.517 33.5585 130.965 34.7526C128.412 35.9467 126.68 37.6123 127.095 38.4733C127.51 39.3343 129.914 39.0627 132.461 37.8686Z"
                        fill="white"
                    />
                    <path
                        d="M151.395 85.2907L154.634 91.2346L153.786 91.5978C153.786 91.5978 148.741 88.7264 148.3 85.8182C147.859 82.91 152.853 83.3491 152.853 83.3491L151.395 85.2907Z"
                        fill="#2F2F2F"
                    />
                    <path
                        d="M144.088 86.9131C144.784 87.9788 145.204 89.8521 144.143 91.1545L146.061 94.9058L145.334 95.2173C145.334 95.2173 142.249 92.8824 140.453 90.4738C138.657 88.0652 140.332 87.3478 140.332 87.3478L144.088 86.9131Z"
                        fill="#2F2F2F"
                    />
                    <path
                        d="M136.182 85.3762C135.947 84.4544 136.061 83.4784 136.504 82.6364C136.946 81.7941 137.686 81.1462 138.578 80.8176C139.627 80.4368 140.855 79.9758 142.144 79.4672C145.816 78.0182 148.42 76.4306 150.187 76.6026C151.328 76.7134 154.924 79.1617 157.401 80.9273C157.487 80.4028 158.011 79.5075 158.482 79.4483C158.583 79.4363 158.342 81.2949 158.638 81.7614C158.83 81.6231 159.375 81.4735 159.577 81.6697C159.877 81.9637 159.543 82.4672 159.543 82.4672C159.719 82.5966 159.861 82.7034 159.963 82.7747C160.556 83.2011 161.569 84.0719 162.369 84.8073C162.648 85.0652 162.833 85.4083 162.896 85.7831C162.958 86.1577 162.895 86.5424 162.715 86.8771C162.537 87.206 162.257 87.4678 161.917 87.6226C161.576 87.7774 161.195 87.8166 160.83 87.7343C159.452 87.4176 157.681 86.7938 156.934 86.2969C155.804 85.5382 156.071 84.8555 155.479 84.5993C155.319 84.5284 155.108 84.42 154.886 84.3007C154.815 84.2625 154.734 84.2488 154.655 84.2619C154.576 84.2749 154.504 84.314 154.449 84.3731C154.395 84.4321 154.362 84.5074 154.355 84.5873C154.349 84.6672 154.369 84.747 154.413 84.814L157.681 89.919L156.878 90.2631C156.508 90.1011 156.158 89.8977 155.835 89.6567C154.693 88.8256 151.359 85.8146 151.359 85.8146L142.76 89.4983C142.501 90.5451 141.909 91.4797 141.074 92.1621L143.134 96.1507L142.331 96.4948C141.787 96.1685 141.29 95.7699 140.854 95.3101C139.554 93.9657 138.749 93.5281 138.274 92.762C137.989 92.3 136.946 88.3636 136.182 85.3762Z"
                        fill="#E7E7E7"
                    />
                    <path
                        d="M160.844 87.7311L160.414 87.6264C160.774 86.4835 161.276 85.3904 161.909 84.3732C162.071 84.5183 162.233 84.6635 162.378 84.7936C162.655 85.0498 162.839 85.3899 162.903 85.7616C162.966 86.1329 162.905 86.515 162.73 86.8486C162.554 87.182 162.274 87.4484 161.932 87.6063C161.589 87.7641 161.204 87.8047 160.837 87.7217L160.844 87.7311Z"
                        fill="#FBCDC3"
                    />
                    <path
                        d="M159.421 84.6911C159.544 84.6383 159.589 84.4685 159.522 84.312C159.455 84.1556 159.301 84.0713 159.178 84.1241C159.055 84.1769 159.009 84.3468 159.076 84.5032C159.143 84.6597 159.297 84.7439 159.421 84.6911Z"
                        fill="#2F2F2F"
                    />
                    <path
                        d="M160.194 83.6896C160.317 83.6368 160.362 83.467 160.295 83.3106C160.228 83.1541 160.074 83.0698 159.951 83.1227C159.828 83.1754 159.782 83.3453 159.849 83.5017C159.916 83.6582 160.07 83.7424 160.194 83.6896Z"
                        fill="#2F2F2F"
                    />
                    <path
                        d="M131.09 86.9866C131.253 89.6353 134.608 90.121 135.016 87.4484C135.656 83.3439 136.786 82.602 136.786 82.602"
                        stroke="#333333"
                        strokeMiterlimit={10}
                    />
                    <path
                        d="M131.196 87.6173C131.196 87.6173 131.758 86.0283 131.446 85.6466C131.133 85.2648 130.054 85.4071 130.514 86.4897C130.975 87.5723 131.196 87.6173 131.196 87.6173Z"
                        fill="#333333"
                    />
                    <path
                        d="M157.025 80.6447C154.567 78.9019 151.28 76.7035 150.2 76.5976C148.536 76.4406 146.112 77.8455 142.75 79.2297C143.007 80.1851 143.646 81.5673 145.213 81.6725C147.623 81.8364 148.845 80.6139 149.786 81.8885C151.742 84.5483 155.62 84.406 157.025 80.6447Z"
                        fill="#525252"
                    />
                    <path
                        d="M138.436 80.879C137.582 81.2311 136.883 81.8801 136.468 82.7065C136.054 83.5329 135.952 84.4815 136.182 85.3769C136.561 86.864 137.013 88.587 137.403 89.998C137.751 89.7294 138.004 89.3585 138.129 88.9376C138.253 88.5167 138.243 88.0675 138.098 87.6532C137.576 86.2523 138.704 86.2037 139.512 84.1086C139.937 83.004 139.217 81.7872 138.436 80.879Z"
                        fill="#525252"
                    />
                    <path
                        d="M143.527 83.6033C142.048 83.5506 140.892 85.2261 141.282 86.2302C141.672 87.2344 142.991 88.5518 144.991 87.0208C146.991 85.4898 147.009 85.5817 147.872 85.094C148.735 84.6063 148.903 83.0991 147.667 83.0786C146.431 83.0582 145.673 83.6749 143.527 83.6033Z"
                        fill="#525252"
                    />
                    <path
                        d="M154.94 87.9248C155.4 88.557 155.555 88.9601 155.474 89.3737C155.606 89.4787 155.728 89.5755 155.83 89.6467C156.154 89.8877 156.503 90.0912 156.873 90.2532L157.676 89.9091L154.958 85.6309C154.774 86.2469 154.533 87.3661 154.94 87.9248Z"
                        fill="#333333"
                    />
                    <path
                        d="M133.004 36.6741L127.039 38.1091V117.229L207.516 136.683L136.335 34.1475L133.004 36.6741Z"
                        fill="url(#14366f8e__paint14_linear_24891_5114)"
                    />
                    <path
                        d="M88.0476 150.787C92.2039 147.661 93.8798 142.049 97.9849 138.846C102.495 135.32 108.901 135.515 114.446 136.94C117.393 137.698 120.315 138.764 123.359 138.805C126.649 138.851 129.837 137.698 132.876 136.438C139.426 133.721 146.093 130.344 153.171 130.8C161.986 131.379 169.484 138.037 173.527 145.893C174.45 147.687 175.28 149.619 176.818 150.921C178.025 151.859 179.443 152.489 180.948 152.755C189.738 154.631 199.398 149.501 207.624 153.078C213.666 155.707 217.095 162.303 222.876 165.496C221.062 166.419 218.95 166.475 216.916 166.521C172.338 167.389 127.751 167.946 83.1532 168.192C82.6151 168.238 82.0733 168.154 81.5747 167.946C80.0372 167.152 80.5804 164.835 81.3902 163.303C83.8809 158.625 86.8319 154.208 90.2001 150.116"
                        fill="#306468"
                    />
                    <path
                        d="M303.502 159.505C307.37 158.755 311.114 157.472 314.629 155.692C316.761 154.611 318.811 153.35 321.035 152.484C324.698 151.067 328.698 150.769 332.53 151.628C335.247 152.243 337.85 153.437 340.628 153.606C346.46 153.965 351.631 149.824 357.417 148.994C361.184 148.451 365.064 149.363 368.457 151.09C371.849 152.817 374.791 155.318 377.441 158.05C375.504 158.446 373.528 158.619 371.552 158.562L303.784 159.434"
                        fill="#306468"
                    />
                    <path
                        d="M-14.6831 158.828C240.158 176.909 508.538 127.688 618.833 158.828L551.901 251.724L329.65 296.224L66.5378 260.103L-14.6831 230.624V158.828Z"
                        fill="url(#14366f8e__paint15_radial_24891_5114)"
                    />
                    <path
                        d="M223.375 163.964L225.815 173.879H228.117C228.117 173.879 229.28 167.059 228.057 162.372C226.834 157.684 223.375 160.791 223.375 160.791V163.964Z"
                        fill="black"
                    />
                    <path
                        d="M233.995 160.532C233.637 162.592 234.216 165.715 236.662 166.982L236.182 173.901H238.386C238.386 173.901 241.371 168.426 242.523 163.611C243.674 158.797 239.939 158.747 239.939 158.747L233.995 160.532Z"
                        fill="black"
                    />
                    <path
                        d="M247.243 153.08C247.002 151.527 246.192 150.119 244.97 149.132C243.747 148.144 242.202 147.647 240.633 147.736C238.798 147.841 236.645 147.94 234.364 148.006C227.869 148.194 222.901 147.455 220.339 148.882C218.687 149.791 219.364 163.419 219.265 164.02L218.466 173.869H220.598C221.045 173.357 221.444 172.804 221.788 172.217C222.972 170.217 225.644 163.552 225.644 163.552H239.966C241.068 164.967 242.032 165.97 243.822 166.488L242.798 173.891H245.172C245.783 173.043 246.278 172.117 246.643 171.137C247.384 169.372 247.898 167.522 248.174 165.628C248.279 164.73 248.02 158.12 247.243 153.08Z"
                        fill="#AA4635"
                    />
                    <path
                        d="M253.297 162.591C253.297 162.591 249.772 162.745 249.177 157.562C248.394 150.77 244.527 149.271 244.527 149.271"
                        stroke="#8D1C2F"
                        strokeWidth={0.550858}
                        strokeMiterlimit={10}
                    />
                    <path
                        d="M251.44 162.059C251.44 162.059 253.198 161.161 253.693 161.453C254.189 161.745 254.195 163.034 252.862 162.67C251.529 162.307 251.44 162.059 251.44 162.059Z"
                        fill="#3A1515"
                    />
                    <path
                        d="M249.392 161.976C248.334 161.149 250.047 151.586 244.103 148.524C243.051 147.925 241.847 147.645 240.639 147.714C238.804 147.819 236.65 147.918 234.37 147.984C230.784 148.089 227.666 147.918 225.159 147.984C222.956 147.984 221.673 148.281 220.918 148.612C220.726 148.676 220.541 148.761 220.367 148.865C215.343 152.374 214.825 158.009 214.544 163.006C214.661 163.802 215.002 164.548 215.529 165.155C216.057 165.762 216.747 166.206 217.519 166.432C217.39 166.313 217.287 166.168 217.217 166.006C217.148 165.844 217.114 165.67 217.117 165.494C217.12 165.318 217.16 165.145 217.235 164.986C217.31 164.826 217.418 164.685 217.552 164.57C218.61 164.956 219.078 166.283 218.825 167.374C218.493 168.454 217.837 169.406 216.946 170.101C217.494 170.208 218.061 170.172 218.591 169.996C219.121 169.819 219.596 169.508 219.97 169.093C220.301 169.594 220.518 170.161 220.607 170.755C220.695 171.349 220.653 171.954 220.483 172.53C221.158 172.358 221.79 172.047 222.34 171.618C222.889 171.188 223.342 170.649 223.672 170.035C224.366 168.828 224.939 168.195 225.082 166.812C225.762 167.544 226.137 168.507 226.129 169.506C226.869 168.95 227.378 168.139 227.556 167.231C228.107 167.457 228.365 168.046 228.657 168.553C228.949 169.06 229.445 169.572 230.024 169.473C229.943 169.002 230.005 168.518 230.201 168.082C230.398 167.646 230.719 167.279 231.125 167.027C231.451 167.502 231.705 168.021 231.88 168.569C232.225 168.471 232.543 168.297 232.812 168.059C233.08 167.822 233.293 167.528 233.433 167.198C233.877 167.695 234.198 168.29 234.368 168.934C234.539 169.578 234.554 170.253 234.414 170.905C235.176 170.624 235.856 170.156 236.391 169.545C236.927 168.935 237.302 168.199 237.482 167.407C237.652 167.844 237.945 168.222 238.325 168.497C238.705 168.772 239.157 168.931 239.625 168.955C239.278 168.531 239.746 167.853 240.286 167.798C240.559 167.808 240.827 167.873 241.073 167.991C241.319 168.108 241.539 168.275 241.718 168.481C242.396 169.12 243.007 169.98 242.892 170.905C243.845 170.641 244.691 170.083 245.309 169.311C245.927 168.539 246.286 167.591 246.334 166.603C246.936 167.052 247.394 167.666 247.651 168.371C247.651 168.371 248.152 167.859 248.037 166.349C247.973 165.753 247.755 165.183 247.403 164.697C247.998 164.532 248.61 164.433 249.193 164.229C249.588 164.119 249.947 163.909 250.237 163.619C250.526 163.33 250.736 162.971 250.846 162.576C250.325 162.476 249.831 162.271 249.392 161.976Z"
                        fill="#752936"
                    />
                    <path
                        d="M212.849 148.156C212.849 148.156 212.869 153.158 213.084 155.167C213.298 157.176 214.698 159.486 217.117 159.388C219.536 159.291 221.793 157.121 222.148 153.82C222.503 150.518 222.708 147.88 222.708 147.88L212.849 148.156Z"
                        fill="#AA4635"
                    />
                    <path
                        opacity={0.5}
                        d="M217.301 153.826C215.839 153.765 214.383 154.025 213.032 154.586C213.046 154.798 213.063 154.999 213.084 155.17C213.294 157.185 214.698 159.488 217.117 159.391C219.368 159.302 221.465 157.423 222.039 154.515C220.499 154.067 218.905 153.835 217.301 153.826Z"
                        fill="#FBCDC3"
                    />
                    <path
                        d="M215.571 155.406C214.779 155.42 214.732 157.518 215.443 157.632C216.154 157.747 216.466 155.395 215.571 155.406Z"
                        fill="#AA4635"
                    />
                    <path
                        d="M218.289 155.212C217.504 155.32 217.711 157.41 218.436 157.448C219.162 157.485 219.18 155.093 218.289 155.212Z"
                        fill="#AA4635"
                    />
                    <path
                        d="M212.927 143.957C212.044 143.749 211.227 143.323 210.553 142.717C209.759 141.847 209.523 139.605 209.523 139.605C209.523 139.605 208.234 142.48 208.625 143.825C209.016 145.169 211.632 146.645 211.632 146.645L212.927 143.957Z"
                        fill="#AA4635"
                    />
                    <path
                        d="M221.884 144.101C221.884 144.101 223.735 143.666 224.638 142.647C225.541 141.628 225.844 139 225.844 139C225.844 139 227.354 142.371 226.891 143.958C226.428 145.544 223.371 147.263 223.371 147.263L221.884 144.101Z"
                        fill="#AA4635"
                    />
                    <path
                        d="M223.277 143.322C222.549 142.334 221.522 141.608 220.347 141.252C218.111 140.703 215.757 140.881 213.628 141.76C213.655 141.985 213.758 142.194 213.92 142.353C214.082 142.511 214.294 142.609 214.52 142.63C214.52 142.63 210.872 143.017 209.781 150.086C209.971 150.203 210.187 150.27 210.409 150.283C210.631 150.296 210.854 150.254 211.056 150.16C211.354 150.864 211.543 151.609 211.617 152.37C211.667 152.852 211.566 153.336 211.327 153.757C211.327 153.757 216.059 153.947 218.252 150.901C218.411 151.091 218.529 151.311 218.599 151.549C218.668 151.787 218.687 152.037 218.654 152.282C218.654 152.282 223.744 150.842 224.09 147.975C224.328 146.377 224.043 144.745 223.277 143.322Z"
                        fill="#752936"
                    />
                    <path
                        d="M77.1157 124.46C77.1157 124.46 87.7245 116.773 88.8366 107.107C88.8617 106.882 88.9591 106.671 89.1139 106.505C89.2686 106.339 89.4726 106.228 89.6956 106.187C89.919 106.146 90.1491 106.178 90.3526 106.278C90.556 106.378 90.7216 106.541 90.8251 106.743C93.2338 111.458 96.2525 120.207 91.0813 128.063C83.5373 139.507 77.1157 124.46 77.1157 124.46Z"
                        fill="white"
                    />
                    <path
                        d="M51.0095 125.337C51.0095 125.337 37.5666 119.725 33.8971 109.516C33.8142 109.276 33.6558 109.07 33.4457 108.928C33.2357 108.786 32.9852 108.716 32.7318 108.727C32.4784 108.74 32.2358 108.833 32.0403 108.995C31.8448 109.157 31.7068 109.377 31.6472 109.624C30.243 115.348 29.1975 125.593 36.7722 132.789C47.8678 143.274 51.0095 125.337 51.0095 125.337Z"
                        fill="white"
                    />
                    <path
                        d="M84.332 125.629C84.332 125.629 91.0868 120.867 100.307 129.334C100.626 129.639 100.818 130.054 100.845 130.495C100.871 130.935 100.73 131.371 100.45 131.712C98.7128 133.849 94.3514 137.601 86.136 135.643"
                        fill="white"
                    />
                    <path
                        d="M98.9128 130.297C95.4791 128.965 92.1683 128.278 85.9466 128.878C83.9632 129.067 82.3232 131.225 82.1746 132.814C82.1771 132.844 82.1771 132.875 82.1746 132.906C81.9491 134.741 83.584 136.314 85.8748 136.247C91.62 136.078 96.745 134.305 99.3997 131.86C100.066 131.225 99.82 130.656 98.9128 130.297Z"
                        fill="#D9D9D9"
                    />
                    <path
                        d="M108.584 152.13C99.9684 139.318 89.3801 127.213 85.7311 124.42C80.6061 120.484 71.622 118.516 58.2816 121.247C44.9413 123.979 42.6453 130.329 42.6453 130.329C42.6453 130.329 30.3812 125.419 20.7718 138.016C20.4702 138.422 20.3291 138.924 20.3754 139.428C20.4218 139.931 20.6523 140.399 21.0229 140.743C22.6834 142.28 26.0198 143.91 31.3806 144.715L24.1389 148.497C14.4246 150.748 4.47144 151.803 -5.49895 151.638C-29.1662 151.234 -69.5615 146.37 -88.1191 151.638C-106.677 156.907 -115.456 165.476 -117.291 187.114C-119.125 208.751 -120.15 250.356 -120.15 250.356L57.1336 251.74L68.7725 192.874L72.155 178.063L82.8048 182.829C86.6577 184.554 90.9433 185.067 95.0945 184.302C99.2457 183.537 103.067 181.529 106.052 178.545C109.469 175.117 111.589 170.609 112.051 165.791C112.512 160.974 111.287 156.145 108.584 152.13Z"
                        fill="#F7F7F7"
                    />
                    <path
                        d="M89.2058 145.637C86.4522 143.529 83.7082 141.382 80.9751 139.195C80.2647 138.683 79.639 138.064 79.1198 137.36C77.9411 135.577 77.5823 132.819 78.9404 131.169C80.4779 129.334 81.3492 127.669 81.4261 125.532C81.4256 124.092 81.0735 122.674 80.4011 121.401C75.0813 119.546 67.7269 119.089 58.1176 121.063C55.1943 121.622 52.3519 122.543 49.6562 123.804C49.7257 126.193 50.2784 128.544 51.2808 130.713C51.6432 131.609 52.2079 132.409 52.9311 133.05C53.565 133.508 54.2723 133.854 55.0221 134.075C56.3648 134.542 57.7342 134.93 59.1221 135.238C62.4379 135.976 66.0306 136.345 68.6802 138.472C72.0114 141.147 72.9954 144.161 75.9782 148.927C76.8904 150.388 82.1282 157.332 83.9322 157.389C86.1411 157.455 89.7132 152.525 91.7376 151.638C92.0809 151.49 95.3251 153.396 95.5711 153.109C96.2373 152.34 90.2769 146.452 89.2058 145.637Z"
                        fill="#1F1F1F"
                    />
                    <path
                        d="M-38.9498 169.99C-14.6316 170.539 -18.9623 184.668 6.69349 183.474C23.1909 182.721 36.931 164.824 36.6696 145.36C34.8909 145.302 33.1209 145.086 31.3806 144.714L24.139 148.496C14.4246 150.748 4.47152 151.802 -5.49889 151.638C-22.4473 151.346 -47.9698 148.773 -67.9111 149.275C-64.7593 156.476 -56.6054 169.596 -38.9498 169.99Z"
                        fill="#1F1F1F"
                    />
                    <path
                        d="M61.5104 144.653C63.1268 144.653 64.4367 143.147 64.4367 141.291C64.4367 139.434 63.1268 137.929 61.5104 137.929C59.8944 137.929 58.584 139.434 58.584 141.291C58.584 143.147 59.8944 144.653 61.5104 144.653Z"
                        fill="#1F1F1F"
                    />
                    <path
                        d="M86.1515 139.568C87.7679 139.568 89.0778 138.063 89.0778 136.206C89.0778 134.349 87.7679 132.844 86.1515 132.844C84.5356 132.844 83.2251 134.349 83.2251 136.206C83.2251 138.063 84.5356 139.568 86.1515 139.568Z"
                        fill="#1F1F1F"
                    />
                    <path
                        d="M105.698 178.914C109.267 175.503 111.512 170.939 112.037 166.031C112.561 161.123 111.331 156.187 108.563 152.1C107.594 150.659 109.588 153.509 108.563 152.1C102.833 147.825 86.8125 150.347 78.9354 156.574C69.777 163.815 68.2088 173.999 73.8104 178.832L82.7945 182.85C86.5701 184.539 90.7634 185.067 94.8403 184.367C98.9173 183.665 102.693 181.767 105.688 178.914H105.698Z"
                        fill="#FBCDC3"
                    />
                    <path
                        d="M89.3289 161.847C85.9464 161.596 84.578 174.296 88.76 174.85C92.942 175.403 92.5935 162.088 89.3289 161.847Z"
                        fill="#D38579"
                    />
                    <path
                        d="M100.932 159.511C97.5442 159.7 97.8158 172.472 102.029 172.482C106.241 172.492 104.196 159.331 100.932 159.511Z"
                        fill="#D38579"
                    />
                    <path
                        opacity={0.2}
                        d="M72.1547 178.083C61.095 173.629 54.6836 169.745 54.6836 169.745C55.2935 176.551 63.7138 186.626 70.5711 185.089C70.7248 185.048 72.1547 178.083 72.1547 178.083Z"
                        fill="#666666"
                    />
                    <path
                        d="M77.3877 173.629C77.3877 173.629 78.4127 181.286 87.7197 182.224"
                        stroke="#D38579"
                        strokeWidth={2}
                        strokeMiterlimit={10}
                        strokeLinecap="round"
                    />
                    <path
                        d="M23.7033 140.728C26.0198 141.85 30.3094 143.428 36.5517 143.751C37.518 143.797 38.4676 143.488 39.2225 142.884C39.9773 142.279 40.4855 141.419 40.6517 140.466C40.6517 140.43 40.6517 140.389 40.6517 140.353C40.7786 139.826 40.795 139.277 40.6999 138.742C40.6047 138.208 40.4002 137.698 40.0989 137.246C39.7977 136.795 39.4063 136.41 38.9493 136.117C38.4924 135.823 37.9797 135.627 37.4434 135.541C31.7291 134.762 26.4093 136.1 23.4471 138.693C22.6783 139.369 22.7859 140.282 23.7033 140.728Z"
                        fill="#D9D9D9"
                    />
                    <path
                        d="M99.2407 203.55C99.2407 203.55 129.709 188.831 205.113 188.37C280.517 187.908 342.883 212.375 420.875 213.374C498.868 214.374 565.318 150.035 665.338 154.381C765.358 158.727 650.727 229.631 650.727 229.631L294.539 260.704L124.471 229.631L99.2407 203.55Z"
                        fill="#065E66"
                    />
                    <path
                        d="M154.053 218.806C154.053 218.806 157.153 177.412 207.517 170.862C196.764 199.839 154.053 218.806 154.053 218.806Z"
                        fill="#0B4E51"
                    />
                    <path
                        d="M137.207 164.646C137.207 164.646 133.409 201.346 148.451 219.191C163.385 188.702 137.207 164.646 137.207 164.646Z"
                        fill="#0B4E51"
                    />
                    <path
                        d="M118.388 168.197C118.388 168.197 145.617 179.472 144.935 217.587C117.363 200.341 118.388 168.197 118.388 168.197Z"
                        fill="#0B4E51"
                    />
                    <path
                        d="M275.766 174.368C275.766 174.368 302.99 185.643 302.313 223.757C274.761 206.537 275.766 174.368 275.766 174.368Z"
                        fill="#0B4E51"
                    />
                    <path
                        d="M143.946 221.21C143.946 221.21 139.333 190.229 174.435 170.006C173.784 204.543 143.946 221.21 143.946 221.21Z"
                        fill="#0B4E51"
                    />
                </g>
            </g>
        </g>
        <defs>
            <linearGradient
                id="14366f8e__paint0_linear_24891_5114"
                x1={307.5}
                y1={-25.6714}
                x2={307.5}
                y2={172.466}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFEDE4" />
                <stop offset={1} stopColor="#FFAB9D" />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint1_linear_24891_5114"
                x1={218.31}
                y1={45.2686}
                x2={216.439}
                y2={94.0689}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint2_linear_24891_5114"
                x1={357.469}
                y1={-25.8818}
                x2={359.262}
                y2={78.4119}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint3_linear_24891_5114"
                x1={320.712}
                y1={-40.7387}
                x2={335.416}
                y2={46.1608}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint4_linear_24891_5114"
                x1={200.92}
                y1={-38.7963}
                x2={225.052}
                y2={18.0994}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint5_linear_24891_5114"
                x1={309.55}
                y1={62.7805}
                x2={310.296}
                y2={107.246}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint6_linear_24891_5114"
                x1={265.475}
                y1={120.437}
                x2={266.236}
                y2={136.435}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint7_linear_24891_5114"
                x1={347.988}
                y1={110.7}
                x2={347.988}
                y2={140.425}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint8_linear_24891_5114"
                x1={71.2375}
                y1={134.787}
                x2={71.2375}
                y2={-47.6628}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF806C" />
                <stop offset={1} stopColor="#FFEDE4" />
            </linearGradient>
            <linearGradient
                id="14366f8e__paint9_linear_24891_5114"
                x1={78.233}
                y1={128.765}
                x2={131.979}
                y2={54.5604}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#06003E" />
                <stop offset={0.99} stopColor="#471F98" stopOpacity={0.5} />
            </linearGradient>
            <radialGradient
                id="14366f8e__paint10_radial_24891_5114"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(329.65 238.774) scale(301.832)"
            >
                <stop stopColor="#BECCA5" />
                <stop offset={1} stopColor="#365953" />
            </radialGradient>
            <linearGradient
                id="14366f8e__paint11_linear_24891_5114"
                x1={2632.93}
                y1={711.986}
                x2={2836.7}
                y2={711.986}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#06003E" />
                <stop offset={0.99} stopColor="#471F98" stopOpacity={0.5} />
            </linearGradient>
            <radialGradient
                id="14366f8e__paint12_radial_24891_5114"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(131.221 35.6566) rotate(-25.32) scale(7.7285)"
            >
                <stop stopColor="#BEC0FF" />
                <stop offset={1} stopColor="#8184CA" />
            </radialGradient>
            <radialGradient
                id="14366f8e__paint13_radial_24891_5114"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(131.546 36.3344) rotate(-25.32) scale(7.7285)"
            >
                <stop stopColor="#9FB4FF" />
                <stop offset={1} stopColor="#846895" />
            </radialGradient>
            <linearGradient
                id="14366f8e__paint14_linear_24891_5114"
                x1={127.1}
                y1={13.5808}
                x2={146.575}
                y2={114.8}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <radialGradient
                id="14366f8e__paint15_radial_24891_5114"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(302.073 222.214) scale(230.01)"
            >
                <stop stopColor="#4C9E67" />
                <stop offset={1} stopColor="#418075" />
            </radialGradient>
            <clipPath id="14366f8e__clip0_24891_5114">
                <rect width={328} height={205} fill="white" />
            </clipPath>
            <clipPath id="14366f8e__clip1_24891_5114">
                <rect width={328} height={205} fill="white" />
            </clipPath>
            <clipPath id="14366f8e__clip2_24891_5114">
                <rect width={615} height={205} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default NoTripsS;
