import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TicketCatL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 210 210"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M90.0712 30.621V22.6589L92.0617 19.9053L96.1672 21.547L101.766 26.8721L105.995 26.2749L111.967 24.8816H119.431L122.666 23.8863L130.628 24.8816L138.093 25.2668L140.456 25.8768L144.313 22.6589L147.672 19.9053H149.538L151.28 21.8958L152.151 27.8674V32.8437L153.643 36.3721L155.883 39.8105L157.5 43.7915L159.366 47.7726L161.108 52.1517L162.103 57.7252V63.6967L160.361 69.6683L155.883 75.6399L171.309 126.398V131.374L168.946 134.659L165.338 135.356L163.72 140.332L159.366 146.303L160.361 150.284C160.361 150.284 159.491 152.276 158.495 153.64C157.5 155.004 154.639 158.247 154.639 158.247V163.593V167.574L153.643 176.161V180.142L154.639 182.973L151.28 186.484H146.552L142.82 186.114C142.82 186.114 140.456 185.983 140.456 184.886C140.456 183.789 138.839 182.133 138.839 182.133V171.185V162.228L122.666 163.223L101.766 162.228L99.6506 173.175L97.5357 184.886L94.6743 186.484H86.7122L84.7217 181.137V172.18L90.0712 30.621Z"
            fill="white"
        />
        <path
            d="M60.3377 25.8768L66.1849 23.8862L72.2808 25.2668L75.391 27.1267L76.3863 32.4483L74.1469 36.8246L70.1659 38.8151H64.9408C64.9408 38.8151 60.3377 37.3222 60.3377 37.0734C60.3377 36.8246 57.8495 34.4652 57.8495 34.152C57.8495 33.8388 56.6055 31.3507 56.6055 31.3507L57.2275 27.8673L58.7204 26.872L60.3377 25.8768Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M154.034 180.817C154.097 184.213 153.445 186.446 146.667 186C139.373 184.76 139.168 182.856 139.318 178.835C137.749 178.703 136.128 178.584 134.454 178.48C129.573 178.176 124.279 177.86 118.746 177.86C112.307 177.86 107.284 178.195 100.672 178.339C100.056 178.353 99.4503 178.373 98.8497 178.396C98.995 183.418 100.22 187.307 88.833 186.5C86.114 186.747 84.862 184.426 84.1923 180.153C78.186 181.496 74.5977 183.37 74.5977 185.067C74.5977 187.72 83.3543 190.704 96.468 191.14C104.285 191.399 110.62 192.273 118.746 192.273C125.425 192.273 131.75 191.641 137.433 191.448C153.217 190.909 162.895 187.956 162.895 185.066C162.895 183.441 159.596 181.983 154.034 180.817Z"
            fill="#ABB5BE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.556 35.1111H75.135C73.665 37.4081 70.4757 39.0001 66.776 39.0001C63.0763 39.0001 59.887 37.4081 58.417 35.1111C52.083 35.1111 47.1113 35.1111 47.1113 35.1111C43.0003 35.1111 41.667 37.7778 41.667 41.3334C41.667 44.8891 42.637 52.3414 43.3337 57.1111C44.1653 62.8051 46.0003 63.0001 50.3337 63.0001C54.667 63.0001 82.3337 63.1111 86.1113 63.1111C89.889 63.1111 90.778 59.4444 91.1113 55.7778C91.4447 52.1111 91.3337 45.0001 91.5557 40.3334C91.7777 35.6668 88.2227 35.1111 84.556 35.1111Z"
            fill="#7DC9F0"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M91.556 86.1353C91.3337 81.4687 91.445 74.3577 91.1117 70.691C90.7783 67.0243 89.8893 63.3577 86.1117 63.3577C82.3337 63.3577 54.667 63.4687 50.3337 63.4687C46.0003 63.4687 44.1653 63.6637 43.3337 69.3577C42.637 74.1273 41.667 81.5797 41.667 85.1353C41.667 88.691 43.0003 91.3577 47.1113 91.3577C47.1113 91.3577 80.889 91.3577 84.5557 91.3577C88.2223 91.3577 91.778 90.802 91.556 86.1353Z"
            fill="#F8CA45"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.5557 91.5173C80.889 91.5173 47.1113 91.5173 47.1113 91.5173C43.0003 91.5173 41.667 94.184 41.667 97.7397C41.667 101.295 42.637 108.748 43.3337 113.517C44.1653 119.211 46.0003 119.406 50.3337 119.406C54.667 119.406 82.3337 119.517 86.1113 119.517C89.889 119.517 90.778 115.851 91.1113 112.184C91.4447 108.517 91.3337 101.406 91.5557 96.7397C91.7777 92.073 88.2223 91.5173 84.5557 91.5173Z"
            fill="#6FCC62"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M91.1975 142.802C90.9752 138.135 90.5865 131.024 90.2532 127.358C89.9199 123.691 89.0315 120.024 85.2555 120.024C81.4795 120.024 53.8269 120.135 49.4955 120.135C45.1642 120.135 43.3302 120.33 42.4992 126.024C41.8029 130.794 41.8332 138.246 41.8332 141.802C41.8332 145.358 43.1659 148.024 47.2749 148.024C47.2749 148.024 80.5359 148.024 84.2005 148.024C87.8659 148.024 91.4195 147.469 91.1975 142.802Z"
            fill="#DD89CE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M159.667 84.3332C159.667 84.3332 161 75.3332 156.333 75.9999C156.333 75.9999 145.333 86.3332 123 86.3332C100.667 86.3332 96.3333 82.3332 96.3333 82.3332C96.3333 82.3332 97.6667 87.6666 94.3333 91.3332L91 93.6666C91 93.6666 91.6667 95.6666 91.3333 101C91 106.333 91 109.667 90.6667 113.333C90.3333 117 86 119.667 86 119.667C86 119.667 88.6667 120.667 90 124.333C91.3333 128 91.3333 142.333 91.3333 142.333C91.3333 142.333 91.6333 143.13 90.6667 146.667C108 152.333 156 149.333 164 144.333V129.333C164 129.333 174.667 126.333 176.333 110.667C178 94.9999 159.667 84.3332 159.667 84.3332Z"
            fill="#F0ECD8"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M151.001 88.6664C151.001 88.6664 151.451 82.8671 150.668 79.9998L141.668 83.9998L142.335 90.9998C144.495 119.093 141.668 148.333 141.668 148.333L151.668 147C156.521 110.114 151.001 88.6664 151.001 88.6664ZM131.334 85.6663L120.667 86.3329V94.3329C119.641 131.253 119.334 149.333 119.334 149.333L130.667 148.666C131.907 123.617 131.667 92.9996 131.667 92.9996C131.667 92.9996 131.776 90.1399 131.334 85.6663ZM99.6674 83.9998C99.6674 83.9998 101.211 85.5641 109.334 86.6664C109.001 91.3331 110.001 94.6664 110.001 94.6664C110.001 94.6664 109.507 129.33 110.001 148.333C110.001 148.333 103.334 150 98.3341 148C98.3341 148 97.3341 122 100.001 93.3331L99.6674 83.9998Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M170 94.8333C164.667 88.6667 159.334 84.5 159.334 84.5L159.167 91.5C166.086 104.861 164.5 129.667 164.5 129.667C164.5 129.667 171.834 125.5 174.667 115.833C177.5 106.167 175.334 101 170 94.8333Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M156.666 76.3331C161.333 75.6665 160 89.6665 160 89.6665C147.666 100.666 108.928 101.249 92.7041 93.6878C94.4424 90.1688 96.3331 82.6665 96.3331 82.6665C137.666 93.3331 156.666 76.3331 156.666 76.3331ZM91.6667 136C91.6667 136 116.528 142.913 163 134.666L163.667 144.666C163.667 144.666 147.333 153.666 90 147.333C92.0753 144.627 91.6667 136 91.6667 136Z"
            fill="#D2CDBA"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.3673 148.022C80.7023 148.022 47.4417 148.022 47.4417 148.022C43.3327 148.022 42 150.767 42 154.428C42 158.089 42.636 165.262 43.3327 170.173C44.164 176.035 45.998 176.236 50.329 176.236C54.6603 176.236 81.6463 176.35 85.4223 176.35C89.1983 176.35 90.0867 172.575 90.4197 168.8C90.753 165.025 91.142 158.203 91.364 153.399C91.5857 148.594 88.032 148.022 84.3673 148.022Z"
            fill="#FF815E"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M128.523 23.5319C130.704 27.0319 132.246 36.5659 126.518 36.8332C121.728 37.0567 120.701 32.6777 119.543 27.7355C119.267 26.5596 118.984 25.3518 118.641 24.1665C121.193 22.8445 128.523 23.5319 128.523 23.5319ZM104.715 27.0738C104.809 27.4063 104.902 27.7382 104.994 28.0677C106.205 32.4131 107.296 36.3261 110.905 35.3724C114.935 34.3081 114.729 29.0168 113.091 24.8221C109.48 26.0001 104.715 27.0738 104.715 27.0738ZM134.515 27.531L134.515 27.5311C135.216 30.4151 136.016 33.7065 138.969 33.9548C142.88 34.2838 142.201 28.9214 140.439 25.3968C137.629 25.4314 133.902 25.2734 133.902 25.2734C134.129 25.9428 134.318 26.7208 134.515 27.531L134.515 27.531L134.515 27.531ZM131.975 57.0435C129.116 57.4815 124.18 57.3122 121.554 57.1439L121.33 57.1294C118.793 56.9648 116.508 56.8164 115.563 59.1009C114.935 60.6195 114.783 69.2815 126.562 69.5525C138.842 69.8352 139.075 59.2915 137.544 57.6782C136.259 56.3237 134.412 56.6357 132.656 56.932C132.427 56.9707 132.2 57.0091 131.975 57.0435ZM153.066 56.9153C151.838 51.8496 155.221 49.357 160.27 49.815C162.784 54.4635 162.924 61.4598 162.927 61.6202L162.927 61.623C159.893 61.8886 154.352 62.2186 153.066 56.9153Z"
            fill="#D9E1E6"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M152.446 147.676C153.696 150.032 157.311 151.873 160.02 150.372L160.897 146.104C158.478 146.348 152.446 147.676 152.446 147.676ZM104.666 149.667C104.666 149.667 114.489 149.671 125.666 149.833C137.967 150.012 143.434 149.312 143.434 149.312C139.531 156.258 113.157 159.724 104.666 149.667ZM152.824 154.621C149.47 155.448 147.505 157.704 147.691 159.52C147.878 161.337 151.965 163.516 154.516 162.103L154.04 159.699L157.562 153.902L157.561 153.901C157.511 153.898 156.117 153.811 152.824 154.621ZM147.377 171.621C147.501 176.047 153.173 174.969 153.173 174.969C153.173 174.969 155.052 170.962 154.485 166.956C150.934 167.737 147.295 168.658 147.377 171.621ZM91.0869 163.937L91.2782 156.455C94.6322 157.281 96.0976 159.537 95.9112 161.354C95.7249 163.171 93.6372 165.349 91.0869 163.937ZM90.2684 169.694C90.2684 169.694 91.0884 172.327 87.4297 176.969C87.4297 176.969 93.009 179.358 93.3917 173.621C93.533 171.498 92.199 170.42 90.2684 169.694ZM98.1557 148.676C97.8471 152.619 93.7917 153.706 91.0824 152.206L89.7051 147.104C92.1247 147.348 98.1557 148.676 98.1557 148.676Z"
            fill="#D9E1E6"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M92.778 63.3333C92.778 63.3333 95.1113 67.111 95.4447 70.889C95.778 74.6667 96.2227 88 96.2227 88C96.2227 88 96.3787 93.1907 91.1117 93.889L88.2227 91C88.2227 91 91.4447 91 91.6667 86.889C91.889 82.7777 91 73.3333 90.5557 69.5557C90.1113 65.7777 88.5557 64.2223 87.1113 63.3333C87.1113 63.3333 89.5557 63.111 90.1113 58.5557C90.667 54 91.667 39.5557 91.667 39.5557C91.667 39.5557 91.0003 36.111 87.3337 35.6667C83.667 35.2223 75.667 35 75.667 35L76.778 30.4443C76.778 30.4443 84.556 30.5557 88.667 31C92.778 31.4443 95.5557 33.2223 96.1113 37C96.667 40.7777 95.0003 57 95.0003 57C95.0003 57 93.889 61 92.778 63.3333ZM44.251 31.006C44.2783 31.004 44.3058 31.002 44.3334 30.9999C47.3334 30.7776 56.5557 30.8889 56.5557 30.8889L57.8891 35.4443C57.8891 35.4443 50.6667 35.3333 47.0001 35.3333C43.3334 35.3333 41.7777 37.2223 41.5554 40.7776C41.3334 44.3333 42.2221 54.4443 43.1111 58.1109C44.0001 61.7776 46.4444 62.7776 46.4444 62.7776C46.4444 62.7776 43.6667 65.6666 43.3334 68.7776C43.0001 71.8889 41.6667 85.2223 41.6667 85.2223C41.6667 85.2223 43.2224 90.5556 45.5557 91.3333L42.1111 93.7776C39.3331 92.8889 36.9997 90.9999 36.8887 86.4443C36.7777 81.8889 37.3334 72.4443 38.7777 67.7776C40.2224 63.1109 40.6667 62.9999 40.6667 62.9999C40.6667 62.9999 38.3334 58.1109 37.8891 52.4443C37.8235 51.6086 37.7435 50.7005 37.6597 49.7491C37.175 44.2488 36.5628 37.3025 37.8891 34.5556C39.4301 31.3629 41.2987 31.2246 44.251 31.006Z"
            fill="#ABB5BE"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M74.4929 33.2295C73.7555 32.6349 72.6025 32.8412 71.9172 33.6909C71.2319 34.5402 71.2742 35.7112 72.0115 36.3059C72.7485 36.9005 73.9019 36.6939 74.5872 35.8445C75.2722 34.9949 75.2299 33.8245 74.4929 33.2295ZM67.3401 35.4274C66.1475 35.4614 65.1961 36.256 65.2151 37.2034C65.2345 38.1507 66.2165 38.891 67.4091 38.8574C68.6018 38.8237 69.5531 38.0287 69.5341 37.0814C69.5151 36.1344 68.5331 35.394 67.3401 35.4274ZM59.1291 33.928C59.6281 33.1643 60.8164 33.049 61.7831 33.6697C62.7497 34.2903 63.1287 35.413 62.6297 36.1767C62.1307 36.9403 60.9424 37.056 59.9757 36.435C59.0091 35.814 58.6301 34.6917 59.1291 33.928Z"
            fill="#F0ABA7"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M75.2932 47.0559C72.9788 47.0772 70.9308 47.1082 69.8408 47.1512C69.1972 47.1762 68.6548 46.6746 68.6298 46.0309C68.6042 45.3869 69.1058 44.8446 69.7498 44.8192C70.8988 44.7749 72.9455 44.7442 75.2718 44.7229C77.5958 44.7016 80.1912 44.6889 82.4049 44.6819C83.0492 44.6799 83.5728 45.2006 83.5752 45.8449C83.5772 46.4892 83.0565 47.0129 82.4118 47.0152C80.2018 47.0219 77.6098 47.0349 75.2932 47.0559ZM82.7381 50.6819C83.3825 50.6799 83.9065 51.2006 83.9085 51.8449C83.9105 52.4892 83.3898 53.0129 82.7451 53.0152C80.5351 53.0219 77.9431 53.0349 75.6268 53.0559C73.3121 53.0772 71.2641 53.1082 70.1741 53.1509V53.1512C69.5305 53.1766 68.9878 52.6749 68.9628 52.0309C68.9375 51.3869 69.4391 50.8446 70.0831 50.8192C71.2325 50.7749 73.2788 50.7442 75.6051 50.7229C77.9291 50.7016 80.5248 50.6889 82.7381 50.6819ZM49.1735 72.4845C50.2635 72.4415 52.3115 72.4105 54.6262 72.3891C56.9425 72.3681 59.5345 72.3551 61.7445 72.3485C62.3892 72.3465 62.9095 71.8225 62.9075 71.1781C62.9055 70.5338 62.3815 70.0131 61.7372 70.0151C59.5235 70.0221 56.9282 70.0348 54.6042 70.0561C52.2779 70.0775 50.2315 70.1081 49.0822 70.1525C48.4382 70.1778 47.9365 70.7201 47.9619 71.3641C47.9872 72.0081 48.5295 72.5095 49.1735 72.4845ZM54.6262 78.3891C52.3115 78.4105 50.2635 78.4415 49.1735 78.4845C48.5295 78.5095 47.9872 78.0081 47.9619 77.3641C47.9365 76.7201 48.4382 76.1778 49.0822 76.1525C50.2315 76.1081 52.2779 76.0775 54.6042 76.0561C56.9282 76.0348 59.5235 76.0221 61.7372 76.0151C62.3815 76.0131 62.9055 76.5338 62.9075 77.1781C62.9095 77.8225 62.3892 78.3465 61.7445 78.3485C59.5345 78.3551 56.9425 78.3681 54.6262 78.3891ZM48.8405 85.1511C49.9588 85.1071 50.7478 85.0795 51.8128 85.0608C52.8775 85.0418 54.2212 85.0318 56.4308 85.0251C57.0755 85.0231 57.5958 84.4991 57.5938 83.8548C57.5918 83.2101 57.0678 82.6898 56.4235 82.6918C54.2095 82.6988 52.8568 82.7088 51.7712 82.7278C50.6855 82.7468 49.8702 82.7758 48.7492 82.8191C48.1052 82.8445 47.6035 83.3868 47.6288 84.0308C47.6542 84.6745 48.1965 85.1761 48.8405 85.1511ZM75.6054 98.3885C77.9298 98.3675 80.5248 98.3555 82.7381 98.3485C83.3824 98.3465 83.9064 98.8671 83.9084 99.5115C83.9104 100.156 83.3901 100.68 82.7454 100.682C80.5354 100.688 77.9434 100.7 75.6264 100.721C73.3121 100.742 71.2641 100.772 70.1731 100.814C69.5291 100.838 68.9874 100.336 68.9628 99.6925C68.9381 99.0488 69.4401 98.5068 70.0841 98.4825C71.2324 98.4388 73.2791 98.4095 75.6054 98.3885ZM83.9084 105.354C83.9068 104.71 83.3824 104.189 82.7381 104.191C80.5248 104.198 77.9298 104.21 75.6054 104.231C73.2791 104.252 71.2324 104.282 70.0841 104.325C69.4401 104.35 68.9381 104.892 68.9628 105.536C68.9874 106.179 69.5291 106.682 70.1731 106.657C71.2641 106.615 73.3121 106.585 75.6264 106.564C77.9434 106.543 80.5351 106.531 82.7454 106.525C83.3894 106.522 83.9104 105.998 83.9084 105.354ZM70.2504 110.331C71.3718 110.288 72.1864 110.26 73.2721 110.241C74.3574 110.223 75.7101 110.213 77.9238 110.206C78.5681 110.204 79.0921 110.725 79.0941 111.369C79.0961 112.014 78.5751 112.538 77.9308 112.54C75.7211 112.546 74.3774 112.556 73.3118 112.574C72.2471 112.593 71.4571 112.62 70.3388 112.662C69.6951 112.687 69.1534 112.185 69.1288 111.541C69.1044 110.897 69.6068 110.355 70.2504 110.331ZM50.6739 132.318C51.7639 132.275 53.8119 132.244 56.1262 132.223C58.4429 132.201 61.0349 132.189 63.2449 132.182C63.8896 132.18 64.4102 131.656 64.4082 131.012C64.4062 130.367 63.8822 129.847 63.2379 129.849C61.0242 129.856 58.4289 129.868 56.1049 129.889C53.7786 129.911 51.7319 129.941 50.5829 129.986C49.9389 130.011 49.4372 130.554 49.4629 131.198C49.4879 131.841 50.0302 132.343 50.6739 132.318ZM56.4379 135.889C58.7619 135.868 61.3575 135.856 63.5709 135.849C64.2152 135.847 64.7392 136.367 64.7412 137.012C64.7432 137.656 64.2229 138.18 63.5782 138.182C61.3682 138.189 58.7762 138.201 56.4599 138.223C54.1452 138.244 52.0975 138.275 51.0072 138.318C50.3632 138.343 49.8209 137.842 49.7959 137.198C49.7702 136.554 50.2719 136.011 50.9159 135.986C52.0652 135.941 54.1115 135.911 56.4379 135.889ZM80.9051 158.182C78.6914 158.189 76.0961 158.202 73.7721 158.223C71.4457 158.244 69.3991 158.275 68.2501 158.32C67.6061 158.345 67.1044 158.887 67.1297 159.531C67.1551 160.175 67.6971 160.676 68.3411 160.651C69.4314 160.608 71.4791 160.577 73.7934 160.556C76.1101 160.535 78.7021 160.522 80.9124 160.515C81.5571 160.513 82.0774 159.989 82.0754 159.345C82.0734 158.701 81.5494 158.18 80.9051 158.182ZM68.5828 164.32C70.0915 164.261 73.1628 164.226 76.3612 164.205C77.0058 164.201 77.5315 164.72 77.5358 165.364C77.5398 166.008 77.0208 166.534 76.3768 166.538C73.1912 166.559 70.1098 166.595 68.6742 166.651C68.0302 166.677 67.4878 166.175 67.4628 165.531C67.4375 164.887 67.9392 164.345 68.5828 164.32Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M164.748 86.9675L164.748 86.9676C169.331 91.3236 174.11 95.8666 176.139 101.79C177.613 106.094 177.554 110.618 176.219 114.962C175.176 118.355 173.897 122.082 171.759 125.073C173.4 127.148 172.911 130.386 171.841 132.67C170.631 135.251 167.904 137.011 165.126 136.664C165.068 137.837 165.002 139.009 164.918 140.181C164.899 140.454 164.888 140.746 164.877 141.048C164.832 142.299 164.78 143.722 164.069 144.681C163.539 145.395 162.736 145.924 161.831 146.337C161.976 149.587 160.321 153.19 158.657 155.782C157.787 157.137 156.733 158.724 155.426 159.774C156.2 161.597 156.29 163.79 156.369 165.706L156.375 165.839C156.485 168.505 156.109 171.02 155.564 173.624C155.39 174.454 155.212 175.283 155.011 176.106C154.937 176.407 154.838 176.724 154.737 177.047C154.512 177.762 154.278 178.51 154.288 179.196C154.299 179.897 154.516 180.551 154.733 181.205C154.929 181.797 155.126 182.39 155.17 183.017C155.35 185.554 152.797 186.936 150.642 187.319C146.371 188.08 139.612 187.27 138.357 182.299C137.814 180.149 137.952 177.964 138.089 175.779C138.148 174.843 138.207 173.907 138.212 172.973C138.23 169.991 138.152 166.912 137.297 164.033C137.244 163.857 137.236 163.698 137.261 163.557C136.673 163.626 136.087 163.688 135.511 163.75L135.51 163.75L135.508 163.75L135.506 163.75C135.014 163.802 134.529 163.854 134.056 163.908C130.665 164.3 127.257 164.551 123.844 164.634C120.108 164.726 116.367 164.665 112.64 164.365L112.597 164.362C109.43 164.108 106.162 163.845 103.031 163.178C102.799 166.719 102.459 170.331 101.524 173.739C101.388 174.236 101.247 174.727 101.107 175.215L101.105 175.219L101.105 175.22L101.105 175.221C100.451 177.499 99.8177 179.704 99.7713 182.129C99.7353 184.009 99.1247 185.992 97.4387 187.045C95.9589 187.969 94.033 188.012 92.3152 188.049H92.315L92.054 188.055C90.2903 188.097 88.3567 188.136 86.658 187.579C84.9793 187.029 84.014 185.487 83.887 183.738C83.8175 182.78 83.8533 181.835 83.8895 180.88L83.8986 180.638L83.906 180.433C83.9368 179.564 83.6907 178.768 83.4427 177.965L83.4426 177.965C83.36 177.698 83.2772 177.43 83.2043 177.158C83.1305 177.16 83.0566 177.161 82.9828 177.163C82.9094 177.164 82.836 177.166 82.7627 177.167C82.6868 177.168 82.6075 177.177 82.5278 177.186L82.5274 177.186C82.4124 177.199 82.2964 177.212 82.1883 177.202C82.103 177.193 81.299 177.087 81.7907 177.083C79.5663 177.101 77.3417 177.106 75.1173 177.107C69.5637 177.108 64.01 177.088 58.4567 177.041C57.5339 177.033 56.5954 177.048 55.6508 177.064H55.6504C53.6044 177.098 51.53 177.133 49.526 176.93C49.354 177.024 49.1423 177.07 48.89 177.038L48.6808 177.011C47.1473 176.815 45.753 176.637 44.545 175.542C43.475 174.573 42.9467 173.234 42.6133 171.863C41.8449 168.704 41.5726 165.413 41.3048 162.176L41.27 161.757C41.1907 160.801 41.1173 159.844 41.0439 158.888L41.0439 158.887L41.0439 158.887L41.0439 158.887L41.0439 158.887L41.0438 158.887L41.0438 158.887L41.0438 158.887L41.0438 158.886L41.0438 158.886L41.0438 158.886L41.0438 158.886L41.0438 158.886L41.0437 158.885C40.9874 158.15 40.931 157.416 40.872 156.682C40.8424 156.316 40.793 155.936 40.7429 155.551C40.6348 154.719 40.5237 153.865 40.6023 153.072C40.8107 150.974 41.8227 149.152 43.3823 148.056C43.0573 147.848 42.746 147.602 42.454 147.303C40.4785 145.284 40.601 142.949 40.7338 140.418C40.7457 140.19 40.7578 139.961 40.7683 139.73C40.8229 138.538 40.8636 137.345 40.9043 136.152C40.9711 134.192 41.038 132.232 41.1667 130.274C41.1927 129.878 41.2138 129.466 41.2354 129.043C41.3495 126.81 41.4782 124.291 42.432 122.36C43.108 120.993 44.0883 120.122 45.281 119.597C45.0287 119.445 44.7827 119.265 44.5443 119.049C43.4743 118.079 42.946 116.74 42.6127 115.369C41.8434 112.207 41.5711 108.912 41.3032 105.672L41.2693 105.263C41.1901 104.308 41.1168 103.353 41.0435 102.398L41.0435 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.397L41.0434 102.396L41.0434 102.396L41.0434 102.396L41.0434 102.396L41.0434 102.396L41.0434 102.396C40.9869 101.66 40.9305 100.925 40.8713 100.189C40.8417 99.8225 40.7923 99.4422 40.7422 99.0571C40.6341 98.2256 40.5231 97.3711 40.6017 96.579C40.6847 95.7443 40.896 94.9543 41.2163 94.235C35.4491 92.5319 35.9554 85.7028 36.3472 80.4172C36.377 80.016 36.4061 79.6238 36.4317 79.2433L36.4554 78.8903C36.8213 73.4472 37.1994 67.8218 39.868 63.007C37.903 59.6343 37.3603 55.9337 36.939 52.0287C36.4653 47.6403 36.061 43.14 36.1037 38.7207C36.142 34.709 37.8007 30.8917 42.2383 30.3237C46.0038 29.8416 49.8624 29.8016 53.6783 29.7622H53.6783H53.6784H53.6785H53.6786H53.6787H53.6788H53.6789H53.679H53.679H53.6791H53.6792H53.6793H53.6794C54.4275 29.7544 55.1739 29.7467 55.9177 29.7357C55.946 29.5123 55.9833 29.2887 56.039 29.0647C56.692 26.4373 59.026 24.893 61.4583 24.0757C66.15 22.4993 77.1653 22.3103 77.4473 29.434L77.4762 29.4304C77.5198 29.4249 77.5634 29.4194 77.6103 29.42C80.8293 29.458 84.052 29.5053 87.267 29.6833C87.6094 29.7021 87.9632 29.7155 88.3228 29.7291L88.323 29.7291L88.3231 29.7291L88.3231 29.7291C88.5054 29.736 88.6892 29.7429 88.8737 29.7507C88.8617 29.685 88.851 29.618 88.8497 29.546L88.8465 29.3841C88.7878 26.4127 88.6098 17.4069 93.5703 19.2377C95.749 20.0417 97.7987 21.4097 99.5723 22.8903C100.736 23.8623 102.041 24.9747 102.834 26.3313C108.575 24.1127 114.676 22.8907 120.819 22.7697C127.348 22.6403 133.728 23.5743 140.104 24.8613C141.587 22.8507 143.535 21.0993 145.679 19.8393C146.972 19.0793 149.049 17.9613 150.481 19.0337C151.882 20.0828 152.345 22.7356 152.636 24.3981L152.672 24.6057C153.16 27.3757 153.317 30.2523 152.705 33.0117C155.916 38.0013 158.923 43.189 160.972 48.7717C161.28 49.6093 161.57 50.463 161.839 51.3263C163.302 51.19 164.776 51.1433 166.182 51.106C167.32 51.0757 167.323 52.8687 166.26 53.0597C165.029 53.2803 163.767 53.4867 162.499 53.6593C162.763 54.706 162.984 55.7633 163.15 56.827C164.059 56.868 164.958 56.94 165.823 57.025C167.037 57.1443 166.82 58.8593 165.648 58.8727C164.963 58.8801 164.265 58.9104 163.561 58.9409L163.404 58.9477C163.613 61.545 163.443 64.1537 162.695 66.6917C161.786 69.7743 160.268 72.527 158.318 74.928C159.465 75.4343 160.267 76.637 160.477 77.9693C160.683 79.2843 160.659 80.6377 160.491 81.9567C160.457 82.2227 160.431 82.502 160.406 82.7853C160.506 82.8397 160.604 82.907 160.695 83.0017C161.972 84.3288 163.351 85.6394 164.748 86.9675ZM126.848 34.4277C126.861 35.3907 125.388 35.3737 125.211 34.4934C124.93 33.1041 124.761 31.6925 124.593 30.2834L124.593 30.2808C124.544 29.8736 124.495 29.4666 124.444 29.0604C124.306 27.9634 125.882 27.6871 126.13 28.7627C126.561 30.6251 126.823 32.5164 126.848 34.4277ZM132.971 34.6149C133.265 35.5342 134.823 35.0279 134.587 34.0986C134.115 32.2402 133.623 30.3909 132.769 28.6646C132.263 27.6432 130.681 28.3889 131.168 29.4242C131.769 30.6995 132.181 32.0487 132.592 33.3956L132.592 33.3957L132.592 33.3957C132.717 33.803 132.841 34.2101 132.971 34.6149ZM141.575 48.4586C141.589 48.6404 141.594 48.4664 141.598 48.3069V48.3068C141.601 48.2234 141.603 48.1439 141.606 48.1216C141.655 47.78 141.76 47.4546 141.874 47.1296C142.19 46.23 142.781 45.5416 143.742 45.3653C145.419 45.0578 145.973 47.2252 146.319 48.5765C146.356 48.7238 146.392 48.8613 146.425 48.985C146.675 49.896 148.171 49.992 148.198 48.914C148.261 46.3623 146.66 43.1046 143.712 43.32C141.076 43.5126 139.571 46.101 139.428 48.544C139.337 50.108 141.693 50.046 141.575 48.4586ZM105.904 49.5418C105.917 49.7239 105.922 49.5498 105.927 49.3904V49.3903C105.929 49.3069 105.931 49.2275 105.935 49.2051C105.983 48.8635 106.089 48.5381 106.203 48.2131C106.518 47.3135 107.109 46.6251 108.071 46.4488C109.748 46.1413 110.301 48.3087 110.647 49.6601C110.685 49.8073 110.72 49.9449 110.754 50.0685C111.003 50.9795 112.5 51.0755 112.526 49.9975C112.589 47.4458 110.988 44.1881 108.04 44.4035C105.405 44.5958 103.899 47.1845 103.757 49.6275C103.665 51.1915 106.021 51.1295 105.904 49.5418ZM127.068 63.4097C124.902 66.5324 118.58 66.3861 117.594 62.0037C117.378 61.0394 118.901 60.5391 119.26 61.4717C119.884 63.0921 121.261 63.9267 123.005 63.5234C124.68 63.1367 125.416 62.0961 125.997 60.5711C126.064 60.3941 126.162 60.2631 126.275 60.1667C126.28 60.1355 126.285 60.1046 126.289 60.0736C126.298 60.0136 126.306 59.9535 126.32 59.8917C126.554 58.8084 128.162 58.8931 128.077 60.0581C127.956 61.7274 129.035 63.1494 130.749 63.3684C132.635 63.6094 133.521 62.6134 134.45 61.1291C134.924 60.3717 136.335 60.8274 136.14 61.7511C135.189 66.2367 129.301 66.2447 127.068 63.4097ZM117.376 34.9385C117.362 36.0205 118.977 36.2032 119.068 35.0985C119.241 33.0082 119.025 30.9408 118.797 28.8628C118.673 27.7242 116.94 28.0432 117.053 29.1705C117.246 31.0902 117.402 33.0075 117.376 34.9385ZM91.6019 22.6441C91.6293 22.5266 91.7125 22.2978 91.8029 22.0495C91.9728 21.5828 92.1678 21.0469 92.0643 21.0497C92.5991 21.0357 93.1658 21.3068 93.6614 21.5439C93.7437 21.5833 93.824 21.6217 93.9019 21.6577C96.9433 23.0637 100.013 25.4444 101.869 28.2444C102.157 28.6791 102.761 28.6101 103.119 28.3027C104.674 27.9953 106.199 27.4854 107.721 26.9766L107.721 26.9766C108.775 26.6242 109.827 26.2723 110.887 25.9887C114.269 25.0834 117.743 24.8191 121.233 24.7384C127.501 24.5934 133.71 25.4504 139.854 26.6067C140.283 27.1031 141.116 27.2711 141.596 26.5704C142.725 24.9191 144.179 23.5551 145.772 22.3564C146.335 21.9317 148.796 20.2261 149.28 20.8437C150.078 21.8616 150.356 23.5152 150.582 24.8553L150.582 24.8568L150.582 24.8596L150.583 24.8645L150.584 24.8673L150.584 24.8723C150.618 25.0696 150.65 25.26 150.682 25.4404C151.08 27.6541 151.106 29.8637 150.924 32.0874C150.697 32.3134 150.588 32.6411 150.78 32.9591L150.844 33.0664C150.852 33.3837 151.03 33.6344 151.275 33.7867C154.04 38.4014 156.668 43.1077 158.685 48.1034C159.14 49.2301 159.561 50.3891 159.934 51.5691C159.034 51.7151 158.15 51.9054 157.306 52.1731C156.367 52.4714 156.179 54.1301 157.383 54.1007C158.441 54.0751 159.514 53.9984 160.589 53.8884C160.828 54.8487 161.028 55.8184 161.176 56.7937C160.205 56.8101 159.244 56.8777 158.323 57.0231C157.265 57.1904 157.404 58.6827 158.396 58.8351C159.38 58.9864 160.397 59.0191 161.42 59.0077C161.567 61.1881 161.429 63.3747 160.891 65.5137C158.039 76.8531 146.676 82.2781 136.115 84.1984C135.942 84.2297 135.805 84.2944 135.693 84.3781C130.319 85.1881 124.976 85.7941 119.503 85.7364C115.732 85.6967 111.967 85.3511 108.247 84.7311C104.442 84.0964 100.876 82.8854 97.2643 81.5811C97.1859 80.7367 97.1096 79.9024 97.0699 79.0941C97.0509 78.7077 97.0328 78.3217 97.0147 77.9361V77.9361C96.7763 72.8623 96.5418 67.8691 94.3339 63.2074C96.8081 58.0399 97.0048 52.1049 97.1965 46.3241C97.2558 44.5355 97.3146 42.7616 97.4403 41.0297C97.6039 38.7727 97.7013 36.7501 96.8169 34.6057C96.0736 32.8021 94.3276 30.9351 92.4623 30.2817C92.0043 30.1214 91.5183 30.0151 91.0203 29.9374C91.0283 29.8781 91.0359 29.8187 91.0343 29.7521C90.9783 27.3901 91.0643 24.9541 91.6019 22.6441ZM78.418 31.611H78.4179H78.4178H78.4177H78.4176H78.4175H78.4174H78.4173C78.1029 31.607 77.7886 31.603 77.4745 31.5989C77.4115 32.4939 77.2282 33.3412 76.9365 34.1302L77.1588 34.1302C79.4527 34.1305 81.7463 34.1308 84.0395 34.1505C87.0235 34.1762 90.1762 34.2142 91.9129 37.0999C93.0537 38.9963 92.8948 41.0971 92.7358 43.199C92.6961 43.7251 92.6563 44.2512 92.6369 44.7742C92.6109 45.4743 92.5876 46.1748 92.5643 46.8753V46.8754V46.8755V46.8755C92.4791 49.4404 92.3938 52.007 92.1765 54.5639C92.1522 54.8494 92.1305 55.1503 92.108 55.462C91.9467 57.6959 91.7456 60.4818 90.2769 62.1202C89.8959 62.5455 89.4709 62.8845 89.0185 63.1665C90.4419 64.1222 91.2959 65.6689 91.6619 67.5699C92.2302 70.521 92.3527 73.5577 92.4737 76.5559V76.556L92.4872 76.8885C92.5177 77.6417 92.5409 78.3957 92.5641 79.1498V79.1499C92.6227 81.0556 92.6813 82.9622 92.8585 84.8592C93.0982 87.4252 92.0462 90.0515 89.8739 91.3422C90.2832 91.5749 90.6725 91.8639 91.0325 92.2319C91.1525 92.3549 91.2625 92.4795 91.3679 92.6049C92.1789 92.3889 92.8562 91.9592 93.4709 91.3452C95.8218 88.9977 95.552 85.9841 95.2839 82.9895C95.2372 82.468 95.1906 81.947 95.1579 81.4302C94.9352 77.9165 94.6952 74.3779 94.2265 70.8812C93.8765 68.2705 93.2585 66.0819 92.0815 63.7469C91.7354 63.0604 92.2298 62.2249 92.6356 61.539C92.7397 61.363 92.8381 61.1968 92.9149 61.0455C93.4022 60.0855 93.6415 58.9795 93.8289 57.9272C94.8212 52.3445 95.0677 46.5003 95.308 40.8055L95.308 40.8037C95.3322 40.2303 95.3564 39.6585 95.3812 39.0885C95.5285 35.6972 93.6862 32.4769 90.1555 32.1122C86.2645 31.7105 82.3298 31.6606 78.418 31.611ZM84.894 90.0025C80.5911 90.0554 76.2875 90.0482 71.9842 90.0411H71.9841H71.984H71.9839H71.9837H71.9836H71.9835H71.9834C71.1845 90.0398 70.3856 90.0384 69.5867 90.0375C63.9284 90.031 58.2697 90.0149 52.6114 89.9987L52.0613 89.9972L51.0947 89.9945L51.0836 89.9945C49.6901 89.9905 48.2967 89.9866 46.9033 89.9855C45.2373 89.9838 44.0923 89.1842 43.2993 87.7212C42.6755 86.5712 42.8089 85.3178 42.9409 84.0776C42.9667 83.836 42.9923 83.5949 43.0123 83.3552C43.0974 82.3374 43.1761 81.3192 43.2549 80.3011C43.4686 77.5374 43.6823 74.7745 44.0223 72.0222C44.2267 70.3688 44.455 68.6922 44.9393 67.0938C45.58 64.9788 47.0647 64.5735 48.9863 64.3125C49.564 64.3477 50.1445 64.3575 50.7192 64.3672L50.7197 64.3672L50.9683 64.3715C55.1712 64.4451 59.3762 64.4462 63.58 64.4473H63.5801H63.5801H63.5802H63.5802H63.5803H63.5804H63.5804H63.5805H63.5805L65.0287 64.4478C70.2413 64.4502 75.454 64.4422 80.6663 64.3875C81.0817 64.3832 81.5079 64.3861 81.9406 64.389H81.9407H81.9409H81.941H81.9412H81.9413H81.9415H81.9417H81.9418H81.942C82.9159 64.3955 83.9221 64.4022 84.9087 64.3282C84.9547 64.3322 84.9997 64.3355 85.046 64.3398C86.143 64.4405 87.201 64.5628 88.1113 65.2315C89.1109 65.9659 89.3497 67.4591 89.537 68.6301C89.5507 68.7161 89.5642 68.8004 89.5777 68.8825C90.0589 71.8092 90.1642 74.8085 90.2683 77.7748L90.2686 77.7823C90.279 78.0804 90.2895 78.3782 90.3003 78.6755C90.3135 79.0368 90.3263 79.3981 90.3392 79.7593L90.3392 79.7612L90.3393 79.7631L90.3394 79.765L90.3394 79.7669L90.3395 79.7689L90.3396 79.7712C90.3761 80.8019 90.4127 81.8323 90.458 82.8628C90.4751 83.2511 90.5099 83.644 90.5448 84.0383C90.6187 84.8726 90.6932 85.7133 90.602 86.5302C90.261 89.5732 87.3353 89.9725 84.894 90.0025ZM75.6254 29.7711C73.8001 24.4778 65.4461 24.6218 61.2328 26.5204C59.5238 27.2901 57.9621 28.5694 58.0058 30.6081C58.0434 32.3708 59.0944 34.0334 60.2964 35.2528C62.7758 37.7694 66.3568 38.4511 69.7671 37.6904C73.7871 36.7941 75.9658 33.8578 75.6378 29.7974C75.6361 29.793 75.634 29.789 75.6319 29.785L75.629 29.7794C75.6277 29.7767 75.6265 29.774 75.6254 29.7711ZM57.7547 36.1706C57.9267 36.1693 58.0743 36.1259 58.203 36.0586C61.0633 39.4956 65.4847 40.5249 69.8267 39.7363C72.422 39.2646 74.4763 38.0059 75.8043 36.2213C75.9267 36.2759 76.0697 36.3086 76.2374 36.3086C78.4794 36.3113 80.7213 36.3156 82.9633 36.3303C83.3415 36.3328 83.731 36.3246 84.1257 36.3163C85.3076 36.2916 86.5365 36.2659 87.6487 36.5223C90.8806 37.2681 90.6823 40.3632 90.5146 42.9803L90.5146 42.9808C90.494 43.3016 90.4739 43.6153 90.4607 43.9166C90.4157 44.9389 90.3783 45.9615 90.341 46.9841L90.341 46.9843L90.341 46.9846L90.341 46.9848L90.341 46.9851L90.3409 46.9853L90.3409 46.9856L90.3409 46.9858L90.3409 46.9862V46.9863V46.9864V46.9864V46.9865V46.9866V46.9866C90.2608 49.1811 90.1806 51.3755 90.0247 53.5666C90.0025 53.8791 89.9859 54.224 89.9682 54.5903L89.9682 54.5906C89.853 56.9808 89.6938 60.2852 87.6553 61.4933C86.8567 61.9666 85.8803 62.0756 85.0063 62.1026C84.7399 62.0984 84.473 62.0995 84.2057 62.1005H84.2055H84.2053H84.2051H84.2049H84.2047H84.2045H84.2043C83.9136 62.1017 83.6223 62.1028 83.3303 62.0973L81.3337 62.0696C80.2224 62.0616 79.1107 62.0576 77.999 62.0546C71.964 62.0386 65.9283 62.0619 59.8937 62.1069C58.8254 62.115 57.7386 62.0958 56.6446 62.0764H56.6445H56.6445H56.6444H56.6443H56.6443H56.6442H56.6441C54.802 62.0438 52.9397 62.0109 51.1113 62.1073C51.095 62.1069 51.0787 62.1068 51.0623 62.1066C51.046 62.1064 51.0297 62.1063 51.0133 62.1059C50.1723 62.0903 49.3493 62.0559 48.5137 61.9676C47.0357 61.8109 45.969 61.4363 45.2567 60.0043C44.8741 59.2361 44.71 58.3443 44.5539 57.4962C44.5337 57.3859 44.5135 57.2764 44.493 57.1679C43.7935 53.4655 43.4818 49.702 43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9448L43.1707 45.9447L43.1707 45.9447C43.0663 44.6838 42.962 43.4236 42.843 42.1666C42.55 39.0699 43.7193 36.2706 47.2017 36.2496C49.6294 36.2349 52.0576 36.2155 54.486 36.1962C55.5755 36.1875 56.6651 36.1789 57.7547 36.1706ZM38.3432 86.4298C38.4359 89.3381 39.4676 91.7531 42.5199 92.2965C42.8699 91.9365 43.2642 91.6245 43.6936 91.3615C41.2766 89.8211 40.4492 87.0488 40.7226 84.1651C40.8587 82.7272 40.9679 81.2869 41.0772 79.8466L41.0772 79.8466C41.1884 78.3801 41.2997 76.9135 41.4392 75.4495C41.4661 75.1674 41.4925 74.8841 41.5189 74.5999C41.7685 71.9161 42.0258 69.15 42.8082 66.5768C43.2196 65.2228 43.9282 64.0141 45.0896 63.1681C43.6402 62.1321 42.8492 60.4521 42.4349 58.5135C41.5181 54.2241 41.2544 49.7985 40.9922 45.3993C40.9052 43.9395 40.8184 42.4825 40.7079 41.0345C40.4612 37.8048 43.0912 34.3045 46.4626 34.3191C49.1469 34.3311 51.8312 34.3324 54.5157 34.3336H54.5157H54.5158H54.5158H54.5159H54.5159H54.516C55.3456 34.334 56.1753 34.3344 57.0049 34.3351C56.5109 33.4685 56.1352 32.5365 55.9672 31.5708C55.2473 31.5919 54.5252 31.61 53.8018 31.6282H53.8018C50.2088 31.7185 46.5847 31.8096 43.0319 32.2621C41.2759 32.4858 39.7522 33.1628 39.0462 34.8718C38.3509 36.5538 38.3416 38.3641 38.4042 40.1578C38.5442 44.1418 38.7579 48.1351 39.2186 52.0968L39.2312 52.2054C39.6412 55.7291 40.0501 59.2445 42.0172 62.2655C42.3112 62.7175 42.3716 63.1578 42.0802 63.6341C39.5151 67.8342 39.1335 72.8639 38.7666 77.6987L38.7432 78.0068C38.7128 78.4069 38.6811 78.8084 38.6492 79.2109C38.4596 81.6067 38.267 84.04 38.3432 86.4298ZM45.2158 116.308C44.7537 115.381 44.5749 114.28 44.4069 113.246C44.3814 113.088 44.3561 112.933 44.3301 112.78C43.8073 109.699 43.5658 106.566 43.3257 103.451L43.2845 102.917C43.2414 102.361 43.1669 101.764 43.0899 101.147C42.7981 98.8106 42.4694 96.1788 43.6721 94.3134C44.7927 92.5758 46.6665 92.6183 48.4742 92.6594C48.7621 92.6659 49.0483 92.6724 49.3295 92.6717C51.8935 92.6653 54.4575 92.6567 57.0216 92.6481H57.0222H57.0227H57.0232H57.0236H57.0241H57.0261C65.5103 92.6198 73.995 92.5914 82.4788 92.641C82.9065 92.6435 83.3493 92.6326 83.799 92.6215C85.0883 92.5898 86.4336 92.5566 87.6381 92.8344C90.8525 93.5755 90.6541 96.6541 90.4862 99.2579C90.4654 99.5806 90.4451 99.896 90.4318 100.199C90.3869 101.221 90.3496 102.244 90.3123 103.267C90.2323 105.462 90.1523 107.657 89.9968 109.849C89.9746 110.162 89.9581 110.507 89.9405 110.875C89.8266 113.255 89.6689 116.553 87.6431 117.754C86.6119 118.365 85.2923 118.369 84.2825 118.372C84.1153 118.372 83.9566 118.373 83.8091 118.376C83.4705 118.383 83.1318 118.388 82.7938 118.393C82.707 118.395 82.6201 118.388 82.5332 118.382C82.387 118.371 82.2408 118.36 82.0951 118.386C82.0702 118.39 82.0442 118.394 82.0177 118.399C81.9927 118.403 81.9673 118.407 81.9418 118.411C81.9203 118.415 81.8988 118.418 81.8775 118.421L81.8752 118.422L81.875 118.422C81.553 118.473 81.2885 118.515 81.9878 118.503C80.9361 118.52 79.8838 118.533 78.8318 118.545C73.3918 118.605 67.9515 118.628 62.5115 118.636C59.4798 118.641 56.4485 118.641 53.4168 118.622C53.0159 118.619 52.609 118.626 52.1996 118.632C51.3478 118.646 50.4852 118.66 49.6441 118.594C49.5005 118.479 49.3211 118.394 49.0958 118.365L48.9372 118.344C47.3241 118.137 46.0448 117.972 45.2158 116.308ZM43.1732 136.272C43.136 137.293 43.0987 138.315 43.0539 139.336C43.0406 139.639 43.0203 139.954 42.9995 140.277C42.8319 142.881 42.6338 145.958 45.8479 146.7C47.0529 146.978 48.3988 146.945 49.6886 146.913H49.6887C50.1378 146.902 50.5801 146.892 51.0072 146.894C53.9842 146.911 56.9612 146.918 59.9385 146.92C66.0942 146.896 72.2499 146.873 78.4055 146.88H78.4675C80.3639 146.874 82.2602 146.868 84.1565 146.863C84.436 146.862 84.7205 146.869 85.0066 146.875H85.0075H85.0085H85.0094H85.0104C86.8187 146.917 88.6933 146.96 89.8139 145.221C91.0167 143.356 90.6881 140.723 90.3963 138.387C90.3193 137.77 90.2449 137.174 90.2019 136.618L90.1607 136.084C89.9205 132.969 89.679 129.836 89.1562 126.755C89.142 126.672 89.128 126.587 89.1141 126.503L89.079 126.287C88.9109 125.253 88.732 124.154 88.2702 123.226C87.4414 121.563 86.1632 121.398 84.55 121.19L84.3902 121.17C84.1652 121.14 83.9862 121.056 83.8425 120.941C83.0012 120.874 82.1385 120.888 81.2866 120.902H81.2863H81.2859H81.2856H81.2853C80.8763 120.909 80.4697 120.915 80.0692 120.913C77.0375 120.893 74.0062 120.893 70.9745 120.898C65.5345 120.906 60.0942 120.929 54.6542 120.989C53.6022 121.001 52.5499 121.014 51.4982 121.031C52.1978 121.02 51.9328 121.062 51.6106 121.113L51.6104 121.113C51.5365 121.124 51.4597 121.136 51.3909 121.148C51.2454 121.174 51.0995 121.163 50.9536 121.153C50.8664 121.146 50.7792 121.14 50.6922 121.141C50.3539 121.146 50.0155 121.152 49.6769 121.159C49.5287 121.162 49.3692 121.162 49.2012 121.163C48.1917 121.166 46.8733 121.17 45.8429 121.78C43.8166 122.982 43.659 126.281 43.5453 128.661C43.5278 129.028 43.5113 129.373 43.4892 129.686C43.3333 131.879 43.2533 134.075 43.1732 136.272ZM83.8095 174.869C83.4759 174.876 83.1424 174.882 82.8095 174.887L82.7941 174.887C82.7065 174.889 82.6186 174.882 82.5308 174.876C82.3855 174.865 82.2402 174.854 82.0955 174.879C82.0243 174.892 81.9446 174.905 81.8685 174.917C81.5496 174.967 81.2938 175.008 81.9881 174.997C80.9365 175.014 79.8841 175.027 78.8321 175.039C73.3921 175.099 67.9518 175.122 62.5118 175.13C59.4801 175.135 56.4488 175.135 53.4171 175.116C53.0169 175.113 52.6106 175.12 52.2017 175.126H52.2005H52.1992H52.1979C51.3466 175.14 50.4846 175.154 49.6441 175.087C49.5005 174.972 49.3211 174.887 49.0961 174.858L48.9383 174.838C47.3245 174.631 46.0446 174.466 45.2158 172.802C44.7542 171.876 44.5756 170.776 44.4076 169.743C44.3819 169.584 44.3564 169.428 44.3301 169.273C43.8073 166.192 43.5658 163.059 43.3257 159.944L43.2845 159.41C43.2414 158.854 43.1669 158.257 43.0899 157.64C42.7981 155.304 42.4695 152.672 43.6721 150.807C44.7929 149.069 46.6671 149.112 48.4753 149.153C48.7628 149.159 49.0486 149.166 49.3295 149.165C51.2061 149.16 53.0828 149.154 54.9595 149.147L55.0321 149.148L55.0808 149.148C61.2138 149.155 67.3465 149.132 73.4791 149.109C76.4791 149.11 79.4791 149.117 82.4788 149.135C82.9048 149.137 83.3459 149.126 83.7938 149.115C85.0847 149.083 86.432 149.05 87.6381 149.328C90.8525 150.07 90.6541 153.147 90.4862 155.751L90.4862 155.751L90.4862 155.751L90.4862 155.751C90.4654 156.074 90.4451 156.389 90.4318 156.691C90.3869 157.713 90.3497 158.735 90.3125 159.756L90.3124 159.757L90.3124 159.759L90.3123 159.76C90.2323 161.955 90.1523 164.15 89.9968 166.342C89.9746 166.655 89.9581 167 89.9405 167.367L89.9405 167.368L89.9405 167.368L89.9405 167.368C89.8266 169.748 89.6689 173.047 87.6431 174.247C86.6112 174.859 85.2909 174.863 84.2809 174.866H84.2807H84.2792C84.1134 174.866 83.9559 174.866 83.8095 174.869ZM156.613 154.802C157.539 153.367 158.337 151.84 158.859 150.207C159.181 149.202 159.355 148.181 159.53 147.159L159.53 147.159L159.533 147.141C159.049 147.275 158.573 147.394 158.127 147.506L158.123 147.507L158.123 147.507C157.912 147.56 157.709 147.611 157.514 147.661C154.281 148.491 150.974 149.023 147.661 149.421C138.755 150.49 129.742 150.78 120.778 150.672C115.647 150.611 110.513 150.43 105.395 150.051C100.452 149.686 95.5655 149.261 90.8355 147.687C90.7472 147.658 90.6739 147.619 90.6065 147.576C90.4455 147.716 90.2782 147.85 90.1029 147.973C90.4282 148.181 90.7395 148.427 91.0315 148.726C93.007 150.745 92.8845 153.08 92.7517 155.611L92.7517 155.612L92.7517 155.612C92.7398 155.839 92.7278 156.068 92.7172 156.299C92.6624 157.493 92.6216 158.688 92.5808 159.883C92.5139 161.841 92.4471 163.799 92.3185 165.754C92.2925 166.151 92.2714 166.563 92.2498 166.986L92.2498 166.986C92.1357 169.22 92.007 171.739 91.0535 173.669C89.8792 176.045 87.7895 176.925 85.2575 177.091C85.2478 177.092 85.2381 177.092 85.2285 177.092L85.2139 177.093C85.7749 178.589 86.0175 179.941 85.9835 181.697C85.9472 183.566 85.9892 185.384 88.1342 185.679C90.6125 186.02 97.0285 186.794 97.4792 183.202C97.5655 182.514 97.6045 181.842 97.6432 181.176C97.7145 179.948 97.7847 178.741 98.1475 177.491C98.3105 176.929 98.4838 176.366 98.6576 175.801L98.6577 175.801L98.6578 175.8C99.1408 174.231 99.6279 172.649 99.9085 171.045C100.445 167.978 100.718 164.816 100.906 161.709C100.97 160.643 102.219 160.492 102.809 161.08C104.045 161.214 105.277 161.377 106.508 161.541C108.612 161.819 110.715 162.098 112.841 162.234C116.369 162.459 119.91 162.555 123.445 162.458C126.861 162.364 130.276 162.132 133.669 161.712C135.289 161.512 136.907 161.286 138.516 161.006C138.981 160.924 139.452 160.821 139.924 160.717L139.925 160.717L139.925 160.717L139.925 160.716C140.796 160.525 141.674 160.331 142.539 160.275C143.654 160.202 144.415 161.845 143.188 162.306C141.973 162.762 140.645 163.06 139.29 163.279C139.368 163.384 139.434 163.504 139.477 163.648C140.53 167.194 140.391 170.798 140.252 174.412V174.412C140.194 175.939 140.135 177.468 140.166 178.994C140.217 181.507 140.684 183.63 143.246 184.473C145.374 185.174 147.65 185.603 149.88 185.206C150.891 185.025 153.237 184.552 152.966 183.06C152.884 182.607 152.731 182.168 152.579 181.73C152.396 181.204 152.213 180.679 152.152 180.129C151.952 178.33 152.492 176.434 153.018 174.589C153.272 173.696 153.523 172.815 153.685 171.963C154.417 168.114 154.795 163.538 153.386 159.776C153.28 159.616 153.228 159.43 153.254 159.233C153.263 158.868 153.499 158.536 153.8 158.372C153.891 158.267 153.981 158.161 154.071 158.056C154.968 157.01 155.859 155.97 156.613 154.802ZM169.889 131.509C169.034 133.645 167.258 134.518 165.224 134.521L165.236 134.242L165.24 134.132C165.246 133.992 165.252 133.853 165.258 133.714C165.304 132.639 165.349 131.563 165.392 130.486C167.238 129.843 169.176 128.663 170.23 127.034C170.9 128.347 170.395 130.247 169.889 131.509ZM171.559 120.443C172.577 118.252 173.453 115.94 174.076 113.604C175.16 109.537 175.139 105.247 173.378 101.367C171.341 96.8778 167.913 93.4892 164.478 90.094C162.963 88.5968 161.447 87.0984 160.049 85.5037C159.962 85.8524 159.853 86.188 159.705 86.4984C159.303 87.338 158.207 87.2284 157.958 86.3407C157.68 85.3456 157.869 84.0062 158.063 82.6326C158.4 80.2374 158.753 77.7384 156.667 76.78C156.059 77.398 155.418 77.984 154.753 78.5447C154.979 79.6953 154.906 81.0011 154.839 82.2119C154.82 82.5452 154.802 82.8713 154.79 83.185C154.73 84.8337 154.642 86.474 154.491 88.117C154.395 89.1624 152.856 88.997 152.883 87.9647C152.909 86.9875 152.952 86.0116 152.996 85.0357C153.026 84.365 153.056 83.6943 153.08 83.023C153.1 82.455 153.094 81.8726 153.088 81.2871C153.083 80.8081 153.077 80.3272 153.087 79.8504C151.931 80.6914 150.711 81.453 149.443 82.1334C149.496 82.8615 149.453 83.6304 149.413 84.3466C149.397 84.6333 149.381 84.9115 149.372 85.1754C149.315 86.917 149.235 88.6507 149.058 90.3844C148.953 91.4267 147.417 91.266 147.451 90.232C147.48 89.3489 147.519 88.4665 147.558 87.5841C147.59 86.8768 147.621 86.1696 147.647 85.462C147.666 84.9647 147.653 84.4398 147.641 83.9081C147.634 83.6194 147.627 83.3288 147.625 83.0394C146.4 83.6037 145.141 84.0977 143.858 84.5147C143.895 85.1455 143.854 85.8127 143.817 86.4216C143.801 86.6908 143.785 86.9485 143.777 87.1867C143.727 88.6484 143.665 90.1034 143.445 91.551C143.29 92.5734 141.762 92.445 141.837 91.3987C141.942 89.9447 142.019 88.4817 142.067 87.0247C142.08 86.6255 142.066 86.1971 142.051 85.7612C142.043 85.5259 142.035 85.2884 142.031 85.052C140.767 85.3884 139.49 85.6527 138.209 85.8437C137.865 85.947 137.52 86.047 137.171 86.1407C137.193 86.216 137.208 86.2954 137.208 86.3837C137.212 88.381 137.178 90.3977 137.013 92.388C136.924 93.458 135.26 93.3027 135.353 92.2307C135.519 90.3384 135.583 88.4244 135.606 86.5237C133.793 86.934 131.935 87.2314 130.058 87.4377C130.105 89.3737 130.128 91.3364 129.941 93.2587C129.838 94.3114 128.258 94.1547 128.312 93.1047C128.378 91.8196 128.38 90.5302 128.383 89.2411C128.384 88.6928 128.385 88.1445 128.39 87.5967C126.19 87.7787 123.979 87.8507 121.805 87.8537C121.857 88.6668 121.865 89.4845 121.873 90.3025C121.883 91.2865 121.893 92.2708 121.979 93.2477C122.078 94.3944 120.305 94.7137 120.209 93.5604C120.056 91.7167 119.896 89.7204 120.003 87.843C119.602 87.837 119.201 87.829 118.804 87.8194C117.192 87.78 115.543 87.7017 113.881 87.5714C113.895 88.2561 113.896 88.9417 113.897 89.6274C113.899 90.7737 113.901 91.9201 113.958 93.0627C114.01 94.0884 112.454 94.4134 112.348 93.3467C112.153 91.3894 112.177 89.3917 112.228 87.423C110.493 87.2474 108.754 87.0057 107.035 86.6747C107.036 86.6823 107.037 86.6899 107.038 86.6975C107.043 86.726 107.047 86.7545 107.047 86.785C107.065 88.6154 107.134 90.4587 107.295 92.2824C107.389 93.3454 105.743 93.6414 105.653 92.5717C105.489 90.6034 105.445 88.6087 105.449 86.634C105.45 86.5264 105.47 86.435 105.501 86.3527C104.033 86.0204 102.589 85.6154 101.184 85.128C101.185 85.4478 101.177 85.7711 101.168 86.0922C101.155 86.5695 101.143 87.042 101.164 87.4914C101.222 88.717 101.292 89.9447 101.378 91.1687C101.449 92.184 99.9511 92.4977 99.7878 91.449C99.5651 90.023 99.4911 88.585 99.4468 87.143C99.44 86.9262 99.4267 86.6955 99.4129 86.4567C99.3754 85.8097 99.3346 85.1038 99.4128 84.458C98.7418 84.1827 98.0811 83.888 97.4348 83.5674C97.5421 85.0867 97.5698 86.6017 97.3208 88.0277C96.8538 90.7024 94.9304 93.319 92.3351 94.234C92.9263 95.7506 92.8408 97.3979 92.7504 99.1382C92.7389 99.3593 92.7274 99.582 92.7171 99.806C92.6623 101.001 92.6215 102.196 92.5807 103.391C92.5138 105.349 92.447 107.306 92.3184 109.261C92.2924 109.658 92.2713 110.07 92.2497 110.493C92.1356 112.727 92.007 115.246 91.0534 117.176C90.3774 118.544 89.3968 119.414 88.2041 119.939C88.4568 120.091 88.7024 120.272 88.9411 120.488C90.0108 121.457 90.5391 122.796 90.8724 124.167C91.6414 127.328 91.9135 130.62 92.1812 133.859C92.1926 133.997 92.204 134.135 92.2154 134.272C92.2956 135.235 92.3695 136.199 92.4435 137.162C92.4993 137.891 92.5552 138.619 92.6138 139.347C92.6433 139.714 92.6928 140.095 92.7429 140.48C92.8508 141.312 92.9617 142.166 92.8831 142.957C92.7691 144.104 92.4111 145.166 91.8591 146.076C98.1517 147.686 104.664 147.935 111.134 148.183C111.358 148.192 111.582 148.2 111.806 148.209C121.515 148.584 131.274 148.572 140.963 147.764C141.282 147.737 141.603 147.711 141.925 147.684C148.082 147.175 154.779 146.622 160.491 144.226C160.597 144.182 160.72 144.138 160.851 144.091C161.33 143.919 161.914 143.711 162.123 143.317C162.416 142.767 162.44 142.029 162.462 141.355C162.469 141.152 162.475 140.955 162.489 140.77C162.627 138.894 162.728 137.016 162.81 135.137C163.032 130.055 163.189 124.968 163.272 119.883C163.416 111.061 161.249 102.657 159.071 94.2055C158.828 93.2636 158.585 92.3211 158.345 91.3774C158.048 90.212 159.817 89.954 160.153 91.0587C160.247 91.3701 160.342 91.6814 160.437 91.9925C162.003 97.1384 163.561 102.257 164.567 107.485C164.842 107.179 165.12 106.877 165.411 106.587C165.436 106.563 165.46 106.538 165.486 106.513C166.086 105.912 166.941 105.057 167.842 105.236C168.402 105.347 168.984 105.939 168.674 106.561C168.432 107.045 167.997 107.384 167.562 107.723C167.322 107.91 167.081 108.098 166.873 108.31C166.663 108.524 166.457 108.74 166.25 108.955C165.851 109.373 165.452 109.79 165.033 110.189C165.436 112.841 165.68 115.526 165.685 118.263C165.69 121.392 165.611 124.527 165.5 127.659C166.601 127.126 167.573 126.324 168.415 125.443C168.654 125.09 168.897 124.741 169.14 124.392C170.022 123.126 170.899 121.866 171.559 120.443Z"
            fill="#465B6D"
        />
    </svg>
);

export default TicketCatL;
