import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainBusNoCityPhotoL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 1200 400"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#0ce8d6e7__clip0_25495_5758)">
            <path
                d="M1200 0H0V349.85H1200V0Z"
                fill="url(#0ce8d6e7__paint0_linear_25495_5758)"
            />
            <path
                d="M1092.1 278.92C1096.86 279.984 1101.8 279.904 1106.53 278.687C1111.25 277.471 1115.62 275.151 1119.27 271.92C1122.48 269.03 1125.09 265.44 1128.72 263.12C1135.72 258.61 1144.8 259.78 1153.15 259.81C1155 259.946 1156.86 259.634 1158.56 258.9C1160.36 257.97 1161.56 256.24 1162.81 254.63C1168.64 247.01 1176.54 240.56 1185.89 238.44C1195.24 236.32 1206.07 239.31 1211.54 247.19C1214.23 251.06 1215.48 255.76 1217.86 259.83C1220.74 264.702 1225.14 268.496 1230.38 270.63C1235.53 272.7 1241.83 273.45 1244.93 278.06C1246.44 280.32 1246.85 283.12 1247.21 285.82C1247.67 289.367 1248.1 292.92 1248.49 296.48C1248.65 297.153 1248.56 297.86 1248.26 298.48C1247.73 299.3 1246.6 299.41 1245.63 299.48L1210.63 300.39C1195.89 300.78 1181.12 301.16 1166.43 299.9C1141.68 297.78 1117.6 291.03 1093.68 284.32"
                fill="#428C8A"
            />
            <path
                opacity={0.67}
                d="M555.905 242H440C440 242 458.538 231.024 466.241 231.61C473.944 232.195 472.645 237.605 472.645 237.605C472.645 237.605 488.131 224.988 501.767 225.722C515.403 226.456 513.788 233.144 513.788 233.144C513.788 233.144 528.812 218.16 552.747 220.189C571.529 221.739 555.905 242 555.905 242Z"
                fill="white"
            />
            <path
                opacity={0.5}
                d="M1273.52 102.6H1130.71C1130.71 102.6 1153.55 89.2901 1163 90.0001C1172.45 90.7101 1170.9 97.2501 1170.9 97.2501C1170.9 97.2501 1189.97 81.9501 1206.77 82.8501C1223.57 83.7501 1221.58 91.8501 1221.58 91.8501C1221.58 91.8501 1240.09 73.6801 1269.63 76.1401C1292.76 78.0001 1273.52 102.6 1273.52 102.6Z"
                fill="url(#0ce8d6e7__paint1_linear_25495_5758)"
            />
            <path
                opacity={0.6}
                d="M424.87 102.423H94C94 102.423 138.06 64.7732 184.53 59.1632C231 53.5532 229.39 80.7932 229.39 80.7932C229.39 80.7932 290.08 3.12318 383.01 10.4932C475.94 17.8632 438.49 72.7832 438.49 72.7832C438.49 72.7832 489.15 44.6832 522 56.2132C554.85 67.7432 529 102.423 529 102.423H424.87Z"
                fill="url(#0ce8d6e7__paint2_linear_25495_5758)"
            />
            <path
                opacity={0.4}
                d="M780 112.39H578.9C578.9 112.39 605.68 89.5101 633.9 86.1101C662.12 82.7101 661.17 99.2501 661.17 99.2501C661.17 99.2501 698.04 52.0601 754.52 56.5301C811 61.0001 788.23 94.3801 788.23 94.3801C788.23 94.3801 819 77.3101 839 84.3101C859 91.3101 843.26 112.39 843.26 112.39H780Z"
                fill="url(#0ce8d6e7__paint3_linear_25495_5758)"
            />
            <path
                opacity={0.7}
                d="M727.87 194.46H585.06C585.06 194.46 607.9 181.14 617.4 181.85C626.9 182.56 625.29 189.1 625.29 189.1C625.29 189.1 644.36 173.8 661.17 174.7C677.98 175.6 675.97 183.7 675.97 183.7C675.97 183.7 694.48 165.5 724 168C747.11 169.89 727.87 194.46 727.87 194.46Z"
                fill="url(#0ce8d6e7__paint4_linear_25495_5758)"
            />
            <path
                opacity={0.5}
                d="M80.48 31.5201C67.68 29.3801 50.64 35.9101 41.48 40.0901C41.8 28.7701 37.09 12.3901 7.19 12.3901C-38.52 12.3901 -58.81 42.2801 -58.81 42.2801C-58.81 42.2801 -55.87 27.7801 -78.03 27.7801C-100.19 27.7801 -125.74 50.6501 -125.74 50.6501H89C89 50.6501 98.88 34.6101 80.48 31.5201Z"
                fill="url(#0ce8d6e7__paint5_linear_25495_5758)"
            />
            <path
                d="M263.955 238.457C275.564 234.597 287.849 232.172 300.382 231.268C311.096 230.49 322.929 231.137 330.919 236.859C336.008 240.509 339.164 245.959 345.36 248.304C351.722 250.7 359.242 248.961 366.316 248.759C374.984 248.52 383.49 250.662 390.402 254.825C394.639 257.404 398.176 260.689 402.744 262.914C414.437 268.495 429.298 265.522 442.899 266.25C455.922 266.892 468.186 271.339 477.329 278.737C478.834 280.131 480.499 281.411 482.304 282.558C490.065 286.936 501.237 283.701 510.041 286.552C522.663 290.647 525.971 305.468 539 308.663C525.691 310.979 511.861 309.806 498.285 308.724C450.079 304.862 401.751 302.233 353.3 300.838C335.919 300.332 318.348 299.968 301.553 296.389C288.27 293.558 274.834 288.109 268.472 278.433C266.104 274.495 264.442 270.312 263.535 266.008C260.859 255.718 259.01 245.303 258 234.827"
                fill="#63A8A6"
            />
            <path
                d="M568.78 309.12C570.501 305.142 573.216 301.673 576.664 299.047C580.112 296.42 584.178 294.723 588.47 294.12C591.02 293.79 593.63 293.86 596.13 293.25C605.26 291.02 609.91 280.91 617.63 275.55C625.18 270.32 635.09 270.03 644.2 271.17C646.05 271.56 647.96 271.56 649.81 271.17C651.661 270.469 653.276 269.259 654.47 267.68C659.69 261.58 662.28 253.68 665 246.16C667.72 238.64 670.89 230.84 676.87 225.48C682.85 220.12 692.45 217.95 698.99 222.62C701.31 224.29 703.21 226.74 705.99 227.47C710.56 228.66 715.2 224.59 719.82 225.54C723.96 226.39 726.4 230.88 730.37 232.33C734.84 233.96 739.59 231.33 744.17 230.02C755.49 226.81 767.43 232.02 777.4 238.28C787.37 244.54 797 252.13 808.55 254.36C787.005 267.224 763.577 276.635 739.12 282.25C718.44 287 697.21 289 676.6 293.9C656.54 298.71 636.98 306.33 616.41 307.79C600.77 308.9 584.69 306.44 569.63 310.79"
                fill="#63A8A6"
            />
            <path
                d="M247 277.256C247 277.256 459.031 277.406 546.094 310.149C546.094 310.149 693.305 260.222 812.004 261.009C930.703 261.797 1316 296.992 1316 296.992L1286.33 442L293.681 439.618L247 277.256Z"
                fill="url(#0ce8d6e7__paint6_radial_25495_5758)"
            />
            <path
                d="M557.52 310.13C557.52 310.13 639.43 309.5 637.1 328.5C635.32 342.95 480.19 319.5 444.83 350.5C409.47 381.5 514.48 405.89 514.48 405.89L664.35 402.11C664.35 402.11 546.17 382.91 547.62 358C548.47 343.41 686.13 359.43 684.62 328.91C683.11 298.39 557.52 310.13 557.52 310.13Z"
                fill="url(#0ce8d6e7__paint7_linear_25495_5758)"
            />
            <path
                d="M548.81 356C548.81 356 557.72 351.93 576.3 348.84C594.88 345.75 614.07 346.35 622.3 346.35C630.53 346.35 645.59 342.04 649.69 340.67C653.79 339.3 709.14 313.54 745.26 318.76C781.38 323.98 764.67 354.24 764.67 354.24L732.83 386L682.15 403.22C669.742 402.522 657.398 400.951 645.21 398.52C627.32 394.73 582.78 384.9 566.21 375.83C549.64 366.76 548.07 363.53 547.7 359.76C547.33 355.99 548.81 356 548.81 356Z"
                fill="url(#0ce8d6e7__paint8_radial_25495_5758)"
            />
            <path
                d="M383.636 362C372.876 359.178 360.448 358.8 351.703 365.689C335.5 378.452 325.5 393.005 319.55 413.422C317.965 416.419 316.912 420.947 319.898 422.497C320.868 422.901 321.92 423.066 322.966 422.976C409.458 422.472 495.95 421.439 582.443 419.878L582.461 419.877C586.402 419.804 590.489 419.727 594 417.886C582.791 411.689 576.142 398.768 564.42 393.632C548.431 386.642 529.721 396.694 512.67 393.005C509.75 392.48 507.003 391.246 504.666 389.408C501.653 386.872 500.087 383.1 498.255 379.596C490.416 364.223 475.873 351.22 458.767 350.085C445.03 349.172 432.09 355.766 419.388 361.078C413.49 363.522 407.327 365.781 400.917 365.689C395.019 365.56 389.35 363.485 383.636 362Z"
                fill="#2E7C6F"
            />
            <path
                d="M937.07 -5.77979C937.07 -5.77979 905.54 60.0002 887.27 150C877.52 197.95 871.54 249 868.09 286.3C866.583 302.574 859.367 317.79 847.72 329.256C836.073 340.722 820.746 347.698 804.45 348.95C795.43 349.617 786.397 350.077 777.35 350.33C795.175 350.766 813.011 350.305 830.79 348.95C847.085 347.698 862.411 340.721 874.056 329.255C885.701 317.789 892.915 302.573 894.42 286.3C897.88 249.04 903.86 197.95 913.6 150C931.88 60.0002 963.41 -5.77979 963.41 -5.77979H937.07Z"
                fill="#FFD2C6"
            />
            <path
                d="M718.33 -11.0801L102.22 203.7C92.276 255.092 87.562 307.358 88.15 359.7L718.36 120.15L718.33 -11.0801Z"
                fill="url(#0ce8d6e7__paint9_linear_25495_5758)"
            />
            <path
                opacity={0.2}
                d="M718.36 185.78L49.3701 426.46L70.3101 488.07L717.44 240.17L718.36 185.78Z"
                fill="url(#0ce8d6e7__paint10_linear_25495_5758)"
            />
            <path
                d="M751.84 558.53L754.84 -76.91H1143.3L1135.86 -135H-243.32L-235.87 -76.94H39.3801L36.3801 558.5H-154.38L-152.38 573.9H1226.77L1224.77 558.5L751.84 558.53ZM109.84 558.77C60.0001 334.91 112.84 -76.67 112.84 -76.67H721.48L718.48 558.77H109.84Z"
                fill="url(#0ce8d6e7__paint11_linear_25495_5758)"
            />
            <path
                d="M865.6 558.53L868.6 -76.91H1177L1149.59 -135H-229.59L-222.14 -76.94H57.37L54.37 558.5H-140.63L-138.63 573.9H1240.5L1258.5 558.5L865.6 558.53ZM183.6 558.77L186.6 -76.67H739.21L736.21 558.77H183.6Z"
                fill="url(#0ce8d6e7__paint12_linear_25495_5758)"
            />
            <path
                opacity={0.2}
                d="M65.4701 196.06L-581.69 426.46L-560.75 488.07L64.5601 250.45L65.4701 196.06Z"
                fill="url(#0ce8d6e7__paint13_linear_25495_5758)"
            />
            <path
                d="M288.18 582.001C289.327 478.736 284.88 375.485 274.86 272.701C272.799 252.015 264.466 232.452 250.978 216.634C237.49 200.815 219.49 189.495 199.39 184.191C130.62 166.001 42.6001 152.841 -27.8799 149.551C-42.3699 148.881 -70.2199 150.551 -86.7699 155.901C-89.6499 156.841 -113.46 162.731 -114.98 163.971C-130.29 176.431 -112.34 195.411 -117.24 218.151C-133.3 292.641 -157.54 420.421 -169.17 558.751"
                fill="#5F8296"
            />
            <path
                d="M228.3 593.42C229.455 490.152 225.015 386.898 215 284.11C212.937 263.42 204.6 243.855 191.106 228.036C177.612 212.217 159.606 200.899 139.5 195.6C70.73 177.42 -17.28 164.25 -87.76 161C-108.363 160.007 -128.651 166.355 -145.013 178.914C-161.376 191.474 -172.753 209.431 -177.12 229.59C-193.18 304.05 -217.43 431.83 -229 570.16"
                fill="url(#0ce8d6e7__paint14_linear_25495_5758)"
            />
            <path
                d="M1170.5 527.772C1169.44 433.377 1163.26 339.109 1152 245.382C1149.7 226.519 1141.69 208.81 1129.04 194.628C1116.39 180.446 1099.71 170.468 1081.23 166.032C1018.01 150.812 937.31 140.572 872.83 139.032C857.27 138.662 824.97 141.552 812.38 149.032C793.45 160.332 796.98 180.542 792.56 203.512C779.41 271.902 759.85 389.172 752.05 515.832"
                fill="#5F8296"
            />
            <path
                d="M1123 534.262C1121.94 439.864 1115.77 345.592 1104.52 251.862C1102.22 232.999 1094.2 215.291 1081.56 201.109C1068.91 186.927 1052.23 176.949 1033.75 172.512C970.53 157.302 889.83 147.062 825.35 145.512C806.485 145.005 788.053 151.213 773.338 163.03C758.622 174.846 748.58 191.502 745 210.032C731.85 278.432 712.29 395.702 704.49 522.352"
                fill="#4F6C7F"
            />
            <path
                d="M894.337 -33.5373C824.357 -33.5373 787.452 24.9067 786.831 60.9951L798.561 83.0005C798.561 83.0005 799.929 108.632 767.547 125.826C735.166 143.021 719.522 164.264 730.779 187.371C730.779 187.371 701.133 213.899 712.663 243.765C724.193 273.631 763.707 278.473 763.707 278.473L1022.92 313.954C1022.92 313.954 1053.99 323.115 1084.5 296.999C1115.01 270.883 1106.15 224.933 1096.5 211.499C1084.5 194.788 1063.36 186.568 1063.36 186.568C1063.36 186.568 1072.47 163.388 1052.5 143.999C1032.53 124.61 1011.31 140.09 1005 114.499C998.688 88.9085 1026.72 33.5454 980 -11.001C933.28 -55.5474 894.337 -33.5373 894.337 -33.5373Z"
                fill="#333333"
            />
            <path
                d="M921.75 203.999C997.75 219.649 1058.22 261.389 1075.96 307.819C1093.7 354.249 1085.87 420.999 1085.87 420.999L846.87 463.259C846.87 463.259 646 413.699 647.61 412.649C649.22 411.599 686.37 341.169 714 287.999C741.63 234.829 800.53 216.519 833.4 207.649C866.27 198.779 921.75 203.999 921.75 203.999Z"
                fill="url(#0ce8d6e7__paint15_linear_25495_5758)"
            />
            <path
                d="M869.34 214.639L860.61 232.409C860.61 232.409 863.88 253.859 850.69 271.579C837.5 289.299 818.08 301.129 791.32 295.499C764.56 289.869 749.63 259.159 755.55 228.179C761.47 197.199 797 174.309 797 174.309L866.85 177.199L869.34 214.639Z"
                fill="url(#0ce8d6e7__paint16_linear_25495_5758)"
            />
            <path
                d="M869.34 214.639L860.61 232.409C860.61 232.409 863.88 253.859 850.69 271.579C837.5 289.299 818.08 301.129 791.32 295.499C764.56 289.869 749.63 259.159 755.55 228.179C761.47 197.199 797 174.309 797 174.309L866.85 177.199L869.34 214.639Z"
                fill="url(#0ce8d6e7__paint17_linear_25495_5758)"
            />
            <path
                d="M853.64 268.929C856.11 272.829 860.05 275.929 866.22 277.259C890.09 282.349 912.96 267.869 912.96 267.869C912.96 267.869 943.27 249.479 944.26 225.609C945.25 201.739 933.91 140.849 933.91 140.849L933.13 98.4293V91.6293C933.13 91.6293 896.78 78.7393 877.21 24.7393C877.21 24.7393 841.02 59.2993 787.02 58.3293C787.02 58.3293 786.24 74.5693 787.02 87.3293C787.8 100.089 791.71 108.849 789.95 126.269C788.19 143.689 787.61 160.269 794.45 180.459C801.29 200.649 808.62 212.619 823.74 216.919C836.74 220.609 849.82 218.619 862.87 213.659L864.59 219.789C861.398 222.004 859.19 225.37 858.43 229.179C857.43 235.309 859.21 246.789 858.17 255.529C857.13 264.269 853.64 268.929 853.64 268.929Z"
                fill="#FFD4C2"
            />
            <path
                opacity={0.6}
                d="M915.54 94.169C911.54 101.169 902.78 120.749 911.8 146.039C919.8 168.549 932.8 174.149 939.64 175.509C936.88 156.769 933.91 140.849 933.91 140.849L933.13 98.429V91.629C933.13 91.629 897.31 78.929 877.64 25.999C877.64 25.999 889.63 74.629 915.54 94.169Z"
                fill="#F4C2AD"
            />
            <path
                opacity={0.6}
                d="M907.71 184.659C894.756 196.544 879.908 206.183 863.78 213.179L862.98 214.179L864.55 219.759C861.358 221.973 859.15 225.34 858.39 229.149C857.53 234.209 858.62 242.909 858.44 250.709C863.5 256.499 869 252.999 869 252.999C870.33 251.774 871.448 250.338 872.31 248.749C874.15 245.669 869.85 235.579 869.85 235.579C901.83 214.389 907.71 184.659 907.71 184.659Z"
                fill="#F8BDA4"
            />
            <path
                d="M935.15 147.529C935.15 147.529 973.9 145.939 1000.94 177.199C1027.98 208.459 1031.64 270.709 998.94 301.979C966.24 333.249 903.46 330.419 888.25 298.309C873.04 266.199 893.48 242.829 913.11 232.409C932.74 221.989 941.25 209.339 941.93 194.409C940.14 178.879 937.84 163.249 935.15 147.529Z"
                fill="url(#0ce8d6e7__paint18_linear_25495_5758)"
            />
            <path
                d="M935.15 147.529C935.15 147.529 973.9 145.939 1000.94 177.199C1027.98 208.459 1031.64 270.709 998.94 301.979C966.24 333.249 903.46 330.419 888.25 298.309C873.04 266.199 893.48 242.829 913.11 232.409C932.74 221.989 941.25 209.339 941.93 194.409C940.14 178.879 937.84 163.249 935.15 147.529Z"
                fill="url(#0ce8d6e7__paint19_linear_25495_5758)"
            />
            <path
                d="M878.35 21.1491C878.35 21.1491 885.78 -0.170859 905.15 -11.1309"
                stroke="#333333"
                strokeMiterlimit={10}
            />
            <path
                d="M913 178.849C897.33 198.609 862.87 213.609 862.87 213.609L872 242.529C872 242.529 875 250.159 868.06 253.529"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M887.058 160.575C900.286 155.37 907.169 141.389 902.43 129.347C897.692 117.306 883.127 111.765 869.899 116.97C856.67 122.176 849.787 136.157 854.526 148.198C859.264 160.239 873.829 165.781 887.058 160.575Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M810.54 131.609C808.943 127.452 806.197 123.835 802.622 121.179C799.047 118.523 794.791 116.938 790.35 116.609C790.39 119.815 790.243 123.02 789.91 126.209C788.68 138.429 788.03 150.279 790.12 163.209C792.858 163.204 795.571 162.689 798.12 161.689C809.7 157.129 815.28 143.659 810.54 131.609Z"
                fill="#FC8D72"
                fillOpacity={0.28}
            />
            <path
                d="M865.141 108.194C865.849 104.421 863.963 100.901 860.929 100.332C857.895 99.7622 854.861 102.359 854.153 106.131C853.445 109.904 855.33 113.424 858.365 113.993C861.399 114.563 864.433 111.966 865.141 108.194Z"
                fill="#333333"
            />
            <path
                d="M812.635 108.192C813.343 104.42 811.457 100.9 808.423 100.33C805.388 99.7606 802.354 102.357 801.646 106.13C800.938 109.902 802.824 113.422 805.858 113.992C808.893 114.561 811.927 111.965 812.635 108.192Z"
                fill="#333333"
            />
            <path
                d="M855.85 85.829C855.85 85.829 875.61 81.289 884.8 97.529"
                stroke="#333333"
                strokeWidth={4}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M812.33 85.829C812.33 85.829 796.18 81.289 788.66 97.529"
                stroke="#333333"
                strokeWidth={4}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M823.57 91.3892C823.57 91.3892 827.48 104.699 821.48 112.779C815.48 120.859 807.14 126.409 807.14 132.779C807.14 141.779 820.14 146.079 820.14 146.079"
                fill="#FFD4C2"
            />
            <path
                d="M823.57 91.3892C823.57 91.3892 827.48 104.699 821.48 112.779C815.48 120.859 807.14 126.409 807.14 132.779C807.14 141.779 820.14 146.079 820.14 146.079"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M817 178.844C822.603 182.206 830.253 184.196 838.548 182.206C847.769 179.995 853.126 175.001 858 166.999"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M737.87 354.219L706.57 405.869"
                stroke="#EEA70D"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M966.06 380.039L960.59 415.779"
                stroke="#EEA70D"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M971.85 125.379C968.13 141.199 972.05 153.749 960.36 157.119C956.47 158.239 938.08 157.719 934.11 156.789C918.23 153.049 909.38 132.929 914.34 111.849C918.53 93.9988 931.24 81.2388 944.66 79.9988C947.13 79.7588 965.03 79.5188 967.5 80.1088C983.38 83.7888 976.81 104.299 971.85 125.379Z"
                fill="#507CA0"
            />
            <path
                d="M980.64 125.379C976.92 141.199 966.99 153.749 955.3 157.119C951.41 158.239 946.87 157.719 942.9 156.789C927.02 153.049 918.16 132.929 923.13 111.849C927.32 93.9988 940 81.2388 953.45 79.9988C955.819 79.6204 958.235 79.6576 960.59 80.1088C976.47 83.7888 985.6 104.299 980.64 125.379Z"
                fill="#8AC9FF"
            />
            <path
                d="M939.13 110.659L955.77 93.1289L973 82.2289C971.433 81.0909 969.65 80.2845 967.76 79.8589C961.47 78.2789 947.13 79.5089 944.63 79.7489C932.41 80.9289 920.77 91.5389 915.46 106.799L939.13 110.659Z"
                fill="#75B5E6"
            />
            <path
                d="M924.89 -5.78076C962.89 16.1492 963.71 78.2192 963.71 78.2192L951.1 78.4692C947.58 78.7492 945.23 82.1792 942.4 83.6492L940.05 82.0892C940.05 82.0892 939.2 20.0092 901.24 -1.91076"
                fill="#8AC9FF"
            />
            <path
                d="M927.24 -6.49072C965.24 16.0093 965.12 79.3993 965.12 79.3993C961.18 79.0693 950.79 78.8193 942.4 83.6593C942.4 83.6593 941.54 19.9793 903.59 -2.52072"
                fill="#AEDCFF"
            />
            <path
                d="M989.398 125.401C994.362 104.317 985.514 84.1941 969.633 80.4548C953.753 76.7156 936.855 90.7762 931.89 111.86C926.926 132.944 935.775 153.067 951.655 156.807C967.535 160.546 984.433 146.485 989.398 125.401Z"
                fill="#AEDCFF"
            />
            <path
                d="M978.691 122.88C981.806 109.65 976.252 97.0229 966.285 94.676C956.318 92.3292 945.713 101.152 942.598 114.382C939.482 127.611 945.037 140.239 955.003 142.586C964.97 144.933 975.575 136.11 978.691 122.88Z"
                fill="#75B5E6"
            />
        </g>
        <defs>
            <linearGradient
                id="0ce8d6e7__paint0_linear_25495_5758"
                x1={670}
                y1={-88}
                x2={576.4}
                y2={389.08}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint1_linear_25495_5758"
                x1={182237}
                y1={1948.15}
                x2={182245}
                y2={3009.11}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint2_linear_25495_5758"
                x1={144850}
                y1={516.479}
                x2={144769}
                y2={13911.1}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint3_linear_25495_5758"
                x1={194207}
                y1={2479.48}
                x2={194167}
                y2={7299.73}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint4_linear_25495_5758"
                x1={99984.3}
                y1={4324.57}
                x2={99976.2}
                y2={5677.43}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint5_linear_25495_5758"
                x1={-4136.57}
                y1={357.878}
                x2={-4125.98}
                y2={1936.79}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <radialGradient
                id="0ce8d6e7__paint6_radial_25495_5758"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(781.5 292.427) scale(238.49 235.115)"
            >
                <stop stopColor="#8BCCAD" />
                <stop offset={1} stopColor="#5C9D92" />
            </radialGradient>
            <linearGradient
                id="0ce8d6e7__paint7_linear_25495_5758"
                x1={552.45}
                y1={304.09}
                x2={572.01}
                y2={400.35}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#B6E4FD" />
                <stop offset={1} stopColor="#53ABDB" />
            </linearGradient>
            <radialGradient
                id="0ce8d6e7__paint8_radial_25495_5758"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(631.09 308.17) scale(93.82)"
            >
                <stop stopColor="#7FB8B6" />
                <stop offset={1} stopColor="#4A9185" />
            </radialGradient>
            <linearGradient
                id="0ce8d6e7__paint9_linear_25495_5758"
                x1={458205}
                y1={3770.08}
                x2={233039}
                y2={251164}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0.1} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint10_linear_25495_5758"
                x1={466162}
                y1={53385.5}
                x2={292421}
                y2={295030}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint11_linear_25495_5758"
                x1={-197.29}
                y1={218.779}
                x2={1158.5}
                y2={40.7459}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#CFE1ED" />
                <stop offset={1} stopColor="#D0D6DA" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint12_linear_25495_5758"
                x1={-183.56}
                y1={218.779}
                x2={1172.24}
                y2={40.7446}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FDFDFD" />
                <stop offset={1} stopColor="#D0DCE6" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint13_linear_25495_5758"
                x1={28984.8}
                y1={54549.8}
                x2={-133134}
                y2={280324}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint14_linear_25495_5758"
                x1={-5.90732}
                y1={416.162}
                x2={-17.4989}
                y2={181.778}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#79A1B5" />
                <stop offset={1} stopColor="#7E99AB" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint15_linear_25495_5758"
                x1={865}
                y1={323.499}
                x2={1098.5}
                y2={420.999}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint16_linear_25495_5758"
                x1={828.2}
                y1={187.739}
                x2={803.69}
                y2={249.419}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint17_linear_25495_5758"
                x1={828.2}
                y1={187.739}
                x2={803.69}
                y2={249.419}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#587F9A" />
                <stop offset={1} stopColor="#6796B9" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint18_linear_25495_5758"
                x1={135460}
                y1={30687.2}
                x2={137526}
                y2={49687.3}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <linearGradient
                id="0ce8d6e7__paint19_linear_25495_5758"
                x1={135460}
                y1={30687.2}
                x2={137526}
                y2={49687.3}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#587F9A" />
                <stop offset={1} stopColor="#6796B9" />
            </linearGradient>
            <clipPath id="0ce8d6e7__clip0_25495_5758">
                <rect width={1200} height={400} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default TrainBusNoCityPhotoL;
