import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TravelLogoM = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 20 20" fill="none" focusable={false} {...props}>
        <rect
            width={20}
            height={20}
            rx={10}
            transform="matrix(1 0 0 -1 0 20)"
            fill="#FC0"
        />
        <mask
            id="1221df76__a"
            maskUnits="userSpaceOnUse"
            x={0}
            y={0}
            width={20}
            height={20}
        >
            <path
                d="M0 10c0 5.523 4.477 10 10 10s10-4.477 10-10S15.523 0 10 0 0 4.477 0 10z"
                fill="#C4C4C4"
            />
        </mask>
        <g mask="url(#1221df76__a)">
            <path
                d="M12.527 4.804h.89L15.015-.29h-.89l-1.599 5.094zM11.82-1.353L9.842 4.804h.889l1.978-6.157h-.889zM5.82 13.137a1.408 1.408 0 00-.77-.005c-.442.102-.769.682-.769 1.525 0 .843.263 1.3.613 1.502.267.087.553.097.824.018.31-.078.77-.681.77-1.524 0-.844-.249-1.392-.668-1.516zM14.042 13.137a1.359 1.359 0 00-.755-.005c-.433.102-.756.682-.756 1.525 0 .843.258 1.3.604 1.502.262.087.543.097.81.018.304-.078.756-.681.756-1.524 0-.844-.249-1.392-.659-1.516z"
                fill="#292929"
            />
            <path
                d="M14.033 4.306h-5.74c-1.377 0-1.856 1.543-1.856 1.543s-1.64 5.316-2.243 7.256c-.604 1.939 1.52 2.704 2.059 2.704h5.998c.548 0 .903-.406.903-1.226 0-.963.51-1.446.87-1.432.125.023.24.087.318.184.534-1.746 1.875-6.002 1.926-6.205.63-1.801-1.235-2.824-2.235-2.824z"
                fill="url(#1221df76__paint0_linear)"
            />
            <path
                d="M14.609 4.864a.367.367 0 00-.373.262l-2.386 7.31c0 .005-.005.01-.005.02a2.45 2.45 0 01-.286.732c-.152.165-.087.456.632.285.718-.17.792-.613 1.105-1.566.272-.83 1.566-4.906 1.902-5.965a.913.913 0 00-.06-.728.628.628 0 00-.53-.35z"
                fill="url(#1221df76__paint1_linear)"
            />
            <path
                d="M11.762 5.891c-.143.341-1.98 6.219-2.077 6.523-.097.304.317.4.317.4l2.276-7.245.005-.014h-.014a.484.484 0 00-.507.336z"
                fill="url(#1221df76__paint2_linear)"
            />
            <path
                d="M10.348 5.555c-.157.032-.378-.005-.52.336-.143.34-1.981 6.219-2.078 6.523-.097.304.318.4.318.4l2.28-7.26z"
                fill="url(#1221df76__paint3_linear)"
            />
            <path
                d="M8.33 5.555a.496.496 0 00-.52.336c-.143.34-1.98 6.219-2.078 6.523-.096.304.318.4.318.4l2.28-7.26z"
                fill="url(#1221df76__paint4_linear)"
            />
        </g>
        <defs>
            <linearGradient
                id="1221df76__paint0_linear"
                x1={10.241}
                y1={15.724}
                x2={10.241}
                y2={4.224}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.085} stopColor="#C70100" />
                <stop offset={0.195} stopColor="#E11C1B" />
                <stop offset={0.979} stopColor="#E11C1B" />
            </linearGradient>
            <linearGradient
                id="1221df76__paint1_linear"
                x1={12.07}
                y1={13.629}
                x2={14.754}
                y2={4.888}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E52F2D" />
                <stop offset={0.075} stopColor="#E63634" />
                <stop offset={1} stopColor="#EF8883" />
            </linearGradient>
            <linearGradient
                id="1221df76__paint2_linear"
                x1={9.852}
                y1={12.646}
                x2={12.732}
                y2={3.324}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.025} stopColor="#E52F2D" />
                <stop offset={0.519} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="1221df76__paint3_linear"
                x1={8.084}
                y1={12.1}
                x2={10.964}
                y2={2.778}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.025} stopColor="#E52F2D" />
                <stop offset={0.519} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="1221df76__paint4_linear"
                x1={6.245}
                y1={11.532}
                x2={9.125}
                y2={2.21}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.025} stopColor="#E52F2D" />
                <stop offset={0.519} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
        </defs>
    </svg>
);

export default TravelLogoM;
