import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DzenIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 32 32" fill="none" focusable={false} {...props}>
        <rect width="32" height="32" rx="8" fill="#191B26" />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M31.9999 16.1775V16.0007V15.8246C24.9151 15.6102 21.6752 15.4334 19.0912 12.9095C16.5681 10.3261 16.3906 7.08634 16.1768 0.0012207H15.9999H15.8231C15.6093 7.08634 15.4319 10.3261 12.9087 12.9095C10.3247 15.4334 7.0848 15.6102 0 15.8246V16.0007V16.1775C7.0848 16.3919 10.3247 16.5687 12.9087 19.0919C15.4319 21.676 15.6093 24.9158 15.8231 32.0009H15.9999H16.1768C16.3906 24.9158 16.5681 21.676 19.0912 19.0919C21.6752 16.5687 24.9151 16.3919 31.9999 16.1775Z"
            fill="white"
        />
    </svg>
);

DzenIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default DzenIcon;
