import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const VKIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 32 32" fill="none" focusable={false} {...props}>
        <rect width="32" height="32" rx="8" fill="#4680C2" />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M26.4352 10.5174C26.597 10.0089 26.4352 9.63908 25.7187 9.63908H23.3381C22.7372 9.63908 22.4598 9.96265 22.298 10.3093C22.298 10.3093 21.0731 13.2677 19.3628 15.1861C18.8081 15.7408 18.5538 15.9257 18.2534 15.9257C18.0916 15.9257 17.8836 15.7408 17.8836 15.2323V10.4942C17.8836 9.89332 17.6987 9.61597 17.1902 9.61597H13.446C13.0762 9.61597 12.8451 9.89331 12.8451 10.1707C12.8451 10.7485 13.7002 10.8872 13.7927 12.505V16.0181C13.7927 16.7808 13.654 16.9195 13.3535 16.9195C12.5446 16.9195 10.58 13.938 9.40129 10.5405C9.17017 9.8702 8.93905 9.61597 8.33812 9.61597H5.93442C5.24105 9.61597 5.12549 9.93954 5.12549 10.2862C5.12549 10.9103 5.93443 14.0536 8.89282 18.2138C10.8574 21.0566 13.654 22.5821 16.1732 22.5821C17.6987 22.5821 17.8836 22.2354 17.8836 21.6576V19.5081C17.8836 18.8147 18.0222 18.6992 18.5076 18.6992C18.8543 18.6992 19.4783 18.8841 20.8882 20.2477C22.5061 21.8656 22.7834 22.6052 23.6848 22.6052H26.0654C26.7588 22.6052 27.0823 22.2585 26.8974 21.5882C26.6894 20.918 25.9036 19.9472 24.8866 18.7916C24.3319 18.1445 23.4999 17.428 23.2457 17.0813C22.899 16.619 22.9914 16.4341 23.2457 16.0181C23.2225 16.0181 26.1347 11.9041 26.4352 10.5174Z"
            fill="white"
        />
    </svg>
);

VKIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default VKIcon;
