const polyfills: Promise<unknown>[] = [];

if (!Element.prototype.matches) {
    polyfills.push(import('./matchesPolyfill'));
}

if (!Element.prototype.closest) {
    polyfills.push(import('./closestPolyfill'));
}

if (!window.IntersectionObserver) {
    // @ts-ignore
    polyfills.push(import('intersection-observer'));
}

if (!window.ResizeObserver) {
    polyfills.push(import('./resizeObserverPolyfill'));
}

if (!window.AbortController) {
    // Импортируем чистый полифилл без патча fetch, так как используем axios
    // https://github.com/mo/abortcontroller-polyfill#using-the-abortcontrollerabortsignal-without-patching-fetch
    polyfills.push(
        // @ts-ignore
        import('abortcontroller-polyfill/dist/abortcontroller-polyfill-only'),
    );
}

export default Promise.all(polyfills);
