import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import hotelPageReducer from 'reducers/depreacted/hotels/hotelPage/reducer';

import hotelInfo from 'sagas/depreacted/hotels/hotelPage/hotelInfo';
import hotelImages from 'sagas/depreacted/hotels/hotelPage/hotelImages';
import hotelReviews from 'sagas/depreacted/hotels/hotelPage/hotelReviews';
import hotelOffers from 'sagas/depreacted/hotels/hotelPage/hotelOffers';
import similarHotels from 'sagas/depreacted/hotels/hotelPage/similarHotels';
import syncHotelInfoSearchParamsWithLocation from 'sagas/depreacted/hotels/hotelPage/syncHotelInfoSearchParamsWithLocation';

import {loadable} from 'utilities/pageLoadable';

import withSaga from 'containers/withSaga/withSaga';
import withReducers from 'containers/withReducers/withReducers';

const HotelPage = loadable(
    () => import('projects/depreacted/hotels/pages/HotelPage/HotelPageContainer'),
);

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const HotelSearchApp: React.FC = () => {
    return (
        <Switch>
            <Route
                exact
                path={[URLs.hotelsHotelPage, URLs.hotelsHotelWithSlug]}
                component={HotelPage}
            />
            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default React.memo(
    withReducers([[ELoadableReducer.HOTELS_HOTEL_PAGE, hotelPageReducer]])(
        withSaga([
            hotelInfo,
            hotelImages,
            hotelReviews,
            hotelOffers,
            similarHotels,
            syncHotelInfoSearchParamsWithLocation,
        ])(HotelSearchApp),
    ),
);
