import {ReactNode, PureComponent} from 'react';

import {IHotelOrRoomAmenity} from 'types/hotels/hotel/IHotel';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

/* Components */
import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';

import AmenityGroup from './blocks/AmenityGroup/AmenityGroup';
import {AmenitiesLayout} from './blocks/AmenitiesLayout/AmenitiesLayout';
import {MainAmenities} from './blocks/MainAmenities/MainAmenities';

/* Styles */
import cx from './Amenities.scss';

interface IAmenitiesListProps extends IWithDeviceType {
    mainAmenities?: IHotelOrRoomAmenity[];
    additionalAmenitiesTitle: string;
    additionalAmenities?: IHotelOrRoomAmenity[];
    isAllAmenities: boolean;
    isModal?: boolean;
}

export default class AmenitiesList extends PureComponent<IAmenitiesListProps> {
    private renderAdditionalAmenities(): ReactNode {
        const {
            additionalAmenities,
            additionalAmenitiesTitle,
            deviceType,
            isAllAmenities,
        } = this.props;

        if (!additionalAmenities) {
            return null;
        }

        return (
            <AutoHeightAnimateControl canShowComponent={isAllAmenities}>
                <AmenityGroup
                    className={cx('additionalAmenities')}
                    listClassName={cx(
                        'amenityGroups',
                        deviceMods('amenityGroups', deviceType),
                    )}
                    amenityGroup={{
                        id: '',
                        name: additionalAmenitiesTitle,
                        amenities: additionalAmenities,
                    }}
                    deviceType={deviceType}
                />
            </AutoHeightAnimateControl>
        );
    }

    render(): ReactNode {
        const {mainAmenities, deviceType, isAllAmenities} = this.props;

        return (
            <AmenitiesLayout deviceType={deviceType}>
                <MainAmenities
                    mainAmenities={mainAmenities}
                    isAllAmenities={isAllAmenities}
                    deviceType={deviceType}
                />
                {this.renderAdditionalAmenities()}
            </AmenitiesLayout>
        );
    }
}
