import {ReactNode, PureComponent} from 'react';

import {
    IHotelAmenitiesGroup,
    IHotelOrRoomAmenity,
} from 'types/hotels/hotel/IHotel';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

/* Components */

import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';

import AmenityGroup from './blocks/AmenityGroup/AmenityGroup';
import {AmenitiesLayout} from './blocks/AmenitiesLayout/AmenitiesLayout';
import {MainAmenities} from './blocks/MainAmenities/MainAmenities';

/* Styles */
import cx from './GroupedAmenities.scss';

interface IGroupedAmenitiesProps extends IWithDeviceType, IWithQaAttributes {
    mainAmenities?: IHotelOrRoomAmenity[];
    isAllAmenities: boolean;
    isModal?: boolean;
    amenityGroups?: IHotelAmenitiesGroup[];
}

export default class GroupedAmenities extends PureComponent<IGroupedAmenitiesProps> {
    private renderAdditionalAmenities(): ReactNode {
        const {amenityGroups, deviceType, isAllAmenities} = this.props;

        if (!amenityGroups) {
            return null;
        }

        return (
            <AutoHeightAnimateControl canShowComponent={isAllAmenities}>
                <div
                    className={cx(
                        'additionalAmenities',
                        deviceMods('additionalAmenities', deviceType),
                    )}
                >
                    {amenityGroups.map(group => (
                        <AmenityGroup
                            className={cx(
                                'amenityGroup',
                                deviceMods('amenityGroup', deviceType),
                            )}
                            key={group.id}
                            amenityGroup={group}
                            deviceType={deviceType}
                        />
                    ))}
                </div>
            </AutoHeightAnimateControl>
        );
    }

    render(): ReactNode {
        const {mainAmenities, deviceType, isAllAmenities} = this.props;

        if (!mainAmenities?.length) {
            return null;
        }

        return (
            <AmenitiesLayout deviceType={deviceType}>
                <MainAmenities
                    mainAmenities={mainAmenities}
                    isAllAmenities={isAllAmenities}
                    deviceType={deviceType}
                />
                {this.renderAdditionalAmenities()}
            </AmenitiesLayout>
        );
    }
}
