import {FunctionComponent} from 'react';

/* Types */
import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {IHotelAmenitiesGroup} from 'types/hotels/hotel/IHotel';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

/* Components */

import IncludeIcon from 'icons/16/Include';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

/* Styles */
import cx from './AmenityGroup.scss';

export interface IAmenityGroupProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    amenityGroup: IHotelAmenitiesGroup;
    listClassName?: string;
}

const AmenityGroup: FunctionComponent<IAmenityGroupProps> = ({
    amenityGroup,
    className,
    listClassName,
    deviceType,
    ...rest
}) => {
    const {isMobile} = deviceType;
    const {name: groupName, amenities} = amenityGroup;

    return (
        <div
            className={cx('root', deviceMods('root', deviceType), className)}
            {...prepareQaAttributes(rest)}
        >
            <TextWithIcon
                className={cx('name')}
                iconLeftClassName={cx('icon')}
                iconLeft={isMobile ? undefined : IncludeIcon}
                text={groupName}
            />
            <ul
                className={cx(
                    'list',
                    deviceMods('list', deviceType),
                    listClassName,
                )}
            >
                {amenities.map(({id, name}) => (
                    <li key={id + name} className={cx('listItem')}>
                        {name}
                    </li>
                ))}
            </ul>
        </div>
    );
};

export default AmenityGroup;
