import {FunctionComponent, ComponentType} from 'react';

/* Types */
import {IWithClassName} from 'types/withClassName';
import {
    IHotelOrRoomAmenity,
    MainAmenityIdType,
} from 'types/hotels/hotel/IHotel';
import {IIconProps} from 'icons/types/icon';

/* Components */
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import WiFiIcon from 'icons/16/WiFi';
import SwimmingPoolIcon from 'icons/16/SwimmingPool';
import ParkingIcon from 'icons/16/Parking';
import AcIcon from 'icons/16/Ac';
import FitnessIcon from 'icons/16/Fitness';
import CardIcon from 'icons/16/Card';
import BeachIcon from 'icons/16/Beach';
import Include from 'icons/16/Include';
import AirDisinfection from 'icons/16/AirDisinfection';
import Sanitizers from 'icons/16/Sanitizers';
import Glove from 'icons/16/Glove';
import Thermometer from 'icons/16/Thermometer';
import SocialDistance from 'icons/16/SocialDistance';

function getIconByAmenityId(
    id: MainAmenityIdType,
): ComponentType<IIconProps> | undefined {
    switch (id) {
        case MainAmenityIdType.WI_FI:
            return WiFiIcon;
        case MainAmenityIdType.POOL:
            return SwimmingPoolIcon;
        case MainAmenityIdType.CAR_PARK:
            return ParkingIcon;
        case MainAmenityIdType.AIR_CONDITIONING:
            return AcIcon;
        case MainAmenityIdType.GYM:
            return FitnessIcon;
        case MainAmenityIdType.PAYMENT_BY_CARD:
            return CardIcon;
        case MainAmenityIdType.BEACH_LINE:
            return BeachIcon;
        case MainAmenityIdType.AIR_DISINFECTION:
            return AirDisinfection;
        case MainAmenityIdType.SANITIZERS:
            return Sanitizers;
        case MainAmenityIdType.THERMOMETRY:
            return Thermometer;
        case MainAmenityIdType.PERSONAL_PROTECTIVE_GEAR:
            return Glove;
        case MainAmenityIdType.SAFETY_MARKING_FLOOR:
            return SocialDistance;
    }
}

export interface IMainAmenitiesProps extends IWithClassName, IWithQaAttributes {
    amenity: IHotelOrRoomAmenity;
}

const MainAmenity: FunctionComponent<IMainAmenitiesProps> = ({
    amenity: {id, name},
    className,
    ...rest
}) => {
    if (Object.values(MainAmenityIdType).includes(id as MainAmenityIdType)) {
        const Icon = getIconByAmenityId(id as MainAmenityIdType);

        return (
            <TextWithIcon
                className={className}
                iconLeft={Icon}
                text={name}
                {...prepareQaAttributes(rest)}
            />
        );
    }

    return (
        <TextWithIcon
            className={className}
            iconLeft={Include}
            text={name}
            {...prepareQaAttributes(rest)}
        />
    );
};

export default MainAmenity;
