import {FunctionComponent} from 'react';

import {BookOfferBedsGroupsType} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import BedIcon from 'icons/16/Bed';

interface IBedsGroups {
    className?: string;
    bedsGroups: BookOfferBedsGroupsType;
}

const BedsGroups: FunctionComponent<IBedsGroups> = ({
    bedsGroups,
    className,
}) => {
    if (bedsGroups.length === 0) {
        return null;
    }

    const [firstBedsGroup] = bedsGroups;
    const {description} = firstBedsGroup;

    return (
        <section className={className} {...prepareQaAttributes('bedGroups')}>
            <TextWithIcon iconLeft={BedIcon} text={description} />
        </section>
    );
};

export default BedsGroups;
