import {Meta} from '@storybook/react/types-6-0';
import moment from 'moment';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ERefundType} from 'types/hotels/offer/IHotelOfferCancellationInfo';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {ROBOT} from 'utilities/dateUtils/formats';
import IPrice from 'utilities/currency/PriceInterface';

import DeferredPaymentScheduleTimeline from './DeferredPaymentScheduleTimeline';

export default {
    title: 'Hotels/DeferredPaymentScheduleTimeline',
} as Meta;

const price: IPrice = {value: 9999, currency: CurrencyType.RUB};

const deferredPaymentSchedule = {
    initialPayment: {
        amount: price,
        percentage: 10,
    },
    deferredPayments: [
        {
            amount: price,
            percentage: 15,
            paymentEndsAt: moment().add(10, 'day').format(),
            penaltyIfUnpaid: price,
        },
    ],
    zeroFirstPayment: false,
};

const checkinDate = moment().add(1, 'month').format(ROBOT);
const cancellationInfo = {
    hasFreeCancellation: true,
    refundType: ERefundType.FULLY_REFUNDABLE,
    refundRules: [],
};

export const Simple: TStorybookFunctionComponent = () => (
    <DeferredPaymentScheduleTimeline
        deferredPaymentSchedule={deferredPaymentSchedule}
        checkinDate={checkinDate}
        cancellationInfo={cancellationInfo}
    />
);

export const ZeroFirstPayment: TStorybookFunctionComponent = () => (
    <DeferredPaymentScheduleTimeline
        deferredPaymentSchedule={{
            ...deferredPaymentSchedule,
            zeroFirstPayment: true,
        }}
        checkinDate={checkinDate}
        cancellationInfo={cancellationInfo}
    />
);

export const EndOfFreeCancellationEndsBeforePaymentEndsAt: TStorybookFunctionComponent =
    () => (
        <DeferredPaymentScheduleTimeline
            deferredPaymentSchedule={deferredPaymentSchedule}
            checkinDate={checkinDate}
            cancellationInfo={{
                ...cancellationInfo,
                refundType: ERefundType.REFUNDABLE_WITH_PENALTY,
                refundRules: [
                    {
                        startsAt: moment().add(5, 'day').format(),
                        endsAt: moment().add(6, 'day').format(),
                        type: ERefundType.REFUNDABLE_WITH_PENALTY,
                        penalty: price,
                    },
                ],
            }}
        />
    );
