import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import BookHotelAmenities from './BookHotelAmenities';

export default {
    title: 'Hotels/BookHotelAmenities',
    component: BookHotelAmenities,
} as Meta;

const amenities = {
    '128': {id: 128, name: 'Бесплатная газета'},
    '131': {id: 131, name: 'Мини-бар'},
    '132': {id: 132, name: 'Кофеварка и/или чайник'},
    '133': {id: 133, name: 'Ежедневная уборка номера'},
    '135': {
        id: 135,
        name: 'Предоставляются гипоаллергенные постельные принадлежности',
    },
    '136': {id: 136, name: 'Телефон'},
};

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{width: '500px'}}>
        <BookHotelAmenities amenities={amenities} />
    </div>
);
Simple.parameters = {
    info: {
        title: 'Для демонстрации показываю с вариантом для тачей',
    },
};
