import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IBookOfferMeal} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import FoodIcon from 'icons/16/Food';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './BookMealInfo.scss';

interface IBookMealInfoProps extends IWithClassName {
    mealInfo: IBookOfferMeal;
    isSuccess?: boolean;
}

const BookMealInfo: FunctionComponent<IBookMealInfoProps> = ({
    className = '',
    mealInfo = {},
    isSuccess = false,
}) => {
    return 'name' in mealInfo ? (
        <TextWithIcon
            className={cx(className, {success: isSuccess})}
            iconLeft={FoodIcon}
            text={mealInfo.name}
            {...prepareQaAttributes({
                current: 'mealInfo',
            })}
        />
    ) : null;
};

export default BookMealInfo;
