import {PureComponent, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';
import {BookPartnerHotelAmenitiesType} from 'server/api/HotelsBookAPI/types/IBookOffer';

import * as i18nBlock from 'i18n/hotels-BookPartnerHotelInfo';

import cx from './BookPartnerHotelAmenities.scss';

const MAX_VIEW_AMENITIES = 8;

interface IBookPartnerHotelAmenitiesProps extends IWithClassName {
    amenities: BookPartnerHotelAmenitiesType;
}

interface IBookPartnerHotelAmenitiesState {
    canRenderAllInfo: boolean;
}

class BookPartnerHotelAmenities extends PureComponent<
    IBookPartnerHotelAmenitiesProps,
    IBookPartnerHotelAmenitiesState
> {
    static defaultProps = {
        className: '',
        amenities: {},
    };

    state: IBookPartnerHotelAmenitiesState = {
        canRenderAllInfo: false,
    };

    /* Handlers */

    handleToggleAmenitiesLabelClick = (): void => {
        this.toggleAmenitiesView();
    };

    toggleAmenitiesView = (): void => {
        this.setState(({canRenderAllInfo}) => ({
            canRenderAllInfo: !canRenderAllInfo,
        }));
    };

    /* Helpers and utilities */

    getAllAmenities(): {
        id: number;
        name: string;
    }[] {
        const {amenities} = this.props;

        return Object.values(amenities);
    }

    /* Render */

    renderAmenitiesList(): ReactNode {
        const {canRenderAllInfo} = this.state;
        const amenitiesList = this.getAllAmenities();
        const currentAmenitiesList = canRenderAllInfo
            ? amenitiesList
            : amenitiesList.slice(0, MAX_VIEW_AMENITIES);

        return (
            <div className={cx('amenitiesList')}>
                {currentAmenitiesList.map(({name, id}) => (
                    <div className={cx('amenity')} key={id}>
                        {name}
                    </div>
                ))}
            </div>
        );
    }

    renderToggleViewLabel(): ReactNode {
        const {canRenderAllInfo} = this.state;
        const amenitiesList = this.getAllAmenities();
        const canRenderToggleLabel =
            amenitiesList.length > MAX_VIEW_AMENITIES && !canRenderAllInfo;

        return (
            canRenderToggleLabel && (
                <div
                    className={cx('toggleLabel')}
                    onClick={this.handleToggleAmenitiesLabelClick}
                >
                    {i18nBlock.toggleAmenitiesLabel()}
                </div>
            )
        );
    }

    render(): ReactNode {
        const {className} = this.props;
        const amenitiesList = this.getAllAmenities();
        const canRenderAmenities = amenitiesList.length > 0;

        return (
            canRenderAmenities && (
                <section className={cx('root', className)}>
                    {this.renderAmenitiesList()}
                    {this.renderToggleViewLabel()}
                </section>
            )
        );
    }
}

export default BookPartnerHotelAmenities;
