import React from 'react';
import {useSelector} from 'react-redux';

import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {getUserPlusInfo} from 'selectors/common/userInfoSelector';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-plusPromo2021';

import PlusInfo from 'components/PlusInfo/PlusInfo';

import cx from './PlusInfoBlock.scss';

export interface IPlusInfoBlock extends IWithQaAttributes {
    topupPlusPoints: number | undefined;
    withdrawPlusPoints: number | undefined;
    currency?: CurrencyType;
    plusMode: EYandexPlusApplicationMode;
    priceClassName?: string;
}

const PlusInfoBlock: React.FC<IPlusInfoBlock> = props => {
    const {
        topupPlusPoints = 0,
        withdrawPlusPoints = 0,
        plusMode,
        currency,
        priceClassName,
    } = props;
    const isWithdraw = plusMode === EYandexPlusApplicationMode.WITHDRAW;
    const userPlusInfo = useSelector(getUserPlusInfo);
    const hasPlus = userPlusInfo.hasPlus;
    const popupTitle = isWithdraw
        ? i18nBlock.plusInfoTitleWithdraw()
        : i18nBlock.plusInfoTitle();

    const popupText = hasPlus
        ? i18nBlock.plusInfoTextV2()
        : i18nBlock.noPlusInfoText();

    return (
        <PlusInfo
            plusPoints={isWithdraw ? withdrawPlusPoints : topupPlusPoints}
            className={cx('plusInfo')}
            popupTitle={popupTitle}
            popupText={popupText}
            isDiscount={isWithdraw}
            currency={currency}
            priceClassName={priceClassName}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(PlusInfoBlock);
