import React, {ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IBookOfferPrice} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Price from 'components/Price/Price';

import cx from './PriceGroupItem.scss';

interface IPriceGroupItemProps extends IWithClassName, IWithQaAttributes {
    priceClassName?: string;
    price: IBookOfferPrice;
    pricePrefix?: string;
    prefixDelimiter?: string;
    labelNode: ReactNode;
    isNestedGroup?: boolean;
}

const PriceGroupItem: React.FC<IPriceGroupItemProps> = props => {
    const {
        className,
        priceClassName,
        labelNode,
        isNestedGroup,
        price: {amount, currency},
        pricePrefix,
        prefixDelimiter,
    } = props;

    const isValidPrice =
        typeof amount === 'string' || typeof amount === 'number';

    return (
        <div
            className={cx(className, 'root', {
                root_nested: isNestedGroup,
            })}
            {...prepareQaAttributes(props)}
        >
            {labelNode}
            {isValidPrice && (
                <Price
                    className={cx('priceGroupPrice', priceClassName)}
                    value={amount}
                    currency={currency}
                    prefix={pricePrefix}
                    prefixDelimiter={prefixDelimiter}
                    {...prepareQaAttributes({parent: props, current: 'price'})}
                />
            )}
        </div>
    );
};

export default PriceGroupItem;
