import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {INotAuthUserInfo} from 'reducers/common/commonReducerTypes';

import {CHAR_NBSP} from 'utilities/strings/charCodes';
import {EPassportMode, getPassportUrl} from 'utilities/url/getPassportUrl';
import {appendQueryParams} from 'utilities/url/appendQueryParams';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-BookPriceInfo';

import Card from 'components/Card/Card';
import Link from 'components/Link/Link';

export const RETURN_PARAM_NAME = 'returnFrom';
export const RETURN_PARAM_VALUE = 'auth';

interface IAuthCardProps extends IWithClassName, IWithQaAttributes {
    userInfo: INotAuthUserInfo;
    href: string;
}

const AuthCard: React.FC<IAuthCardProps> = ({
    className,
    href,
    userInfo: {passportPath},
    ...props
}) => (
    <Card className={className} x="4" y="3" border="normal">
        <span
            {...prepareQaAttributes({
                parent: props,
                current: 'authText',
            })}
        >
            {i18nBlock.promocodeDotAuth()}
            {CHAR_NBSP}
            <Link
                url={getPassportUrl({
                    mode: EPassportMode.AUTH,
                    passportHost: passportPath,
                    retpath: appendQueryParams(href, {
                        [RETURN_PARAM_NAME]: RETURN_PARAM_VALUE,
                    }),
                })}
            >
                {i18nBlock.promocodeDotAuthLink()}
            </Link>
        </span>
    </Card>
);

export default AuthCard;
