import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BookSearchParams from './BookSearchParams';

export default {
    title: 'Hotels/BookSearchParams',
    component: BookSearchParams,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <BookSearchParams
            // @ts-ignore
            hotelInfo={{
                checkin: {beginTime: '14:00'},
                checkout: {endTime: '12:00'},
            }}
            searchParams={{
                startDate: '2019-07-26',
                endDate: '2019-07-27',
                adults: 2,
                childrenAges: [5, 13],
            }}
            deviceType={deviceType}
        />
    );
};

export const WithoutLink: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <BookSearchParams
            // @ts-ignore
            hotelInfo={{
                checkin: {
                    beginTime: '14:00',
                    endTime: '22:00',
                },
                checkout: {
                    endTime: '12:00',
                },
            }}
            searchParams={{
                startDate: '2019-07-26',
                endDate: '2019-07-27',
                adults: 1,
                childrenAges: [],
            }}
            showChangeParamsLink={false}
            deviceType={deviceType}
        />
    );
};
