import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {IBookHotelSettlement} from 'server/api/HotelsBookAPI/types/IBookOffer';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BookSettlementInfo from './BookSettlementInfo';

export default {
    title: 'Hotels/BookSettlementInfo',
    component: BookSettlementInfo,
} as Meta;

const settlementInfo: IBookHotelSettlement = {
    instructions:
        '<p>Следующие платежи и залоги взимаются отелем во время оказания соответствующей услуги, при регистрации по прибытии или регистрации при отъезде. </p> <ul>      <li>Плата за трансфер до аэропорта для взрослого: 1100 RUB за транспортное средство (в одну сторону)</li> <li>Плата за трансфер до аэропорта для ребенка: 300 RUB</li>                        </ul> <p>Возможно, приведенный выше список неполон. Суммы платежей и залогов могут быть указаны без учета налога и могут быть изменены. </p>',
    mandatoryCharge:
        'Трансфер из аэропорта/в аэропорт предоставляется круглосуточно по требованию. Может взиматься дополнительная плата. Свяжитесь с объектом размещения заранее, чтобы сделать заказ и договориться об условиях.',
    optionalCharge:
        '<ul>  <li>Если для въезда в страну вам требуется виза, ваш отель в большинстве случаев предоставит вам необходимые документы для ее получения. За более подробной информацией обращайтесь в отель, контактная информация указана в подтверждении бронирования. За эти услуги может взиматься дополнительная плата, даже в случае последующей отмены бронирования. Все договоренности осуществляются исключительно между вами и отелем. </li> Граждане России: при заезде взрослые (от 14 лет и старше) должны предъявить действительный внутренний паспорт гражданина РФ (загранпаспорта и водительские удостоверения не принимаются). Для всех детей (до 14 лет) должны быть предъявлены свидетельства о рождении. Если ребенок путешествует с родственником (за исключением родителей) или опекуном, при заезде должны быть также предъявлены документы, подтверждающие его право сопровождать ребенка. Граждане иностранных государств: при заезде взрослые и дети должны предъявить действительные паспорт, визу и миграционную карту.<li>В отеле предоставляется трансфер от следующих точек: аэропорт (может взиматься дополнительная плата). Гостям необходимо предварительно сообщить сведения о своем путешествии в отель, используя контактную информацию из письма с подтверждением бронирования. </li>  </ul>',
    policyCheckinInfo: '',
    specialInstructions:
        'За размещение дополнительных гостей может взиматься доплата в зависимости от внутренних правил отеля.<br />При регистрации по прибытии необходимо предъявить официальное удостоверение личности с фотографией, а также кредитную (или дебетовую) карту или оставить залог наличными на случай возникновения непредвиденных затрат. <br />Выполнение особых запросов зависит от ситуации на момент регистрации по прибытии и не гарантируется. Может взиматься дополнительная плата. <ul>  </ul>',
};

export const Simple: TStorybookFunctionComponent = () => {
    const deviceType = useDeviceType();

    return (
        <div style={{width: '500px'}}>
            <BookSettlementInfo
                settlementInfo={settlementInfo}
                isMobile={deviceType.isMobile}
            />
        </div>
    );
};
