import React, {useState} from 'react';

import BottomSheet from 'components/BottomSheet/BottomSheet';

interface RenderTriggerNodeProps {
    input: {
        onClick: () => void;
    };
    meta: {
        visible: boolean;
        hideBottomSheet: () => void;
    };
}

type ToggleBottomSheetViewType = [
    boolean,
    {
        showBottomSheet: () => void;
        hideBottomSheet: () => void;
    },
];

interface IBottomSheetWithTriggerProps {
    className?: string;
    renderTriggerNode: (
        triggerProps: RenderTriggerNodeProps,
    ) => React.ReactNode;
}

const useToggleBottomSheetView = (
    initialState: boolean,
): ToggleBottomSheetViewType => {
    const [canRenderBottomSheet, setBottomSheetView] = useState(initialState);
    const showBottomSheet = () => setBottomSheetView(true);
    const hideBottomSheet = () => setBottomSheetView(false);

    return [
        canRenderBottomSheet,
        {
            showBottomSheet,
            hideBottomSheet,
        },
    ];
};

const BottomSheetWithTrigger: React.FC<IBottomSheetWithTriggerProps> =
    props => {
        const {className, renderTriggerNode, children} = props;
        const [canRenderBottomSheet, {showBottomSheet, hideBottomSheet}] =
            useToggleBottomSheetView(false);

        const handleTriggerClick = () => {
            showBottomSheet();
        };

        return (
            <div className={className}>
                {renderTriggerNode({
                    input: {
                        onClick: handleTriggerClick,
                    },
                    meta: {
                        hideBottomSheet,
                        visible: canRenderBottomSheet,
                    },
                })}
                <BottomSheet
                    isOpened={canRenderBottomSheet}
                    onClose={hideBottomSheet}
                >
                    {children}
                </BottomSheet>
            </div>
        );
    };

export default BottomSheetWithTrigger;
