import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {deviceModMobile} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-Budapesht';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import SerpBudapestBadgeM from 'icons/illustrations/SerpBudapestBadge/SerpBudapestBadgeM';

import cx from './BudapeshtBanner.scss';

interface IBudapeshtBanner extends IWithDeviceType, IWithQaAttributes {}

const BudapeshtBanner: React.FC<IBudapeshtBanner> = props => {
    const {deviceType} = props;

    return (
        <Flex
            className={cx('root', deviceModMobile('root', deviceType))}
            alignItems="center"
        >
            <SerpBudapestBadgeM className={cx('icon')} />
            <Text
                tag="div"
                className={cx('text')}
                size={deviceType.isMobile ? 'm' : 's'}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'budapeshtBanner',
                })}
            >
                {i18nBlock.budapeshtBannerText()}
            </Text>
        </Flex>
    );
};

export default React.memo(BudapeshtBanner);
