import React from 'react';

import {STOP_CORONA_VIRUS_LINK} from 'constants/urls/covid';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceModMobile} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/covidInfo';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import WarningFilled16 from 'icons/16/WarningFilled';
import WarningFilled24 from 'icons/24/WarningFilled';
import Link from 'components/Link/Link';

import cx from './CovidInfo.scss';

interface ICovidInfoProps
    extends IWithDeviceType,
        IWithClassName,
        IWithQaAttributes {
    text?: string;
}

const CovidInfo: React.FC<ICovidInfoProps> = ({
    deviceType,
    className,
    text,
    ...restProps
}) => {
    const Icon = deviceType.isMobile ? WarningFilled16 : WarningFilled24;
    const infoText =
        text ||
        insertJSXIntoKey(i18nBlock.infoText)({
            link: (
                <Link target="_blank" url={STOP_CORONA_VIRUS_LINK}>
                    {i18nBlock.checkText()}
                </Link>
            ),
        });

    return (
        <Flex
            className={cx('root', className)}
            flexDirection="row"
            alignItems="center"
            {...prepareQaAttributes(restProps)}
        >
            <Icon className={cx('icon')} />
            <Text
                className={cx('text', deviceModMobile('text', deviceType))}
                size={deviceType.isMobile ? 's' : 'm'}
            >
                {infoText}
            </Text>
        </Flex>
    );
};

export default CovidInfo;
