import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import HeartOutlineIconM from 'icons/24/HeartFilledSolid';

import cx from './FavoritesSolid.scss';

export interface IFavoritesSolidProps extends IWithClassName {
    isFavorite?: boolean;
    onClick?: () => void;
    size?: 'm';
    containerClassName?: string;
}

const ICONS_MAP = {
    m: HeartOutlineIconM,
};

const FavoritesSolid: React.FC<IFavoritesSolidProps> = ({
    isFavorite,
    onClick,
    size = 'm',
    containerClassName,
}) => {
    const Icon = ICONS_MAP[size];

    return (
        <div
            className={cx(
                'root',
                {root_checked: isFavorite},
                containerClassName,
            )}
            onClick={onClick}
            {...prepareQaAttributes('addToFavorite')}
        >
            <Icon />
        </div>
    );
};

export default FavoritesSolid;
