import {FunctionComponent, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/hotels-ForceLogin';

import Link from 'components/Link/Link';
import ForceLoginAuthLink from 'components/ForceLogin/ForceLoginAuthLink/ForceLoginAuthLink';

interface ILoginAndSaveMoneyProps extends IWithClassName {
    isBookPage?: boolean;
    isSearchPage?: boolean;
    hasBoyOffers?: boolean;
}

const LoginAndSaveMoney: FunctionComponent<ILoginAndSaveMoneyProps> = ({
    className,
    isBookPage,
    isSearchPage,
    hasBoyOffers,
}) => {
    const message = useMemo(() => {
        if (isBookPage) {
            return insertJSXIntoKey(i18nBlock.loginAndGetCashback)({
                plusLink: (
                    <Link target="_blank" url={'YANDEX_PLUS_URL'}>
                        {i18nBlock.plus()}
                    </Link>
                ),
            });
        }

        if (isSearchPage && hasBoyOffers) {
            return i18nBlock.loginAndSaveMoney();
        }

        return i18nBlock.logInAndGetOffersForYou();
    }, [isBookPage, isSearchPage, hasBoyOffers]);

    return <ForceLoginAuthLink className={className} message={message} />;
};

export default LoginAndSaveMoney;
