import {ComponentType, FunctionComponent} from 'react';
import _noop from 'lodash/noop';

import {IWithClassName} from 'types/withClassName';
import {IIconProps} from 'icons/types/icon';

import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text from 'components/Text/Text';
import LinkButton from 'components/LinkButton/LinkButton';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import LocationIcon from 'icons/16/Location';

import cx from './HotelAddress.scss';

export interface IHotelAddressProps
    extends IWithClassName,
        IWithDataQaAttribute {
    onClick?(): void;
    text: string;
    type?: 'text' | 'link';
    multiLine?: boolean;
    icon?: ComponentType<IIconProps>;
    textClassName?: string;
}

const HotelAddress: FunctionComponent<IHotelAddressProps> = ({
    className = '',
    text,
    type = 'text',
    onClick = _noop,
    multiLine = false,
    icon,
    textClassName,
}) => {
    const TextOrLink = type === 'text' ? Text : LinkButton;

    return text ? (
        <div
            className={cx('content', className, {
                content_multiline: multiLine,
            })}
            title={text}
            onClick={onClick}
            {...prepareQaAttributes('hotelAddress')}
        >
            <TextOrLink className={cx('address')} theme="normal">
                <TextWithIcon
                    className={cx('addressContent')}
                    spaceBetween={1}
                    text={text}
                    textClassName={textClassName}
                    iconLeft={icon || LocationIcon}
                    iconLeftClassName={cx('iconLeft', {
                        iconLeft_defaultIcon: !icon,
                    })}
                />
            </TextOrLink>
        </div>
    ) : null;
};

export default HotelAddress;
