import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-HotelAdvantages';

import Advantages from 'components/Advantages/Advantages';
import HotelKey from 'icons/illustrations/HotelKey/HotelKeyM';
import Choices from 'icons/illustrations/Choices/ChoicesM';
import HotelSerp from 'icons/illustrations/HotelSerp/HotelSerpM';
import SubscribeHotels from 'icons/illustrations/SubscribeHotels/SubscribeHotelsM';

interface IHotelAdvantages extends IWithClassName, IWithQaAttributes {}

const HotelAdvantages: React.FC<IHotelAdvantages> = props => {
    const {className} = props;

    return (
        <Advantages
            advantages={[
                {
                    title: i18nBlock.hotelsAdvantageHotelKeyTitle(),
                    description: i18nBlock.hotelsAdvantageHotelKeyDescription(),
                    IconComponent: HotelKey,
                    iconWidth: 120,
                    iconHeight: 120,
                },
                {
                    title: i18nBlock.hotelsAdvantageChoicesTitle(),
                    description: i18nBlock.hotelsAdvantageChoicesDescription(),
                    IconComponent: Choices,
                    iconWidth: 159,
                    iconHeight: 120,
                },
                {
                    title: i18nBlock.hotelsAdvantageHotelSerpTitle(),
                    description:
                        i18nBlock.hotelsAdvantageHotelSerpDescription(),
                    IconComponent: HotelSerp,
                    iconWidth: 143,
                    iconHeight: 120,
                },
                {
                    title: i18nBlock.hotelsAdvantageSubscribeTitle(),
                    description:
                        i18nBlock.hotelsAdvantageSubscribeDescription(),
                    IconComponent: SubscribeHotels,
                    iconWidth: 120,
                    iconHeight: 120,
                },
            ]}
            className={className}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(HotelAdvantages);
