import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IActiveHotel} from 'types/hotels/hotel/IActiveHotel';
import {IHotelWithOffers} from 'types/hotels/hotel/IHotelWithOffers';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {PermalinkType} from 'types/hotels/hotel/IHotel';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import HotelCardDesktop from './components/HotelCardDesktop/HotelCardDesktop';
import HotelCardMobile from './components/HotelCardMobile/HotelCardMobile';
import {EHotelsListSkeletonType} from 'projects/depreacted/hotels/components/HotelsList/HotelsList';

interface IFavoriteEvent {
    permalink: PermalinkType;
    isFavorite: boolean;
}

export interface IHotelCardProps extends IWithClassName, IWithQaAttributes {
    hotelWithOffers: IHotelWithOffers;
    offerRequestParams?: IRequiredOfferParams;
    nights: number;
    onHoverHotel?: (permalink: IActiveHotel | undefined) => void;
    onLeaveHotel?: () => void;
    onCardClick?: (searchedByUser: boolean) => void;
    isActive?: boolean;
    isLazyImagesCarousel?: boolean;
    onFavoriteClick?: (event: IFavoriteEvent) => void;
    renderOfferSkeleton?: boolean;
    skeletonType?: EHotelsListSkeletonType;
    currentPage?: 'search' | 'map';
}

const HotelCard: FunctionComponent<IHotelCardProps> = props => {
    const deviceType = useDeviceType();

    return deviceType.isDesktop ? (
        <HotelCardDesktop {...props} {...prepareQaAttributes(props)} />
    ) : (
        <HotelCardMobile {...props} {...prepareQaAttributes(props)} />
    );
};

export default HotelCard;
