import React, {FunctionComponent, useMemo} from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {convertHotelOrRoomImages} from 'projects/depreacted/hotels/utilities/prepareAndParseImages/prepareAndParseImages';

import Link from 'components/Link/Link';
import ImagesCarousel from 'components/ImagesCarousel/ImagesCarousel';
import HotelInfoSearchCard from 'projects/depreacted/hotels/components/HotelInfoSearchCard/HotelInfoSearchCard';

import HotelMinPriceOffer from '../HotelMinPriceOffer/HotelMinPriceOffer';
import {ICommonHotelCardWithMinPriceProps} from '../../HotelCardWithMinPrice';

import cx from './HotelCardWithMinPriceMobile.scss';

const HOTEL_IMAGE_SIZE_NAME = 'M';

const HotelCardWithMinPriceMobile: FunctionComponent<ICommonHotelCardWithMinPriceProps> =
    props => {
        const {
            className,
            cardUsagePage,
            hotelInfoClassName,
            hotelWithMinPrice,
            hotelUrl,
            linkTarget,
            hotelReviewsUrl,
            onClick,
        } = props;
        const {hotel, minPrice, nights, badges, hasOfferYandexPlus} =
            hotelWithMinPrice;
        const {permalink, images} = hotel;

        const convertedImages = useMemo(
            () => convertHotelOrRoomImages(images, HOTEL_IMAGE_SIZE_NAME),
            [images],
        );

        return (
            <section
                key={permalink}
                className={cx('hotelCard', className)}
                onClick={onClick}
                {...prepareQaAttributes(props)}
            >
                {Boolean(convertedImages && convertedImages.length > 0) && (
                    <ImagesCarousel
                        className={cx('slider')}
                        imageClassName={cx('slideImage')}
                        images={convertedImages}
                        isDesktop={false}
                        lazyLoad
                        isLoadImageOnViewportIntersect
                    />
                )}
                <div className={cx('content', hotelInfoClassName)}>
                    <Link
                        url={hotelUrl}
                        className={cx('hotelLink')}
                        target={linkTarget || '_self'}
                        rel="noopener noreferrer"
                    />
                    <HotelInfoSearchCard
                        className={cx('hotelInfo')}
                        hotel={hotel}
                        hotelUrl={hotelUrl}
                        hotelReviewsUrl={hotelReviewsUrl}
                        cardUsagePage={cardUsagePage}
                    />
                    <HotelMinPriceOffer
                        className={cx('priceInfo')}
                        minPrice={minPrice}
                        hotelUrl={hotelUrl}
                        nights={nights}
                        badges={badges}
                        hasOfferYandexPlus={hasOfferYandexPlus}
                        linkTarget={linkTarget}
                        {...prepareQaAttributes(props)}
                    />
                </div>
            </section>
        );
    };

export default React.memo(HotelCardWithMinPriceMobile);
