import React from 'react';

import {IIconProps} from 'icons/types/icon';
import {EHotelGeoFeatureIcon} from 'types/hotels/hotel/IHotel';

import BeachIcon from 'icons/16/Beach';
import BasePlaneIcon from 'icons/16/Plane';
import ExternalAreaIcon from 'icons/16/ExternalArea';
import GeolocationIcon from 'icons/16/Geolocation';
import GeolocationOutlineIcon from 'icons/16/GeolocationOutline';

const PlaneIcon: React.FC<IIconProps> = props => (
    <BasePlaneIcon
        {...props}
        style={{...props.style, transform: 'rotate(-30deg)'}}
    />
);

export function getGeoFeatureIconComponent(
    icon: EHotelGeoFeatureIcon,
    isMobile?: boolean,
): React.ComponentType<IIconProps> {
    switch (icon) {
        case EHotelGeoFeatureIcon.SEA: {
            return BeachIcon;
        }

        case EHotelGeoFeatureIcon.PARK: {
            return ExternalAreaIcon;
        }

        case EHotelGeoFeatureIcon.AIRPORT: {
            return PlaneIcon;
        }

        default: {
            return isMobile ? GeolocationOutlineIcon : GeolocationIcon;
        }
    }
}
