import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IIconProps} from 'icons/types/icon';

import NoHotelPhotoM from 'icons/illustrations/NoHotelPhoto/NoHotelPhotoM';

import cx from './HotelImageStub.scss';

interface IHotelImageStubProps extends IWithClassName {
    /** Подпись под картинкой */
    captionText?: string;
    /** Пропсы, которые прокидываются дальше в иллюстрацию */
    illustrationProps?: IIconProps;
    onClick?: () => void;
}

const HotelImageStub: React.FC<IHotelImageStubProps> = props => {
    return (
        <div className={cx('root', props.className)} onClick={props.onClick}>
            <NoHotelPhotoM
                className={cx('buildingIllustration')}
                {...props.illustrationProps}
            />
            {Boolean(props.captionText) && (
                <div className={cx('captionText')}>{props.captionText}</div>
            )}
        </div>
    );
};

export default HotelImageStub;
