import {ComponentType} from 'react';

import {EHotelBadgeType} from 'types/hotels/offer/IHotelOffer';
import {IIconProps} from 'icons/types/icon';

import GiftIcon from 'icons/12/Gift';
import MirCardIcon from 'icons/12/MirCard';

export default function getIcon(
    id: EHotelBadgeType,
): ComponentType<IIconProps> | null {
    switch (id) {
        case EHotelBadgeType.TAXI_PROMOCODE: {
            return GiftIcon;
        }

        case EHotelBadgeType.MIR_CASHBACK: {
            return MirCardIcon;
        }

        default:
            return null;
    }
}
