import {FunctionComponent} from 'react';

import {IHotelOrOfferBadge} from 'types/hotels/offer/IHotelOffer';
import {IWithClassName} from 'types/withClassName';

import getVisibleHotelBadges from 'projects/depreacted/hotels/utilities/getHotelBadges/getVisibleHotelBadges';

import Flex, {IFlexProps} from 'components/Flex/Flex';
import HotelOfferBadge from 'projects/depreacted/hotels/components/HotelOfferBadge/HotelOfferBadge';

import {useWelcomePromocode} from 'projects/depreacted/hotels/hooks/useWelcomePromocode';

interface IHotelOfferBadgesProps
    extends IWithClassName,
        Pick<IFlexProps, 'alignItems' | 'above' | 'below'> {
    badges: IHotelOrOfferBadge[] | undefined;
    badgeClassName?: string;
    isYandexOffer?: boolean;
}

const HotelOfferBadges: FunctionComponent<IHotelOfferBadgesProps> = props => {
    const {
        badges,
        className,
        alignItems = 'flex-start',
        above,
        below,
        isYandexOffer,
        badgeClassName,
    } = props;

    const hasWelcomePromocode = useWelcomePromocode();

    const visibleBadges = getVisibleHotelBadges(badges, {
        hasFirstPromocode: hasWelcomePromocode && isYandexOffer,
    });

    if (!visibleBadges.length) {
        return null;
    }

    return (
        <Flex
            className={className}
            flexDirection="column"
            alignItems={alignItems}
            between={1}
            above={above}
            below={below}
        >
            {visibleBadges.map(badge => (
                <HotelOfferBadge
                    key={badge.id}
                    badge={badge}
                    className={badgeClassName}
                />
            ))}
        </Flex>
    );
};

export default HotelOfferBadges;
