import {FunctionComponent} from 'react';
import {useSelector} from 'react-redux';

import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {HotelRoomOfferType} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';

import experimentsSelector from 'selectors/common/experimentsSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import OfferMealInfo from 'projects/depreacted/hotels/components/OfferMealInfo/OfferMealInfo';
import HotelsCancellationInfo, {
    EFormatLabel,
} from 'projects/depreacted/hotels/components/HotelsCancellationInfo/HotelsCancellationInfo';

export interface IHotelOfferLabelsProps extends IWithQaAttributes {
    offer: IHotelOffer | HotelRoomOfferType;
    mealLabelClassName?: string;
    cancellationLabelClassName?: string;
    cancellationTextWithIconClassName?: string;
    formatCancellationInfoLabel?: EFormatLabel;
    isMealIconHidden?: boolean;
    shortCancellationDate?: boolean;
}

const HotelOfferLabels: FunctionComponent<IHotelOfferLabelsProps> = props => {
    const {
        offer,
        mealLabelClassName,
        cancellationLabelClassName,
        cancellationTextWithIconClassName,
        shortCancellationDate,
        formatCancellationInfoLabel,
        isMealIconHidden,
    } = props;
    const {mealType, cancellationInfo, yandexOffer} = offer;
    const {roomsMatching} = useSelector(experimentsSelector);

    return (
        <>
            {mealType && (
                <OfferMealInfo
                    className={mealLabelClassName}
                    size="m"
                    mealInfo={mealType}
                    isIconHidden={isMealIconHidden}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'offerMealInfo',
                    })}
                />
            )}
            {cancellationInfo && (
                <HotelsCancellationInfo
                    className={cancellationLabelClassName}
                    textWithIconClassName={cancellationTextWithIconClassName}
                    formatLabel={formatCancellationInfoLabel}
                    canRenderOnlyFullyRefundable={
                        !yandexOffer && !roomsMatching
                    }
                    cancellationInfo={cancellationInfo}
                    shortDate={shortCancellationDate}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'hotelsCancellationInfo',
                    })}
                />
            )}
        </>
    );
};

export default HotelOfferLabels;
