import {IHotelsOperator} from 'types/hotels/offer/IHotelsOperator';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {getOperatorLinkPropsByParams} from 'projects/depreacted/hotels/utilities/getOperatorLinkPropsByParams/getOperatorLinkPropsByParams';

import TravelImage from 'components/TravelImage/TravelImage';
import Link from 'components/Link/Link';

/* Init Styles */
import cx from './HotelOperator.scss';

/* Component Types */
interface IHotelOperatorProps extends IWithClassName, IWithQaAttributes {
    operator: IHotelsOperator;
    partnerUrl: string;
    theme?: 'black' | 'ghost';
    size?: 'xs' | 's' | 'm' | 'l';
    align?: 'left' | 'right';
    onClick?: () => void;
    isHeadless?: boolean;
    iconClassName?: string;
}

const HotelOperator = (props: IHotelOperatorProps) => {
    const {
        operator: {name, iconUrl},
        partnerUrl,
        theme = 'black',
        size = 'm',
        align = 'left',
        onClick,
        isHeadless,
        className,
        iconClassName,
    } = props;

    return (
        <Link
            theme={theme}
            className={cx(
                'root',
                `root_theme_${theme}`,
                `root_size_${size}`,
                `root_align_${align}`,
                className,
            )}
            url={partnerUrl}
            onClick={onClick}
            target="_blank"
            {...getOperatorLinkPropsByParams({isHeadless})}
            {...prepareQaAttributes(props)}
        >
            <TravelImage
                src={iconUrl}
                className={cx('icon', iconClassName)}
                imageClassName={cx('iconImage')}
                loaderClassName={cx('iconLoader')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'icon',
                })}
            />
            <div
                className={cx('operatorName')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'name',
                })}
            >
                {name}
            </div>
        </Link>
    );
};

export default HotelOperator;
