import React from 'react';

import {BLOCKS} from './constants';

import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-Budapesht';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';
import HotelPageBudapeshtBlock from './components/HotelPageBudapeshtBlock/HotelPageBudapeshtBlock';
import Separator from 'components/Separator/Separator';

import cx from './HotelPageBudapeshtCards.scss';

interface IHotelPageBudapeshtCardsProps
    extends IWithDeviceType,
        IWithQaAttributes {}

const HotelPageBudapeshtCards: React.FC<IHotelPageBudapeshtCardsProps> =
    props => {
        const {deviceType} = props;

        if (deviceType.isMobile) {
            return (
                <>
                    <Separator margin={4} />
                    <Heading level={2} className={cx('budapeshtBlockTitle')}>
                        {i18nBlock.hotelsBudapeshtGuestsTitle()}
                    </Heading>
                    <Text
                        tag="div"
                        className={cx('budapeshtSubTitle')}
                        size="l"
                    >
                        {i18nBlock.budapeshtBannerTextMobile()}
                    </Text>
                    <HorizontalScroller>
                        <Flex
                            flexDirection="row"
                            {...prepareQaAttributes(props)}
                        >
                            {BLOCKS.map((data, index) => (
                                <HotelPageBudapeshtBlock
                                    key={index}
                                    data={data}
                                    deviceType={deviceType}
                                    {...prepareQaAttributes({
                                        parent: props,
                                        key: index,
                                    })}
                                />
                            ))}
                        </Flex>
                    </HorizontalScroller>
                </>
            );
        }

        return (
            <Flex {...prepareQaAttributes(props)}>
                {BLOCKS.map((data, index) => (
                    <HotelPageBudapeshtBlock
                        key={index}
                        data={data}
                        deviceType={deviceType}
                        {...prepareQaAttributes({
                            parent: props,
                            key: index,
                        })}
                    />
                ))}
            </Flex>
        );
    };

export default HotelPageBudapeshtCards;
