import React from 'react';

import {TBudapeshtBlock} from '../../types';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceModMobile} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import cx from './HotelPageBudapeshtBlock.scss';

export interface IHotelPageBudapeshtBlockProps
    extends IWithDeviceType,
        IWithQaAttributes {
    data: TBudapeshtBlock;
    withCarousel?: boolean;
}

const HotelPageBudapeshtBlock: React.FC<IHotelPageBudapeshtBlockProps> =
    props => {
        const {
            data: {title, text, icons, bgImage},
            withCarousel,
            deviceType,
        } = props;

        return (
            <Box
                className={cx(
                    'budapeshtCard',
                    deviceModMobile('budapeshtCard', deviceType),
                    {
                        budapeshtCard_with_carousel: withCarousel,
                    },
                )}
                style={{backgroundImage: `url(${bgImage.url})`}}
            >
                <Text
                    className={cx('budapeshtTitle')}
                    tag="div"
                    {...prepareQaAttributes({parent: props, current: 'title'})}
                >
                    {title}
                </Text>
                <Text tag="div" size="s">
                    {text}
                </Text>
                <Flex justifyContent="flex-start" above={2}>
                    {icons.map(({icon: Icon, width}, index) => (
                        <Icon
                            className={cx('budapeshtIcon')}
                            height="24"
                            width={width}
                            key={index}
                        />
                    ))}
                </Flex>
            </Box>
        );
    };

export default HotelPageBudapeshtBlock;
