import {connect} from 'react-redux';

import {StoreInterface} from 'reducers/storeTypes';
import {
    setHotelReviewReactionRequestActions,
    SetHotelReviewReactionRequestActionType,
    setHotelReviewInfoReactionAction,
    SetHotelReviewInfoReactionActionType,
    sortingHotelReviewsAction,
    SortingHotelReviewsActionType,
} from 'reducers/depreacted/hotels/hotelPage/reviews/list/actions';
import {TUserInfo} from 'reducers/common/commonReducerTypes';
import {IHotelReviewsListReducer} from 'reducers/depreacted/hotels/hotelPage/reviews/list/reducer';

import {getUserInfo} from 'selectors/common/userInfoSelector';
import {getHotelReviews} from 'selectors/depreacted/hotels/hotel/reviewsTab/getHotelReviews';

import HotelReviews from './HotelReviews';

const mapStateToProps = (state: StoreInterface) => ({
    userInfo: getUserInfo(state),
    hotelReviews: getHotelReviews(state),
});

const mapDispatchToProps = {
    setHotelReviewReaction: setHotelReviewInfoReactionAction,
    setHotelReviewReactionRequest: setHotelReviewReactionRequestActions.request,
    sortingHotelReviews: sortingHotelReviewsAction,
};

interface IHotelReviewsStateContainer {
    userInfo: TUserInfo;
    hotelReviews: IHotelReviewsListReducer;
}

interface IHotelReviewsDispatchContainer {
    setHotelReviewReaction: SetHotelReviewInfoReactionActionType;
    setHotelReviewReactionRequest: SetHotelReviewReactionRequestActionType;
    sortingHotelReviews: SortingHotelReviewsActionType;
}

export type IHotelReviewsContainer = IHotelReviewsDispatchContainer &
    IHotelReviewsStateContainer;

export default connect<
    IHotelReviewsStateContainer,
    IHotelReviewsDispatchContainer,
    {},
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(HotelReviews);
