import {connect} from 'react-redux';

import {TExperiments} from 'server/providers/experiments/types';

import {StoreInterface} from 'reducers/storeTypes';
import {
    setHotelReviewReactionRequestActions,
    SetHotelReviewReactionRequestActionType,
    setHotelReviewInfoReactionAction,
    SetHotelReviewInfoReactionActionType,
    sortingHotelReviewsAction,
    SortingHotelReviewsActionType,
    getHotelReviewsActions,
    GetHotelReviewsActionType,
    filterHotelReviewsActions,
    FilterHotelReviewsActionType,
} from 'reducers/depreacted/hotels/hotelPage/reviews/list/actions';
import {TUserInfo} from 'reducers/common/commonReducerTypes';
import {IHotelReviewsListReducer} from 'reducers/depreacted/hotels/hotelPage/reviews/list/reducer';

import {getUserInfo} from 'selectors/common/userInfoSelector';
import experimentsSelector from 'selectors/common/experimentsSelector';
import {getHotelReviews} from 'selectors/depreacted/hotels/hotel/reviewsTab/getHotelReviews';
import {getHotelRating} from 'selectors/depreacted/hotels/hotel/reviewsTab/getHotelRating';

import HotelReviewsRedesign from './HotelReviewsRedesign';

const mapStateToProps = (state: StoreInterface) => ({
    userInfo: getUserInfo(state),
    hotelReviews: getHotelReviews(state),
    experiments: experimentsSelector(state),
    rating: getHotelRating(state),
});

const mapDispatchToProps = {
    getHotelReviews: getHotelReviewsActions.request,
    filterHotelReviews: filterHotelReviewsActions,
    setHotelReviewReaction: setHotelReviewInfoReactionAction,
    setHotelReviewReactionRequest: setHotelReviewReactionRequestActions.request,
    sortingHotelReviews: sortingHotelReviewsAction,
};

interface IHotelReviewsStateContainer {
    userInfo: TUserInfo;
    hotelReviews: IHotelReviewsListReducer;
    rating: number | null;
    experiments: TExperiments;
}

interface IHotelReviewsDispatchContainer {
    getHotelReviews: GetHotelReviewsActionType;
    filterHotelReviews: FilterHotelReviewsActionType;
    setHotelReviewReaction: SetHotelReviewInfoReactionActionType;
    setHotelReviewReactionRequest: SetHotelReviewReactionRequestActionType;
    sortingHotelReviews: SortingHotelReviewsActionType;
}

export type IHotelReviewsContainer = IHotelReviewsDispatchContainer &
    IHotelReviewsStateContainer;

export default connect<
    IHotelReviewsStateContainer,
    IHotelReviewsDispatchContainer,
    {},
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(HotelReviewsRedesign);
